/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.mutable;

import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.MutableMap;
import dyvil.collection.impl.AbstractEnumMap;
import dyvil.collection.mutable.ArrayMap;
import dyvil.lang.LiteralConvertible;
import dyvil.reflect.types.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

@LiteralConvertible.FromClass
@LiteralConvertible.FromType
@LiteralConvertible.FromArray
public class EnumMap<K extends Enum<K>, V>
extends AbstractEnumMap<K, V>
implements MutableMap<K, V> {
    private static final long serialVersionUID = 1734016065128722262L;

    public static <K extends Enum<K>, V> @NonNull EnumMap<K, V> apply(@NonNull Type<K> type) {
        return new EnumMap<K, V>(type.erasure());
    }

    public static <K extends Enum<K>, V> @NonNull EnumMap<K, V> apply(@NonNull Class<K> type) {
        return new EnumMap<K, V>(type);
    }

    public static <K extends Enum<K>, V> @NonNull EnumMap<K, V> singleton(K key, V value) {
        return new EnumMap(EnumMap.getKeyType(key), (Enum[])new Object[]{key}, new Object[]{value}, 1);
    }

    @SafeVarargs
    public static <K extends Enum<K>, V> @NonNull EnumMap<K, V> apply(Entry<? extends K, ? extends V> ... entries) {
        return new EnumMap<K, V>(entries);
    }

    public static <K extends Enum<K>, V> @NonNull EnumMap<K, V> from(@NonNull Entry<? extends K, ? extends V> @NonNull [] entries) {
        return new EnumMap<K, V>(entries);
    }

    public static <K extends Enum<K>, V> @NonNull EnumMap<K, V> from(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> map) {
        return new EnumMap<K, V>(map);
    }

    public static <K extends Enum<K>, V> @NonNull EnumMap<K, V> from(@NonNull AbstractEnumMap<? extends K, ? extends V> map) {
        return new EnumMap<K, V>(map);
    }

    @DyvilModifiers(value=0x100000L)
    private EnumMap(@NonNull Class<K> type, K @NonNull [] keys, V @NonNull [] values, int size) {
        super(type, keys, (Object[])values, size);
    }

    public EnumMap(@NonNull Class<K> type) {
        super(type);
    }

    public EnumMap(@NonNull Type<K> type) {
        super(type.erasure());
    }

    public EnumMap(@NonNull Entry<? extends K, ? extends V> @NonNull [] entries) {
        super(entries);
    }

    public EnumMap(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> map) {
        super(map);
    }

    public EnumMap(@NonNull AbstractEnumMap<? extends K, ? extends V> map) {
        super(map);
    }

    @Override
    protected void removeAt(int index) {
        this.values[index] = null;
        --this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.values, null);
    }

    @Override
    public @Nullable V put(@NonNull K key, V value) {
        if (!EnumMap.checkType(this.type, key)) {
            return null;
        }
        int index = EnumMap.index(key);
        Object oldValue = this.values[index];
        this.values[index] = value;
        if (oldValue == null) {
            ++this.size;
        }
        return (V)oldValue;
    }

    @Override
    public @Nullable V putIfAbsent(@NonNull K key, V value) {
        if (!EnumMap.checkType(this.type, key)) {
            return null;
        }
        int index = EnumMap.index(key);
        Object thisValue = this.values[index];
        if (thisValue == null) {
            this.values[index] = value;
            ++this.size;
            return value;
        }
        return (V)thisValue;
    }

    @Override
    public boolean replace(@NonNull K key, V oldValue, V newValue) {
        if (!EnumMap.checkType(this.type, key)) {
            return false;
        }
        int index = EnumMap.index(key);
        Object value = this.values[index];
        if (value == null || !Objects.equals(value, newValue)) {
            return false;
        }
        this.values[index] = newValue;
        return true;
    }

    @Override
    public @Nullable V replace(@NonNull K key, V newValue) {
        if (!EnumMap.checkType(this.type, key)) {
            return null;
        }
        int index = EnumMap.index(key);
        Object oldValue = this.values[index];
        if (oldValue == null) {
            return null;
        }
        this.values[index] = newValue;
        return (V)oldValue;
    }

    @Override
    public @Nullable V removeKey(@NonNull Object key) {
        if (!EnumMap.checkType(this.type, key)) {
            return null;
        }
        int index = EnumMap.index(key);
        Object oldValue = this.values[index];
        if (oldValue != null) {
            --this.size;
            this.values[index] = null;
            return (V)oldValue;
        }
        return null;
    }

    @Override
    public boolean remove(@NonNull Object key, Object value) {
        if (!EnumMap.checkType(this.type, key)) {
            return false;
        }
        int index = EnumMap.index(key);
        Object oldValue = this.values[index];
        if (oldValue != null && oldValue.equals(value)) {
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeValue(Object value) {
        boolean removed = false;
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (!Objects.equals(this.values[i], value)) continue;
            --this.size;
            this.values[i] = null;
            removed = true;
        }
        return removed;
    }

    @Override
    public void mapValues(@NonNull BiFunction<? super K, ? super V, ? extends V> mapper) {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            Object v = this.values[i];
            if (v == null) continue;
            this.values[i] = mapper.apply(this.keys[i], v);
        }
    }

    @Override
    public void filter(@NonNull BiPredicate<? super K, ? super V> condition) {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            Object v = this.values[i];
            if (v == null || condition.test(this.keys[i], v)) continue;
            this.values[i] = null;
            --this.size;
        }
    }

    @Override
    public <U, R> @NonNull MutableMap<U, R> entryMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Entry<? extends U, ? extends R>> mapper) {
        ArrayMap<? extends U, ? extends R> map = new ArrayMap<U, R>(this.size);
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            Entry<? extends U, ? extends R> entry;
            Object v = this.values[i];
            if (v == null || (entry = mapper.apply(this.keys[i], v)) == null) continue;
            map.put(entry);
        }
        return map;
    }

    @Override
    public <U, R> MutableMap<U, R> flatMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Iterable<? extends @NonNull Entry<? extends U, ? extends R>>> mapper) {
        MutableMap<Object, R> map = MutableMap.withCapacity(this.size << 2);
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            Object v = this.values[i];
            if (v == null) continue;
            for (Entry<Object, R> entry : mapper.apply(this.keys[i], v)) {
                map.put(entry);
            }
        }
        return map;
    }

    @Override
    public @NonNull MutableMap<K, V> copy() {
        return this.mutableCopy();
    }

    @Override
    public @NonNull ImmutableMap<K, V> immutable() {
        return this.immutableCopy();
    }
}

