/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.mutable;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.collection.ImmutableSet;
import dyvil.collection.MutableSet;
import dyvil.collection.SizedIterable;
import dyvil.collection.impl.AbstractBitSet;
import dyvil.lang.LiteralConvertible;
import java.util.Iterator;
import java.util.function.Function;

@Immutable
@LiteralConvertible.FromArray
public class BitSet
extends AbstractBitSet
implements MutableSet<Integer> {
    public BitSet() {
    }

    public BitSet(int capacity) {
        super(capacity);
    }

    public BitSet(int @NonNull [] elements) {
        super(elements);
    }

    public BitSet(@NonNull Iterable<? extends Integer> iterable) {
        super(iterable);
    }

    public BitSet(@NonNull SizedIterable<? extends Integer> iterable) {
        super(iterable);
    }

    public BitSet(@NonNull AbstractBitSet bitSet) {
        super(bitSet);
    }

    public static @NonNull BitSet apply() {
        return new BitSet();
    }

    public static @NonNull BitSet apply(int ... elements) {
        return new BitSet(elements);
    }

    public static @NonNull BitSet from(int @NonNull [] array) {
        return new BitSet(array);
    }

    public static @NonNull BitSet from(@NonNull Iterable<? extends Integer> iterable) {
        return new BitSet(iterable);
    }

    public static @NonNull BitSet from(@NonNull SizedIterable<? extends Integer> iterable) {
        return new BitSet(iterable);
    }

    public static @NonNull BitSet from(@NonNull AbstractBitSet bitSet) {
        return new BitSet(bitSet);
    }

    @Override
    public void clear() {
        this.size = 0;
        int n = this.words.length;
        for (int i = 0; i < n; ++i) {
            this.words[i] = 0L;
        }
    }

    @Override
    public boolean add(int element) {
        if (this.bitSet(element)) {
            return false;
        }
        this.setBit(element);
        return true;
    }

    @Override
    public boolean remove(@Primitive Object element) {
        if (!(element instanceof Integer)) {
            return false;
        }
        int bit = (Integer)element;
        if (!this.bitSet(bit)) {
            return false;
        }
        this.clearBit(bit);
        return true;
    }

    @Override
    public void removeAt(int bit) {
        this.clearBit(bit);
    }

    @Override
    public void map(@NonNull Function<? super Integer, ? extends Integer> mapper) {
        int[] ints = this.toIntArray();
        this.clear();
        int n = ints.length;
        if (n > 0) {
            int n2 = 0;
            do {
                int i = ints[n2];
                this.add(mapper.apply((Integer)i));
            } while (++n2 < n);
        }
    }

    @Override
    public void flatMap(@NonNull Function<? super Integer, ? extends @NonNull Iterable<? extends Integer>> mapper) {
        int[] ints = this.toIntArray();
        this.clear();
        int n = ints.length;
        if (n > 0) {
            int n2 = 0;
            do {
                int i = ints[n2];
                Iterator<? extends Integer> iterator = mapper.apply((Integer)i).iterator();
                while (iterator.hasNext()) {
                    int newValue = iterator.next();
                    this.add(newValue);
                }
            } while (++n2 < n);
        }
    }

    @Override
    public @NonNull MutableSet<@Primitive Integer> copy() {
        return this.mutableCopy();
    }

    @Override
    public @NonNull ImmutableSet<@Primitive Integer> immutable() {
        return this.immutableCopy();
    }
}

