/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.mutable;

import dyvil.annotation.internal.NonNull;
import dyvil.collection.Collection;
import dyvil.collection.ImmutableSet;
import dyvil.collection.MutableSet;
import dyvil.collection.Set;
import dyvil.collection.impl.AbstractArraySet;
import dyvil.lang.LiteralConvertible;
import java.util.Objects;
import java.util.function.Function;

@LiteralConvertible.FromArray
public class ArraySet<E>
extends AbstractArraySet<E>
implements MutableSet<E> {
    private static final long serialVersionUID = -6676561653968567088L;

    public static <E> @NonNull ArraySet<E> apply() {
        return new ArraySet<E>();
    }

    @SafeVarargs
    public static <E> @NonNull ArraySet<E> apply(E ... elements) {
        return new ArraySet<E>(elements, true);
    }

    public static <E> @NonNull ArraySet<E> from(E[] array) {
        return new ArraySet<E>(array);
    }

    public static <E> @NonNull ArraySet<E> from(@NonNull Iterable<? extends E> iterable) {
        return new ArraySet<E>(iterable);
    }

    public static <E> @NonNull ArraySet<E> from(@NonNull Collection<? extends E> collection) {
        return new ArraySet<E>(collection);
    }

    public static <E> @NonNull ArraySet<E> from(@NonNull Set<? extends E> set) {
        return new ArraySet<E>(set);
    }

    public static <E> @NonNull ArraySet<E> from(@NonNull AbstractArraySet<? extends E> arraySet) {
        return new ArraySet<E>(arraySet);
    }

    public ArraySet() {
    }

    public ArraySet(int capacity) {
        super(capacity);
    }

    public ArraySet(E[] elements) {
        super(elements);
    }

    public ArraySet(E @NonNull [] elements, int size) {
        super(elements, size);
    }

    public ArraySet(E @NonNull [] elements, boolean trusted) {
        super(elements, trusted);
    }

    public ArraySet(E[] elements, int size, boolean trusted) {
        super(elements, size, trusted);
    }

    public ArraySet(@NonNull Iterable<? extends E> iterable) {
        super(iterable);
    }

    public ArraySet(@NonNull Collection<? extends E> collection) {
        super(collection);
    }

    public ArraySet(@NonNull Set<? extends E> set) {
        super(set);
    }

    public ArraySet(@NonNull AbstractArraySet<? extends E> arraySet) {
        super(arraySet);
    }

    @Override
    public void clear() {
        this.size = 0;
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = null;
        }
    }

    @Override
    public boolean add(E element) {
        return this.addInternal(element);
    }

    @Override
    public boolean remove(Object element) {
        for (int i = 0; i < this.size; ++i) {
            if (!Objects.equals(this.elements[i], element)) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    @Override
    protected void removeAt(int index) {
        int numMoved;
        if ((numMoved = --this.size - index) > 0) {
            System.arraycopy(this.elements, index + 1, this.elements, index, numMoved);
        }
        this.elements[this.size] = null;
    }

    @Override
    public void map(@NonNull Function<? super E, ? extends E> mapper) {
        this.mapImpl(mapper);
    }

    @Override
    public void flatMap(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends E>> mapper) {
        this.flatMapImpl(mapper);
    }

    @Override
    public @NonNull MutableSet<E> copy() {
        return this.mutableCopy();
    }

    @Override
    public @NonNull ImmutableSet<E> immutable() {
        return this.immutableCopy();
    }
}

