/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.mutable;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.Map;
import dyvil.collection.MutableMap;
import dyvil.collection.Set;
import dyvil.collection.SizedIterable;
import dyvil.collection.impl.AbstractArrayMap;
import dyvil.lang.LiteralConvertible;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

@LiteralConvertible.FromArray
public class ArrayMap<K, V>
extends AbstractArrayMap<K, V>
implements MutableMap<K, V> {
    private static final long serialVersionUID = 5171722024919718041L;

    public static <K, V> @NonNull ArrayMap<K, V> singleton(K key, V value) {
        ArrayMap<K, V> result = new ArrayMap<K, V>();
        result.putInternal(key, value);
        return result;
    }

    public static <K, V> @NonNull ArrayMap<K, V> apply() {
        return new ArrayMap<K, V>();
    }

    @SafeVarargs
    public static <K, V> @NonNull ArrayMap<K, V> apply(Entry<? extends K, ? extends V> ... entries) {
        return new ArrayMap<K, V>(entries);
    }

    public static <K, V> @NonNull ArrayMap<K, V> from(@NonNull Entry<? extends K, ? extends V> @NonNull [] array) {
        return new ArrayMap<K, V>(array);
    }

    public static <K, V> @NonNull ArrayMap<K, V> from(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        return new ArrayMap<K, V>(iterable);
    }

    public static <K, V> @NonNull ArrayMap<K, V> from(@NonNull SizedIterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        return new ArrayMap<K, V>(iterable);
    }

    public static <K, V> @NonNull ArrayMap<K, V> from(@NonNull Set<? extends @NonNull Entry<? extends K, ? extends V>> set) {
        return new ArrayMap<K, V>(set);
    }

    public static <K, V> @NonNull ArrayMap<K, V> from(@NonNull Map<? extends K, ? extends V> map) {
        return new ArrayMap<K, V>(map);
    }

    public static <K, V> @NonNull ArrayMap<K, V> from(@NonNull AbstractArrayMap<? extends K, ? extends V> arrayMap) {
        return new ArrayMap<K, V>(arrayMap);
    }

    public ArrayMap() {
    }

    public ArrayMap(int capacity) {
        super(capacity);
    }

    public ArrayMap(K @NonNull [] keys, V @NonNull [] values) {
        super(keys, values);
    }

    public ArrayMap(K @NonNull [] keys, V @NonNull [] values, int size) {
        super(keys, values, size);
    }

    public ArrayMap(K @NonNull [] keys, V @NonNull [] values, boolean trusted) {
        super(keys, values, trusted);
    }

    public ArrayMap(K[] keys, V[] values, int size, boolean trusted) {
        super(keys, values, size, trusted);
    }

    public ArrayMap(Entry<? extends K, ? extends V> @NonNull [] entries) {
        super(entries);
    }

    public ArrayMap(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        super(iterable);
    }

    public ArrayMap(@NonNull SizedIterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        super(iterable);
    }

    public ArrayMap(@NonNull Set<? extends @NonNull Entry<? extends K, ? extends V>> set) {
        super(set);
    }

    public ArrayMap(@NonNull Map<? extends K, ? extends V> map) {
        super(map);
    }

    public ArrayMap(@NonNull AbstractArrayMap<? extends K, ? extends V> arrayMap) {
        super(arrayMap);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = null;
            this.keys[i] = null;
        }
        this.size = 0;
    }

    @Override
    public @Nullable Entry<K, V> getEntry(final Object key) {
        int index = this.getIndex(key);
        if (index < 0) {
            return null;
        }
        return new Entry<K, V>(){

            @Override
            public @NonNull K getKey() {
                return key;
            }

            @Override
            public @NonNull V getValue() {
                return ArrayMap.this.values[ArrayMap.this.getIndex(key)];
            }
        };
    }

    @Override
    public @Nullable V put(K key, V value) {
        return this.putInternal(key, value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        for (int i = 0; i < this.size; ++i) {
            if (!Objects.equals(key, this.keys[i])) continue;
            return (V)this.values[i];
        }
        this.putNew(key, value);
        return value;
    }

    @Override
    public @Nullable V replace(K key, V newValue) {
        for (int i = 0; i < this.size; ++i) {
            if (!Objects.equals(key, this.keys[i])) continue;
            Object oldValue = this.values[i];
            this.values[i] = newValue;
            return (V)oldValue;
        }
        return null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        for (int i = 0; i < this.size; ++i) {
            if (!Objects.equals(key, this.keys[i])) continue;
            if (!Objects.equals(oldValue, this.values[i])) {
                return false;
            }
            this.values[i] = newValue;
            return true;
        }
        return false;
    }

    @Override
    protected void removeAt(int index) {
        int numMoved;
        if ((numMoved = --this.size - index) > 0) {
            System.arraycopy(this.keys, index + 1, this.keys, index, numMoved);
            System.arraycopy(this.values, index + 1, this.values, index, numMoved);
        }
        this.values[this.size] = null;
        this.keys[this.size] = null;
    }

    @Override
    public @Nullable V removeKey(Object key) {
        for (int i = 0; i < this.size; ++i) {
            if (!Objects.equals(key, this.keys[i])) continue;
            Object oldValue = this.values[i];
            this.removeAt(i);
            return (V)oldValue;
        }
        return null;
    }

    @Override
    public boolean removeValue(Object value) {
        for (int i = 0; i < this.size; ++i) {
            if (!Objects.equals(value, this.values[i])) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object key, Object value) {
        for (int i = 0; i < this.size; ++i) {
            if (!Objects.equals(key, this.keys[i])) continue;
            if (Objects.equals(value, this.values[i])) {
                this.removeAt(i);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void mapValues(@NonNull BiFunction<? super K, ? super V, ? extends V> mapper) {
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = mapper.apply(this.keys[i], this.values[i]);
        }
    }

    @Override
    public void filter(@NonNull BiPredicate<? super K, ? super V> condition) {
        for (int i = 0; i < this.size; ++i) {
            if (condition.test(this.keys[i], this.values[i])) continue;
            this.removeAt(i--);
        }
    }

    @Override
    public @NonNull MutableMap<K, V> copy() {
        return this.mutableCopy();
    }

    @Override
    public @NonNull ImmutableMap<K, V> immutable() {
        return this.immutableCopy();
    }
}

