/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.iterator;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.NonNull;
import java.util.Iterator;
import java.util.NoSuchElementException;

@ClassParameters(names={"element"})
public class SingletonIterator<E>
implements Iterator<E> {
    protected final E element;
    protected boolean returned;

    public SingletonIterator(E element) {
        this.element = element;
    }

    public static <E> @NonNull SingletonIterator<E> apply(E element) {
        return new SingletonIterator<E>(element);
    }

    @Override
    public boolean hasNext() {
        return !this.returned;
    }

    @Override
    public E next() {
        if (this.returned) {
            throw new NoSuchElementException();
        }
        this.returned = true;
        return this.element;
    }
}

