/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.iterator;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.NonNull;
import java.util.Iterator;

@ClassParameters(names={"head", "tail"})
public class PrependIterator<E>
implements Iterator<E> {
    protected final E head;
    protected final @NonNull Iterator<? extends E> tail;
    protected boolean returned;

    public PrependIterator(E head, @NonNull Iterator<? extends E> tail) {
        this.head = head;
        this.tail = tail;
    }

    public static <E> @NonNull PrependIterator<E> apply(E head, @NonNull Iterator<? extends E> tail) {
        return new PrependIterator<E>(head, tail);
    }

    @Override
    public boolean hasNext() {
        return !this.returned || this.tail.hasNext();
    }

    @Override
    public E next() {
        if (this.returned) {
            return this.tail.next();
        }
        this.returned = true;
        return this.head;
    }

    public @NonNull String toString() {
        return new StringBuilder(59).append("PrependIterator(").append(this.head).append(", ").append(this.tail).append(")").toString();
    }
}

