/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.iterator;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.annotation.internal.Primitive;
import dyvil.tuple.Tuple;
import java.io.Serializable;
import java.util.Iterator;
import java.util.function.Function;

@DyvilModifiers(value=131072L)
@ClassParameters(names={"base", "mapper"})
public class MapIterator<E, R>
implements Iterator<R>,
Serializable {
    protected final @NonNull Iterator<? extends E> base;
    protected final @NonNull Function<? super E, ? extends R> mapper;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MapIterator mapIterator = (MapIterator)object;
        return this.base.equals(mapIterator.base) && this.mapper.equals(mapIterator.mapper);
    }

    public int hashCode() {
        Iterator<E> iterator = this.base;
        Function<E, R> function = this.mapper;
        return ((31 + (iterator != null ? iterator.hashCode() : 0)) * 31 + (function != null ? function.hashCode() : 0)) * 31;
    }

    public String toString() {
        return "MapIterator(" + this.base + ", " + this.mapper + ")";
    }

    @DyvilName(value="base")
    public @NonNull Iterator<? extends E> getBase() {
        return this.base;
    }

    @DyvilName(value="mapper")
    public @NonNull Function<? super E, ? extends R> getMapper() {
        return this.mapper;
    }

    public MapIterator(@NonNull Iterator<? extends E> base, @NonNull Function<? super E, ? extends R> mapper) {
        this.base = base;
        this.mapper = mapper;
    }

    @Override
    public boolean hasNext() {
        return this.base.hasNext();
    }

    @Override
    public R next() {
        return this.mapper.apply(this.base.next());
    }

    @Override
    public void remove() {
        this.base.remove();
    }

    public static final <E, R> @NonNull MapIterator<E, R> apply(@NonNull Iterator<? extends E> base, @NonNull Function<? super E, ? extends R> mapper) {
        return new MapIterator<E, R>(base, mapper);
    }

    public static final <E, R> @NonNull Tuple.Of2<@NonNull Iterator<? extends E>, @NonNull Function<? super E, ? extends R>> unapply(@NonNull MapIterator<E, R> value) {
        return new Tuple.Of2<Iterator<? extends E>, Function<? super E, ? extends R>>(value.base, value.mapper);
    }

    public static final <E, R> @Nullable Tuple.Of2<@NonNull Iterator<? extends E>, @NonNull Function<? super E, ? extends R>> unapply(@Primitive Object value) {
        return value instanceof MapIterator ? MapIterator.unapply((MapIterator)value) : null;
    }
}

