/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.iterator;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.annotation.internal.Primitive;
import dyvil.tuple.Tuple;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

@DyvilModifiers(value=131072L)
@ClassParameters(names={"base", "mapper"})
public class FlatMapIterator<E, R>
implements Iterator<R>,
Serializable {
    protected final @NonNull Iterator<? extends E> base;
    protected final @NonNull Function<? super E, ? extends @NonNull Iterator<? extends R>> mapper;
    protected @Nullable Iterator<? extends R> current;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FlatMapIterator flatMapIterator = (FlatMapIterator)object;
        return this.base.equals(flatMapIterator.base) && this.mapper.equals(flatMapIterator.mapper);
    }

    public int hashCode() {
        Iterator<E> iterator = this.base;
        Function<E, Iterator<R>> function = this.mapper;
        return ((31 + (iterator != null ? iterator.hashCode() : 0)) * 31 + (function != null ? function.hashCode() : 0)) * 31;
    }

    public String toString() {
        return "FlatMapIterator(" + this.base + ", " + this.mapper + ")";
    }

    @DyvilName(value="base")
    public @NonNull Iterator<? extends E> getBase() {
        return this.base;
    }

    @DyvilName(value="mapper")
    public @NonNull Function<? super E, ? extends @NonNull Iterator<? extends R>> getMapper() {
        return this.mapper;
    }

    public FlatMapIterator(@NonNull Iterator<? extends E> base, @NonNull Function<? super E, ? extends @NonNull Iterator<? extends R>> mapper) {
        this.base = base;
        this.mapper = mapper;
    }

    @Override
    public boolean hasNext() {
        Iterator<R> iterator = this.current;
        if (iterator != null && iterator.hasNext()) {
            return true;
        }
        if (!this.base.hasNext()) {
            return false;
        }
        this.current = this.mapper.apply(this.base.next());
        return this.current.hasNext();
    }

    @Override
    public R next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.current.next();
    }

    @Override
    public void remove() {
        Iterator<R> iterator = this.current;
        if (iterator == null) {
            throw new UnsupportedOperationException();
        }
        iterator.remove();
    }

    public static final <E, R> @NonNull FlatMapIterator<E, R> apply(@NonNull Iterator<? extends E> base, @NonNull Function<? super E, ? extends @NonNull Iterator<? extends R>> mapper) {
        return new FlatMapIterator<E, R>(base, mapper);
    }

    public static final <E, R> @NonNull Tuple.Of2<@NonNull Iterator<? extends E>, @NonNull Function<? super E, ? extends @NonNull Iterator<? extends R>>> unapply(@NonNull FlatMapIterator<E, R> value) {
        return new Tuple.Of2<Iterator<? extends E>, Function<? super E, ? extends Iterator<? extends R>>>(value.base, value.mapper);
    }

    public static final <E, R> @Nullable Tuple.Of2<@NonNull Iterator<? extends E>, @NonNull Function<? super E, ? extends @NonNull Iterator<? extends R>>> unapply(@Primitive Object value) {
        return value instanceof FlatMapIterator ? FlatMapIterator.unapply((FlatMapIterator)value) : null;
    }
}

