/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.iterator;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.annotation.internal.Primitive;
import dyvil.tuple.Tuple;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

@DyvilModifiers(value=131072L)
@ClassParameters(names={"base", "filter"})
public class FilterIterator<E>
implements Iterator<E>,
Serializable {
    protected final @NonNull Iterator<E> base;
    protected final @NonNull Predicate<? super E> filter;
    protected boolean nextAvailable;
    protected E next;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FilterIterator filterIterator = (FilterIterator)object;
        return this.base.equals(filterIterator.base) && this.filter.equals(filterIterator.filter);
    }

    public int hashCode() {
        Iterator<E> iterator = this.base;
        Predicate<E> predicate = this.filter;
        return ((31 + (iterator != null ? iterator.hashCode() : 0)) * 31 + (predicate != null ? predicate.hashCode() : 0)) * 31;
    }

    public String toString() {
        return "FilterIterator(" + this.base + ", " + this.filter + ")";
    }

    @DyvilName(value="base")
    public @NonNull Iterator<E> getBase() {
        return this.base;
    }

    @DyvilName(value="filter")
    public @NonNull Predicate<? super E> getFilter() {
        return this.filter;
    }

    public FilterIterator(@NonNull Iterator<E> base, @NonNull Predicate<? super E> filter) {
        this.base = base;
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        if (this.nextAvailable) {
            return true;
        }
        while (this.base.hasNext()) {
            E next = this.base.next();
            if (!this.filter.test(next)) continue;
            this.next = next;
            this.nextAvailable = true;
            return true;
        }
        return false;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.nextAvailable = false;
        return this.next;
    }

    public static final <E> @NonNull FilterIterator<E> apply(@NonNull Iterator<E> base, @NonNull Predicate<? super E> filter) {
        return new FilterIterator<E>(base, filter);
    }

    public static final <E> @NonNull Tuple.Of2<@NonNull Iterator<E>, @NonNull Predicate<? super E>> unapply(@NonNull FilterIterator<E> value) {
        return new Tuple.Of2<Iterator<E>, Predicate<? super E>>(value.base, value.filter);
    }

    public static final <E> @Nullable Tuple.Of2<@NonNull Iterator<E>, @NonNull Predicate<? super E>> unapply(@Primitive Object value) {
        return value instanceof FilterIterator ? FilterIterator.unapply((FilterIterator)value) : null;
    }
}

