/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.iterator;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.NonNull;
import dyvil.array.ObjectArray;
import java.util.Iterator;
import java.util.NoSuchElementException;

@ClassParameters(names={"parts"})
public class ConcatIterator<E>
implements Iterator<E> {
    @DyvilModifiers(value=262144L)
    protected final transient @NonNull Iterator<? extends E> @NonNull [] parts;
    protected int index;

    public ConcatIterator(Iterator<? extends E> ... parts) {
        this.parts = parts;
    }

    public static <E> @NonNull ConcatIterator<E> apply(Iterator<? extends E> ... parts) {
        return new ConcatIterator<E>(parts);
    }

    @Override
    public boolean hasNext() {
        int n = this.parts.length;
        for (int i = this.index; i < n; ++i) {
            if (!this.parts[i].hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public E next() {
        int size = this.parts.length;
        int n = size;
        for (int i = this.index; i < n; ++i) {
            Iterator<E> part = this.parts[i];
            if (!part.hasNext()) continue;
            this.index = i;
            return part.next();
        }
        this.index = size;
        throw new NoSuchElementException();
    }

    public @NonNull String toString() {
        StringBuilder stringBuilder = new StringBuilder(34).append("ConcatIterator");
        ObjectArray.toString(this.parts, stringBuilder);
        return stringBuilder.append("").toString();
    }
}

