/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.iterator;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.NonNull;
import dyvil.array.ObjectArray;
import java.util.Iterator;
import java.util.NoSuchElementException;

@ClassParameters(names={"array", "index", "size"})
public class ArrayIterator<E>
implements Iterator<E> {
    protected final E @NonNull [] array;
    protected int index;
    protected final int size;

    public ArrayIterator(E @NonNull [] array, int index, int size) {
        this.array = array;
        this.index = index;
        this.size = size;
    }

    public static <E> @NonNull ArrayIterator<E> apply(E @NonNull [] array) {
        return new ArrayIterator<E>(array, 0, array.length);
    }

    public static <E> @NonNull ArrayIterator<E> apply(E @NonNull [] array, int size) {
        return new ArrayIterator<E>(array, 0, size);
    }

    public static <E> @NonNull ArrayIterator<E> apply(E @NonNull [] array, int index, int size) {
        return new ArrayIterator<E>(array, index, size);
    }

    @Override
    public boolean hasNext() {
        return this.index < this.size;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E next() {
        void var1_1;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        E element = this.array[this.index];
        ArrayIterator sideEffect$0 = this;
        ++sideEffect$0.index;
        return var1_1;
    }

    public @NonNull String toString() {
        StringBuilder stringBuilder = new StringBuilder(79).append("ArrayIterator(");
        ObjectArray.toString(this.array, stringBuilder);
        return stringBuilder.append(", ").append(this.index).append(", ").append(this.size).append(")").toString();
    }
}

