/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.iterator;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.NonNull;
import java.util.Iterator;
import java.util.NoSuchElementException;

@ClassParameters(names={"head", "tail"})
public class AppendIterator<E>
implements Iterator<E> {
    protected final @NonNull Iterator<? extends E> head;
    protected final E tail;
    protected boolean hasReturned;

    public AppendIterator(@NonNull Iterator<? extends E> head, E tail) {
        this.head = head;
        this.tail = tail;
    }

    public static <E> @NonNull AppendIterator<E> apply(@NonNull Iterator<? extends E> head, E tail) {
        return new AppendIterator<E>(head, tail);
    }

    @Override
    public boolean hasNext() {
        return this.head.hasNext() || !this.hasReturned;
    }

    @Override
    public E next() {
        if (this.head.hasNext()) {
            return this.head.next();
        }
        if (this.hasReturned) {
            throw new NoSuchElementException();
        }
        this.hasReturned = true;
        return this.tail;
    }

    public @NonNull String toString() {
        return new StringBuilder(58).append("AppendIterator(").append(this.head).append(", ").append(this.tail).append(")").toString();
    }
}

