/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.impl;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.Map;
import dyvil.collection.MutableMap;
import dyvil.collection.immutable.TreeMap;
import dyvil.util.Option;
import dyvil.util.Some;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;

public abstract class AbstractTreeMap<K, V>
implements Map<K, V> {
    private static final long serialVersionUID = 4299609156116845922L;
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    protected final transient @Nullable Comparator<? super K> comparator;
    protected transient @Nullable TreeEntry<K, V> root;
    protected transient int size;

    public AbstractTreeMap() {
        this.comparator = null;
    }

    public AbstractTreeMap(Comparator<? super K> comparator) {
        this.comparator = comparator;
    }

    public AbstractTreeMap(Entry<? extends K, ? extends V> @NonNull [] entries) {
        this(entries, null);
    }

    public AbstractTreeMap(Entry<? extends K, ? extends V> @NonNull [] entries, Comparator<? super K> comparator) {
        this.comparator = comparator;
        for (Entry<K, V> entry : entries) {
            this.putInternal(entry.getKey(), entry.getValue());
        }
    }

    public AbstractTreeMap(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> map) {
        this(map, null);
    }

    public AbstractTreeMap(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> map, Comparator<? super K> comparator) {
        this.comparator = comparator;
        this.putAllInternal(map);
    }

    public AbstractTreeMap(@NonNull AbstractTreeMap<? extends K, ? extends V> treeMap) {
        this(treeMap, (Comparator<? extends K>)null);
    }

    public AbstractTreeMap(@NonNull AbstractTreeMap<? extends K, ? extends V> treeMap, Comparator<? super K> comparator) {
        this.comparator = comparator;
        if (treeMap.comparator == comparator) {
            this.buildFromSorted(treeMap.size(), treeMap.iterator());
            return;
        }
        this.putAllInternal(treeMap);
    }

    public @Nullable Comparator<? super K> comparator() {
        return this.comparator;
    }

    protected static int compare(@Nullable Comparator comparator, @NonNull Object k1, @NonNull Object k2) {
        return comparator == null ? ((Comparable)k1).compareTo(k2) : comparator.compare(k1, k2);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isSorted() {
        return this.comparator == null || Map.super.isSorted();
    }

    @Override
    public boolean isSorted(@NonNull Comparator<? super K> comparator) {
        return comparator == this.comparator || Map.super.isSorted(comparator);
    }

    @Override
    public @NonNull Iterator<Entry<K, V>> iterator() {
        return new TreeEntryIterator<Entry<K, V>>((TreeEntry)this.getFirstEntry()){

            @Override
            public @Nullable Entry<K, V> next() {
                return this.nextEntry();
            }
        };
    }

    @Override
    public @NonNull Spliterator<Entry<K, V>> spliterator() {
        return new EntrySpliterator(this, null, null, 0, -1);
    }

    @Override
    public @NonNull Iterator<K> keyIterator() {
        return new TreeEntryIterator<K>((TreeEntry)this.getFirstEntry()){

            @Override
            public K next() {
                return this.nextEntry().key;
            }
        };
    }

    @Override
    public final @NonNull Spliterator<K> keySpliterator() {
        return new KeySpliterator(this, null, null, 0, -1);
    }

    @Override
    public @NonNull Iterator<V> valueIterator() {
        return new TreeEntryIterator<V>((TreeEntry)this.getFirstEntry()){

            @Override
            public V next() {
                return this.nextEntry().value;
            }
        };
    }

    @Override
    public @NonNull Spliterator<V> valueSpliterator() {
        return new ValueSpliterator(this, null, null, 0, -1);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntryInternal(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        TreeEntry<K, V> e = this.getFirstEntry();
        while (e != null) {
            if (Objects.equals(value, e.value)) {
                return true;
            }
            e = AbstractTreeMap.successor(e);
        }
        return false;
    }

    @Override
    public boolean contains(Object key, Object value) {
        TreeEntry<K, V> entry = this.getEntryInternal(key);
        return entry != null && Objects.equals(value, entry.value);
    }

    @Override
    public @Nullable V get(Object key) {
        TreeEntry<K, V> entry = this.getEntryInternal(key);
        return entry == null ? null : (V)entry.value;
    }

    @Override
    public @Nullable Entry<K, V> getEntry(Object key) {
        return this.getEntryInternal(key);
    }

    @Override
    public @NonNull Option<V> getOption(Object key) {
        TreeEntry<K, V> p = this.getEntryInternal(key);
        return p == null ? Option.apply() : new Some(p.value);
    }

    protected final V putInternal(@Nullable K key, V value) {
        int cmp;
        TreeEntry<K, V> parent;
        TreeEntry<K, V> t = this.root;
        if (t == null) {
            this.root = new TreeEntry<K, V>(key, value, null);
            this.size = 1;
            return null;
        }
        Comparator<K> cpr = this.comparator;
        if (cpr != null) {
            do {
                parent = t;
                cmp = cpr.compare(key, t.key);
                if (cmp < 0) {
                    t = t.left;
                    continue;
                }
                if (cmp > 0) {
                    t = t.right;
                    continue;
                }
                Object oldValue = t.value;
                t.value = value;
                return oldValue;
            } while (t != null);
        } else {
            if (key == null) {
                throw new NullPointerException();
            }
            Comparable k = (Comparable)key;
            do {
                parent = t;
                cmp = k.compareTo(t.key);
                if (cmp < 0) {
                    t = t.left;
                    continue;
                }
                if (cmp > 0) {
                    t = t.right;
                    continue;
                }
                Object oldValue = t.value;
                t.value = value;
                return oldValue;
            } while (t != null);
        }
        TreeEntry<K, V> e = new TreeEntry<K, V>(key, value, parent);
        if (cmp < 0) {
            parent.left = e;
        } else {
            parent.right = e;
        }
        this.fixAfterInsertion(e);
        ++this.size;
        return null;
    }

    private void putAllInternal(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        for (Entry<K, V> entry : iterable) {
            this.putInternal(entry.getKey(), entry.getValue());
        }
    }

    protected final TreeEntry<K, V> getEntryInternal(@Nullable Object key) {
        if (this.comparator != null) {
            Object k = key;
            TreeEntry<K, V> p = this.root;
            while (p != null) {
                int cmp = this.comparator.compare(k, p.key);
                if (cmp < 0) {
                    p = p.left;
                    continue;
                }
                if (cmp > 0) {
                    p = p.right;
                    continue;
                }
                return p;
            }
            return null;
        }
        if (key == null) {
            throw new NullPointerException();
        }
        Comparable k = (Comparable)key;
        TreeEntry<K, V> p = this.root;
        while (p != null) {
            int cmp = k.compareTo(p.key);
            if (cmp < 0) {
                p = p.left;
                continue;
            }
            if (cmp > 0) {
                p = p.right;
                continue;
            }
            return p;
        }
        return null;
    }

    protected final @Nullable TreeEntry<K, V> getFirstEntry() {
        TreeEntry<K, V> p = this.root;
        if (p != null) {
            while (p.left != null) {
                p = p.left;
            }
        }
        return p;
    }

    final @Nullable TreeEntry<K, V> getLastEntry() {
        TreeEntry<K, V> p = this.root;
        if (p != null) {
            while (p.right != null) {
                p = p.right;
            }
        }
        return p;
    }

    protected static <K, V> @Nullable TreeEntry<K, V> successor(@Nullable TreeEntry<K, V> t) {
        if (t == null) {
            return null;
        }
        if (t.right != null) {
            TreeEntry p = t.right;
            while (p.left != null) {
                p = p.left;
            }
            return p;
        }
        TreeEntry p = t.parent;
        TreeEntry<K, V> ch = t;
        while (p != null && ch == p.right) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    protected static <K, V> @Nullable TreeEntry<K, V> predecessor(@Nullable TreeEntry<K, V> t) {
        if (t == null) {
            return null;
        }
        if (t.left != null) {
            TreeEntry p = t.left;
            while (p.right != null) {
                p = p.right;
            }
            return p;
        }
        TreeEntry p = t.parent;
        TreeEntry<K, V> ch = t;
        while (p != null && ch == p.left) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    private static boolean colorOf(@Nullable TreeEntry<?, ?> p) {
        return p == null ? true : p.color;
    }

    private static <K, V> @Nullable TreeEntry<K, V> parentOf(@Nullable TreeEntry<K, V> p) {
        return p == null ? null : p.parent;
    }

    private static void setColor(@Nullable TreeEntry<?, ?> p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    private static <K, V> @Nullable TreeEntry<K, V> leftOf(@Nullable TreeEntry<K, V> p) {
        return p == null ? null : p.left;
    }

    private static <K, V> @Nullable TreeEntry<K, V> rightOf(@Nullable TreeEntry<K, V> p) {
        return p == null ? null : p.right;
    }

    protected void fixAfterInsertion(@NonNull TreeEntry<K, V> x) {
        x.color = false;
        while (x != null && x != this.root && !x.parent.color) {
            TreeEntry<K, V> y;
            if (AbstractTreeMap.parentOf(x) == AbstractTreeMap.leftOf(AbstractTreeMap.parentOf(AbstractTreeMap.parentOf(x)))) {
                y = AbstractTreeMap.rightOf(AbstractTreeMap.parentOf(AbstractTreeMap.parentOf(x)));
                if (!AbstractTreeMap.colorOf(y)) {
                    AbstractTreeMap.setColor(AbstractTreeMap.parentOf(x), true);
                    AbstractTreeMap.setColor(y, true);
                    AbstractTreeMap.setColor(AbstractTreeMap.parentOf(AbstractTreeMap.parentOf(x)), false);
                    x = AbstractTreeMap.parentOf(AbstractTreeMap.parentOf(x));
                    continue;
                }
                if (x == AbstractTreeMap.rightOf(AbstractTreeMap.parentOf(x))) {
                    x = AbstractTreeMap.parentOf(x);
                    this.rotateLeft(x);
                }
                AbstractTreeMap.setColor(AbstractTreeMap.parentOf(x), true);
                AbstractTreeMap.setColor(AbstractTreeMap.parentOf(AbstractTreeMap.parentOf(x)), false);
                this.rotateRight(AbstractTreeMap.parentOf(AbstractTreeMap.parentOf(x)));
                continue;
            }
            y = AbstractTreeMap.leftOf(AbstractTreeMap.parentOf(AbstractTreeMap.parentOf(x)));
            if (!AbstractTreeMap.colorOf(y)) {
                AbstractTreeMap.setColor(AbstractTreeMap.parentOf(x), true);
                AbstractTreeMap.setColor(y, true);
                AbstractTreeMap.setColor(AbstractTreeMap.parentOf(AbstractTreeMap.parentOf(x)), false);
                x = AbstractTreeMap.parentOf(AbstractTreeMap.parentOf(x));
                continue;
            }
            if (x == AbstractTreeMap.leftOf(AbstractTreeMap.parentOf(x))) {
                x = AbstractTreeMap.parentOf(x);
                this.rotateRight(x);
            }
            AbstractTreeMap.setColor(AbstractTreeMap.parentOf(x), true);
            AbstractTreeMap.setColor(AbstractTreeMap.parentOf(AbstractTreeMap.parentOf(x)), false);
            this.rotateLeft(AbstractTreeMap.parentOf(AbstractTreeMap.parentOf(x)));
        }
        this.root.color = true;
    }

    private void rotateLeft(@Nullable TreeEntry<K, V> p) {
        if (p != null) {
            TreeEntry r = p.right;
            p.right = r.left;
            if (r.left != null) {
                r.left.parent = p;
            }
            r.parent = p.parent;
            if (p.parent == null) {
                this.root = r;
            } else if (p.parent.left == p) {
                p.parent.left = r;
            } else {
                p.parent.right = r;
            }
            r.left = p;
            p.parent = r;
        }
    }

    private void rotateRight(@Nullable TreeEntry<K, V> p) {
        if (p != null) {
            TreeEntry l = p.left;
            p.left = l.right;
            if (l.right != null) {
                l.right.parent = p;
            }
            l.parent = p.parent;
            if (p.parent == null) {
                this.root = l;
            } else if (p.parent.right == p) {
                p.parent.right = l;
            } else {
                p.parent.left = l;
            }
            l.right = p;
            p.parent = l;
        }
    }

    private void fixAfterDeletion(TreeEntry<K, V> x) {
        while (x != this.root && AbstractTreeMap.colorOf(x)) {
            TreeEntry<K, V> sib;
            if (x == AbstractTreeMap.leftOf(AbstractTreeMap.parentOf(x))) {
                sib = AbstractTreeMap.rightOf(AbstractTreeMap.parentOf(x));
                if (!AbstractTreeMap.colorOf(sib)) {
                    AbstractTreeMap.setColor(sib, true);
                    AbstractTreeMap.setColor(AbstractTreeMap.parentOf(x), false);
                    this.rotateLeft(AbstractTreeMap.parentOf(x));
                    sib = AbstractTreeMap.rightOf(AbstractTreeMap.parentOf(x));
                }
                if (AbstractTreeMap.colorOf(AbstractTreeMap.leftOf(sib)) && AbstractTreeMap.colorOf(AbstractTreeMap.rightOf(sib))) {
                    AbstractTreeMap.setColor(sib, false);
                    x = AbstractTreeMap.parentOf(x);
                    continue;
                }
                if (AbstractTreeMap.colorOf(AbstractTreeMap.rightOf(sib))) {
                    AbstractTreeMap.setColor(AbstractTreeMap.leftOf(sib), true);
                    AbstractTreeMap.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = AbstractTreeMap.rightOf(AbstractTreeMap.parentOf(x));
                }
                AbstractTreeMap.setColor(sib, AbstractTreeMap.colorOf(AbstractTreeMap.parentOf(x)));
                AbstractTreeMap.setColor(AbstractTreeMap.parentOf(x), true);
                AbstractTreeMap.setColor(AbstractTreeMap.rightOf(sib), true);
                this.rotateLeft(AbstractTreeMap.parentOf(x));
                x = this.root;
                continue;
            }
            sib = AbstractTreeMap.leftOf(AbstractTreeMap.parentOf(x));
            if (!AbstractTreeMap.colorOf(sib)) {
                AbstractTreeMap.setColor(sib, true);
                AbstractTreeMap.setColor(AbstractTreeMap.parentOf(x), false);
                this.rotateRight(AbstractTreeMap.parentOf(x));
                sib = AbstractTreeMap.leftOf(AbstractTreeMap.parentOf(x));
            }
            if (AbstractTreeMap.colorOf(AbstractTreeMap.rightOf(sib)) && AbstractTreeMap.colorOf(AbstractTreeMap.leftOf(sib))) {
                AbstractTreeMap.setColor(sib, false);
                x = AbstractTreeMap.parentOf(x);
                continue;
            }
            if (AbstractTreeMap.colorOf(AbstractTreeMap.leftOf(sib))) {
                AbstractTreeMap.setColor(AbstractTreeMap.rightOf(sib), true);
                AbstractTreeMap.setColor(sib, false);
                this.rotateLeft(sib);
                sib = AbstractTreeMap.leftOf(AbstractTreeMap.parentOf(x));
            }
            AbstractTreeMap.setColor(sib, AbstractTreeMap.colorOf(AbstractTreeMap.parentOf(x)));
            AbstractTreeMap.setColor(AbstractTreeMap.parentOf(x), true);
            AbstractTreeMap.setColor(AbstractTreeMap.leftOf(sib), true);
            this.rotateRight(AbstractTreeMap.parentOf(x));
            x = this.root;
        }
        AbstractTreeMap.setColor(x, true);
    }

    protected void deleteEntry(@NonNull TreeEntry<K, V> p) {
        TreeEntry replacement;
        --this.size;
        if (p.left != null && p.right != null) {
            TreeEntry<K, V> s = AbstractTreeMap.successor(p);
            p.key = s.key;
            p.value = s.value;
            p = s;
        }
        TreeEntry treeEntry = replacement = p.left != null ? p.left : p.right;
        if (replacement != null) {
            replacement.parent = p.parent;
            if (p.parent == null) {
                this.root = replacement;
            } else if (p == p.parent.left) {
                p.parent.left = replacement;
            } else {
                p.parent.right = replacement;
            }
            p.parent = null;
            p.right = null;
            p.left = null;
            if (p.color) {
                this.fixAfterDeletion(replacement);
            }
        } else if (p.parent == null) {
            this.root = null;
        } else {
            if (p.color) {
                this.fixAfterDeletion(p);
            }
            if (p.parent != null) {
                if (p == p.parent.left) {
                    p.parent.left = null;
                } else if (p == p.parent.right) {
                    p.parent.right = null;
                }
                p.parent = null;
            }
        }
    }

    protected void buildFromSorted(int size, @NonNull Iterator<? extends @NonNull Entry<? extends K, ? extends V>> iterator) {
        this.size = size;
        this.root = AbstractTreeMap.buildFromSorted(0, 0, size - 1, AbstractTreeMap.computeRedLevel(size), iterator);
    }

    private static <K, V> TreeEntry<K, V> buildFromSorted(int level, int lo, int hi, int redLevel, @NonNull Iterator<? extends @NonNull Entry<? extends K, ? extends V>> iterator) {
        if (hi < lo) {
            return null;
        }
        int mid = lo + hi >>> 1;
        TreeEntry<K, V> left = null;
        if (lo < mid) {
            left = AbstractTreeMap.buildFromSorted(level + 1, lo, mid - 1, redLevel, iterator);
        }
        Entry<K, V> entry = iterator.next();
        TreeEntry<K, V> middle = new TreeEntry<K, V>(entry.getKey(), entry.getValue(), null);
        if (level == redLevel) {
            middle.color = false;
        }
        if (left != null) {
            middle.left = left;
            left.parent = middle;
        }
        if (mid < hi) {
            TreeEntry<K, V> right = AbstractTreeMap.buildFromSorted(level + 1, mid + 1, hi, redLevel, iterator);
            assert (right != null);
            middle.right = right;
            right.parent = middle;
        }
        return middle;
    }

    protected void buildFromSorted(int size, @NonNull ObjectInputStream str) {
        this.size = size;
        try {
            this.root = AbstractTreeMap.buildFromSorted(0, 0, size - 1, AbstractTreeMap.computeRedLevel(size), str);
        }
        catch (IOException | ClassNotFoundException exception) {
            // empty catch block
        }
    }

    private static <K, V> TreeEntry<K, V> buildFromSorted(int level, int lo, int hi, int redLevel, @NonNull ObjectInputStream str) throws IOException, ClassNotFoundException {
        if (hi < lo) {
            return null;
        }
        int mid = lo + hi >>> 1;
        TreeEntry<K, V> left = null;
        if (lo < mid) {
            left = AbstractTreeMap.buildFromSorted(level + 1, lo, mid - 1, redLevel, str);
        }
        Object key = str.readObject();
        Object value = str.readObject();
        TreeEntry<Object, Object> middle = new TreeEntry<Object, Object>(key, value, null);
        if (level == redLevel) {
            middle.color = false;
        }
        if (left != null) {
            middle.left = left;
            left.parent = middle;
        }
        if (mid < hi) {
            TreeEntry<K, V> right = AbstractTreeMap.buildFromSorted(level + 1, mid + 1, hi, redLevel, str);
            assert (right != null);
            middle.right = right;
            right.parent = middle;
        }
        return middle;
    }

    private static int computeRedLevel(int sz) {
        int level = 0;
        int m = sz - 1;
        while (m >= 0) {
            ++level;
            m = m / 2 - 1;
        }
        return level;
    }

    @Override
    public <RK, RV> @NonNull MutableMap<RK, RV> emptyCopy() {
        return new dyvil.collection.mutable.TreeMap();
    }

    @Override
    public @NonNull MutableMap<K, V> mutableCopy() {
        return new dyvil.collection.mutable.TreeMap(this, this.comparator);
    }

    @Override
    public @NonNull ImmutableMap<K, V> immutableCopy() {
        return new TreeMap(this, this.comparator);
    }

    @Override
    public <RK, RV> ImmutableMap.Builder<RK, RV> immutableBuilder() {
        return TreeMap.builder();
    }

    @Override
    public @NonNull java.util.Map<K, V> toJava() {
        java.util.TreeMap map = new java.util.TreeMap(this.comparator);
        TreeEntry<K, V> first = this.getFirstEntry();
        while (first != null) {
            map.put(first.key, first.value);
            first = AbstractTreeMap.successor(first);
        }
        return map;
    }

    @Override
    public String toString() {
        return Map.mapToString(this);
    }

    @Override
    public boolean equals(Object obj) {
        return Map.mapEquals((Map<? extends Object, ? extends Object>)this, obj);
    }

    @Override
    public int hashCode() {
        return Map.mapHashCode(this);
    }

    private void writeObject(@NonNull ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.size);
        TreeEntry<K, V> entry = this.getFirstEntry();
        while (entry != null) {
            out.writeObject(entry.key);
            out.writeObject(entry.value);
            entry = AbstractTreeMap.successor(entry);
        }
    }

    private void readObject(@NonNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.buildFromSorted(in.readInt(), in);
    }

    static final class EntrySpliterator<K, V>
    extends TreeMapSpliterator<K, V>
    implements Spliterator<Entry<K, V>> {
        EntrySpliterator(AbstractTreeMap<K, V> tree, TreeEntry<K, V> origin, TreeEntry<K, V> fence, int side, int est) {
            super(tree, origin, fence, side, est);
        }

        public EntrySpliterator<K, V> trySplit() {
            TreeEntry s;
            if (this.est < 0) {
                this.getEstimate();
            }
            int d = this.side;
            TreeEntry e = this.current;
            TreeEntry f = this.fence;
            TreeEntry treeEntry = e == null || e == f ? null : (d == 0 ? this.tree.root : (d > 0 ? e.right : (s = d < 0 && f != null ? f.left : null)));
            if (s != null && s != e && s != f && AbstractTreeMap.compare(this.tree.comparator, e.key, s.key) < 0) {
                this.side = 1;
                this.current = s;
                return new EntrySpliterator(this.tree, e, this.current, -1, this.est >>>= 1);
            }
            return null;
        }

        @Override
        public void forEachRemaining(@Nullable Consumer<? super Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            TreeEntry f = this.fence;
            TreeEntry e = this.current;
            if (e != null && e != f) {
                TreeEntry p;
                this.current = f;
                do {
                    action.accept(e);
                    p = e.right;
                    if (p != null) {
                        TreeEntry pl;
                        while ((pl = p.left) != null) {
                            p = pl;
                        }
                    } else {
                        while ((p = e.parent) != null && e == p.right) {
                            e = p;
                        }
                    }
                } while ((e = p) != null && e != f);
            }
        }

        @Override
        public boolean tryAdvance(@Nullable Consumer<? super Entry<K, V>> action) {
            TreeEntry e;
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            if ((e = this.current) == null || e == this.fence) {
                return false;
            }
            this.current = AbstractTreeMap.successor(e);
            action.accept(e);
            return true;
        }

        @Override
        public int characteristics() {
            return (this.side == 0 ? 64 : 0) | 1 | 4 | 0x10;
        }

        @Override
        public @NonNull Comparator<Entry<K, V>> getComparator() {
            if (this.tree.comparator != null) {
                return Entry.comparingByKey(this.tree.comparator);
            }
            return Entry.comparingByKey();
        }
    }

    static final class ValueSpliterator<K, V>
    extends TreeMapSpliterator<K, V>
    implements Spliterator<V> {
        ValueSpliterator(AbstractTreeMap<K, V> tree, TreeEntry<K, V> origin, TreeEntry<K, V> fence, int side, int est) {
            super(tree, origin, fence, side, est);
        }

        public ValueSpliterator<K, V> trySplit() {
            TreeEntry s;
            if (this.est < 0) {
                this.getEstimate();
            }
            int d = this.side;
            TreeEntry e = this.current;
            TreeEntry f = this.fence;
            TreeEntry treeEntry = e == null || e == f ? null : (d == 0 ? this.tree.root : (d > 0 ? e.right : (s = d < 0 && f != null ? f.left : null)));
            if (s != null && s != e && s != f && AbstractTreeMap.compare(this.tree.comparator, e.key, s.key) < 0) {
                this.side = 1;
                this.current = s;
                return new ValueSpliterator(this.tree, e, this.current, -1, this.est >>>= 1);
            }
            return null;
        }

        @Override
        public void forEachRemaining(@Nullable Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            TreeEntry f = this.fence;
            TreeEntry e = this.current;
            if (e != null && e != f) {
                TreeEntry p;
                this.current = f;
                do {
                    action.accept(e.value);
                    p = e.right;
                    if (p != null) {
                        TreeEntry pl;
                        while ((pl = p.left) != null) {
                            p = pl;
                        }
                    } else {
                        while ((p = e.parent) != null && e == p.right) {
                            e = p;
                        }
                    }
                } while ((e = p) != null && e != f);
            }
        }

        @Override
        public boolean tryAdvance(@Nullable Consumer<? super V> action) {
            TreeEntry e;
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            if ((e = this.current) == null || e == this.fence) {
                return false;
            }
            this.current = AbstractTreeMap.successor(e);
            action.accept(e.value);
            return true;
        }

        @Override
        public int characteristics() {
            return (this.side == 0 ? 64 : 0) | 0x10;
        }
    }

    static final class KeySpliterator<K, V>
    extends TreeMapSpliterator<K, V>
    implements Spliterator<K> {
        KeySpliterator(AbstractTreeMap<K, V> tree, TreeEntry<K, V> origin, TreeEntry<K, V> fence, int side, int est) {
            super(tree, origin, fence, side, est);
        }

        public KeySpliterator<K, V> trySplit() {
            TreeEntry s;
            if (this.est < 0) {
                this.getEstimate();
            }
            int d = this.side;
            TreeEntry e = this.current;
            TreeEntry f = this.fence;
            TreeEntry treeEntry = e == null || e == f ? null : (d == 0 ? this.tree.root : (d > 0 ? e.right : (s = d < 0 && f != null ? f.left : null)));
            if (s != null && s != e && s != f && AbstractTreeMap.compare(this.tree.comparator, e.key, s.key) < 0) {
                this.side = 1;
                this.current = s;
                return new KeySpliterator(this.tree, e, this.current, -1, this.est >>>= 1);
            }
            return null;
        }

        @Override
        public void forEachRemaining(@Nullable Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            TreeEntry f = this.fence;
            TreeEntry e = this.current;
            if (e != null && e != f) {
                TreeEntry p;
                this.current = f;
                do {
                    action.accept(e.key);
                    p = e.right;
                    if (p != null) {
                        TreeEntry pl;
                        while ((pl = p.left) != null) {
                            p = pl;
                        }
                    } else {
                        while ((p = e.parent) != null && e == p.right) {
                            e = p;
                        }
                    }
                } while ((e = p) != null && e != f);
            }
        }

        @Override
        public boolean tryAdvance(@Nullable Consumer<? super K> action) {
            TreeEntry e;
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            if ((e = this.current) == null || e == this.fence) {
                return false;
            }
            this.current = AbstractTreeMap.successor(e);
            action.accept(e.key);
            return true;
        }

        @Override
        public int characteristics() {
            return (this.side == 0 ? 64 : 0) | 1 | 4 | 0x10;
        }

        @Override
        public final @Nullable Comparator<? super K> getComparator() {
            return this.tree.comparator;
        }
    }

    static class TreeMapSpliterator<K, V> {
        final AbstractTreeMap<K, V> tree;
        @Nullable TreeEntry<K, V> current;
        TreeEntry<K, V> fence;
        int side;
        int est;

        TreeMapSpliterator(AbstractTreeMap<K, V> tree, TreeEntry<K, V> origin, TreeEntry<K, V> fence, int side, int est) {
            this.tree = tree;
            this.current = origin;
            this.fence = fence;
            this.side = side;
            this.est = est;
        }

        final int getEstimate() {
            int s = this.est;
            if (s < 0) {
                AbstractTreeMap<K, V> t = this.tree;
                if (t != null) {
                    this.current = s == -1 ? t.getFirstEntry() : t.getLastEntry();
                    s = this.est = t.size;
                } else {
                    this.est = 0;
                    s = 0;
                }
            }
            return s;
        }

        public final long estimateSize() {
            return this.getEstimate();
        }
    }

    protected abstract class TreeEntryIterator<T>
    implements Iterator<T> {
        @Nullable TreeEntry<K, V> next;
        @Nullable TreeEntry<K, V> lastReturned = null;

        protected TreeEntryIterator(TreeEntry<K, V> first) {
            this.next = first;
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        protected final @Nullable TreeEntry<K, V> nextEntry() {
            TreeEntry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = AbstractTreeMap.successor(e);
            this.lastReturned = e;
            return e;
        }

        protected final @Nullable TreeEntry<K, V> prevEntry() {
            TreeEntry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = AbstractTreeMap.predecessor(e);
            this.lastReturned = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (this.lastReturned.left != null && this.lastReturned.right != null) {
                this.next = this.lastReturned;
            }
            AbstractTreeMap.this.deleteEntry(this.lastReturned);
            this.lastReturned = null;
        }
    }

    protected static final class TreeEntry<K, V>
    implements Entry<K, V> {
        private static final long serialVersionUID = -8592912850607607269L;
        public transient K key;
        public transient V value;
        protected transient @Nullable TreeEntry<K, V> left = null;
        protected transient @Nullable TreeEntry<K, V> right = null;
        protected transient @Nullable TreeEntry<K, V> parent;
        protected transient boolean color = true;

        protected TreeEntry(K key, V value, TreeEntry<K, V> parent) {
            this.key = key;
            this.value = value;
            this.parent = parent;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            return Entry.entryEquals((Entry<? extends Object, ? extends Object>)this, o);
        }

        public int hashCode() {
            return Entry.entryHashCode(this);
        }

        public @NonNull String toString() {
            return this.key + " -> " + this.value;
        }

        private void writeObject(@NonNull ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeObject(this.key);
            out.writeObject(this.value);
            out.writeObject(this.left);
            out.writeObject(this.right);
            out.writeObject(this.parent);
            out.writeBoolean(this.color);
        }

        private void readObject(@NonNull ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.key = in.readObject();
            this.value = in.readObject();
            this.left = (TreeEntry)in.readObject();
            this.right = (TreeEntry)in.readObject();
            this.parent = (TreeEntry)in.readObject();
            this.color = in.readBoolean();
        }
    }
}

