/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.impl;

import dyvil.annotation.internal.NonNull;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableSet;
import dyvil.collection.Map;
import dyvil.collection.MutableSet;
import dyvil.collection.Set;
import dyvil.collection.mutable.MapBasedSet;
import java.util.Collections;
import java.util.Iterator;

public abstract class AbstractMapBasedSet<E>
implements Set<E> {
    private static final long serialVersionUID = -6579037312574546078L;

    protected abstract Map<E, Boolean> map();

    @Override
    public int size() {
        return this.map().size();
    }

    @Override
    public @NonNull Iterator<E> iterator() {
        return this.map().keyIterator();
    }

    @Override
    public boolean contains(Object element) {
        return this.map().containsKey(element);
    }

    @Override
    public void toArray(int index, Object @NonNull [] store) {
        for (Entry<E, Boolean> entry : this.map()) {
            store[index++] = entry.getKey();
        }
    }

    @Override
    public <R> @NonNull MutableSet<R> emptyCopy() {
        return new MapBasedSet(this.map().emptyCopy());
    }

    @Override
    public <RE> @NonNull MutableSet<RE> emptyCopy(int capacity) {
        return null;
    }

    @Override
    public @NonNull MutableSet<E> mutableCopy() {
        return new MapBasedSet<E>(this.map().mutableCopy());
    }

    @Override
    public @NonNull ImmutableSet<E> immutableCopy() {
        return new dyvil.collection.immutable.MapBasedSet<E>(this.map().immutableCopy());
    }

    @Override
    public <RE> ImmutableSet.Builder<RE> immutableBuilder() {
        return dyvil.collection.immutable.MapBasedSet.builder(this.map().immutableBuilder());
    }

    @Override
    public <RE> ImmutableSet.Builder<RE> immutableBuilder(int capacity) {
        return dyvil.collection.immutable.MapBasedSet.builder(this.map().immutableBuilder(capacity));
    }

    @Override
    public java.util.Set<E> toJava() {
        java.util.Map<E, Boolean> map = this.map().toJava();
        return Collections.newSetFromMap(map);
    }

    @Override
    public @NonNull String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder(this.size() << 3).append("[");
        for (Entry<E, Boolean> entry : this.map()) {
            builder.append(entry.getKey()).append(", ");
        }
        int len = builder.length();
        return builder.replace(len - ", ".length(), len, "]").toString();
    }

    @Override
    public boolean equals(Object obj) {
        return Set.setEquals((Set<? extends Object>)this, obj);
    }

    @Override
    public int hashCode() {
        return Set.setHashCode(this);
    }
}

