/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.impl;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Collection;
import dyvil.collection.ImmutableSet;
import dyvil.collection.MutableSet;
import dyvil.collection.Set;
import dyvil.collection.SizedIterable;
import dyvil.collection.immutable.IdentityHashSet;
import dyvil.collection.impl.AbstractHashMap;
import dyvil.collection.impl.AbstractIdentityHashMap;
import dyvil.math.MathUtils;
import dyvil.util.ImmutableException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public abstract class AbstractIdentityHashSet<E>
implements Set<E> {
    private static final long serialVersionUID = -6688373107015354853L;
    protected static final int DEFAULT_CAPACITY = 16;
    protected static final float DEFAULT_LOAD_FACTOR = 0.6666667f;
    protected Object[] table;
    protected int size;

    public AbstractIdentityHashSet() {
        this.table = new Object[32];
    }

    public AbstractIdentityHashSet(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Invalid Capacity: " + capacity);
        }
        this.table = new Object[MathUtils.nextPowerOf2(AbstractHashMap.grow(capacity)) << 1];
    }

    public AbstractIdentityHashSet(E @NonNull [] elements) {
        this(elements.length);
        for (E element : elements) {
            this.addInternal(element);
        }
    }

    public AbstractIdentityHashSet(@NonNull Iterable<? extends E> iterable) {
        this();
        this.addAllInternal(iterable);
    }

    public AbstractIdentityHashSet(@NonNull SizedIterable<? extends E> iterable) {
        this(iterable.size());
        this.addAllInternal(iterable);
    }

    public AbstractIdentityHashSet(@NonNull Set<? extends E> set) {
        this(set.size());
        this.addAllInternal(set);
    }

    public AbstractIdentityHashSet(@NonNull AbstractIdentityHashSet<? extends E> set) {
        this.table = (Object[])set.table.clone();
        this.size = set.size;
    }

    protected static int nextIndex(int i, int len) {
        return i + 1 < len ? i + 1 : 0;
    }

    protected void flatten() {
        this.ensureCapacityInternal(this.table.length << 1);
    }

    public void ensureCapacity(int newCapacity) {
        if (newCapacity > this.table.length) {
            this.ensureCapacityInternal(MathUtils.nextPowerOf2(newCapacity));
        }
    }

    protected void ensureCapacityInternal(int newCapacity) {
        Object[] oldTable = this.table;
        int oldLength = oldTable.length;
        if (newCapacity - 0x7FFFFFF7 > 0) {
            if (oldLength == 0x7FFFFFF7) {
                return;
            }
            newCapacity = 0x7FFFFFF7;
        }
        Object[] newTable = new Object[newCapacity];
        for (int j = 0; j < oldLength; ++j) {
            Object key = oldTable[j];
            if (key == null) continue;
            oldTable[j] = null;
            int i = AbstractIdentityHashMap.index(key, newCapacity);
            while (newTable[i] != null) {
                i = AbstractIdentityHashSet.nextIndex(i, newCapacity);
            }
            newTable[i] = key;
        }
        this.table = newTable;
        this.updateThreshold(newCapacity);
    }

    protected void updateThreshold(int newCapacity) {
    }

    protected boolean addInternal(E element) {
        Object item;
        Object k = AbstractIdentityHashMap.maskNull(element);
        Object[] tab = this.table;
        int len = tab.length;
        int i = AbstractIdentityHashMap.index(k, len);
        while ((item = tab[i]) != null) {
            if (item == k) {
                return false;
            }
            i = AbstractIdentityHashSet.nextIndex(i, len);
        }
        this.addElement(i, k);
        return true;
    }

    protected void addElement(int index, Object element) {
        int n;
        this.table[index] = element;
        ++this.size;
        if ((float)n >= (float)this.table.length * 0.6666667f) {
            this.flatten();
        }
    }

    protected void addAllInternal(@NonNull Iterable<? extends E> iterable) {
        for (E element : iterable) {
            this.addInternal(element);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public @NonNull Iterator<E> iterator() {
        return new Iterator<E>(){
            int index;
            int lastReturnedIndex;
            boolean indexValid;
            Object[] traversalTable;
            {
                this.index = AbstractIdentityHashSet.this.size != 0 ? 0 : AbstractIdentityHashSet.this.table.length;
                this.lastReturnedIndex = -1;
                this.traversalTable = AbstractIdentityHashSet.this.table;
            }

            @Override
            public boolean hasNext() {
                Object[] tab = this.traversalTable;
                for (int i = this.index; i < tab.length; ++i) {
                    Object key = tab[i];
                    if (key == null) continue;
                    this.index = i;
                    this.indexValid = true;
                    return true;
                }
                this.index = tab.length;
                return false;
            }

            @Override
            public @Nullable E next() {
                if (!this.indexValid && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.indexValid = false;
                this.lastReturnedIndex = this.index++;
                return AbstractIdentityHashMap.unmaskNull(this.traversalTable[this.lastReturnedIndex]);
            }

            @Override
            public void remove() {
                Object item;
                if (this.lastReturnedIndex == -1) {
                    throw new IllegalStateException();
                }
                if (AbstractIdentityHashSet.this.isImmutable()) {
                    throw new ImmutableException("Iterator.remove() on Immutable Set");
                }
                int deletedSlot = this.lastReturnedIndex;
                this.lastReturnedIndex = -1;
                this.index = deletedSlot;
                this.indexValid = false;
                Object[] tab = this.traversalTable;
                int len = tab.length;
                int d = deletedSlot;
                Object key = tab[d];
                tab[d] = null;
                if (tab != AbstractIdentityHashSet.this.table) {
                    AbstractIdentityHashSet.this.remove(key);
                    return;
                }
                --AbstractIdentityHashSet.this.size;
                int i = AbstractIdentityHashSet.nextIndex(d, len);
                while ((item = tab[i]) != null) {
                    int r = AbstractIdentityHashMap.index(item, len);
                    if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                        if (i < deletedSlot && d >= deletedSlot && this.traversalTable == AbstractIdentityHashSet.this.table) {
                            int remaining = len - deletedSlot;
                            Object[] newTable = new Object[remaining];
                            System.arraycopy(tab, deletedSlot, newTable, 0, remaining);
                            this.traversalTable = newTable;
                            this.index = 0;
                        }
                        tab[d] = item;
                        tab[i] = null;
                        d = i;
                    }
                    i = AbstractIdentityHashSet.nextIndex(i, len);
                }
            }
        };
    }

    @Override
    public void forEach(@NonNull Consumer<? super E> action) {
        for (Object element : this.table) {
            if (element == null) continue;
            action.accept(AbstractIdentityHashMap.unmaskNull(element));
        }
    }

    @Override
    public boolean contains(@Nullable Object element) {
        if (element == null) {
            for (Object o : this.table) {
                if (o != AbstractIdentityHashMap.NULL) continue;
                return true;
            }
            return false;
        }
        for (Object o : this.table) {
            if (element != o) continue;
            return true;
        }
        return false;
    }

    @Override
    public void toArray(int index, Object @NonNull [] store) {
        for (Object o : this.table) {
            if (o == null) continue;
            store[index++] = AbstractIdentityHashMap.unmaskNull(o);
        }
    }

    @Override
    public <R> @NonNull MutableSet<R> emptyCopy() {
        return new dyvil.collection.mutable.IdentityHashSet();
    }

    @Override
    public <RE> @NonNull MutableSet<RE> emptyCopy(int capacity) {
        return new dyvil.collection.mutable.IdentityHashSet(capacity);
    }

    @Override
    public @NonNull MutableSet<E> mutableCopy() {
        return new dyvil.collection.mutable.IdentityHashSet(this);
    }

    @Override
    public @NonNull ImmutableSet<E> immutableCopy() {
        return new IdentityHashSet(this);
    }

    @Override
    public <RE> ImmutableSet.Builder<RE> immutableBuilder() {
        return IdentityHashSet.builder();
    }

    @Override
    public <RE> ImmutableSet.Builder<RE> immutableBuilder(int capacity) {
        return IdentityHashSet.builder(capacity);
    }

    @Override
    public @NonNull java.util.Set<E> toJava() {
        IdentityHashMap<E, Boolean> map = new IdentityHashMap<E, Boolean>(this.size);
        for (E element : this) {
            map.put(element, true);
        }
        return Collections.newSetFromMap(map);
    }

    @Override
    public @NonNull String toString() {
        return Collection.collectionToString(this);
    }

    @Override
    public boolean equals(Object obj) {
        return Set.setEquals((Set<? extends Object>)this, obj);
    }

    @Override
    public int hashCode() {
        return Set.setHashCode(this);
    }

    private void writeObject(@NonNull ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.size);
        out.writeInt(this.table.length);
        for (Object key : this.table) {
            if (key == null) continue;
            out.writeObject(AbstractIdentityHashMap.unmaskNull(key));
        }
    }

    private void readObject(@NonNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.size = in.readInt();
        this.table = new Object[in.readInt()];
        for (int i = 0; i < this.size; ++i) {
            this.addInternal(in.readObject());
        }
    }
}

