/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.impl;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.Map;
import dyvil.collection.MutableMap;
import dyvil.collection.Set;
import dyvil.collection.SizedIterable;
import dyvil.collection.impl.AbstractHashMap;
import dyvil.math.MathUtils;
import dyvil.util.ImmutableException;
import dyvil.util.None;
import dyvil.util.Option;
import dyvil.util.Some;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public abstract class AbstractIdentityHashMap<K, V>
implements Map<K, V> {
    private static final long serialVersionUID = -2493470311862510577L;
    protected static final int DEFAULT_CAPACITY = 12;
    protected static final float DEFAULT_LOAD_FACTOR = 0.6666667f;
    protected static final Object NULL = new Object();
    protected transient Object[] table;
    protected transient int size;

    public AbstractIdentityHashMap() {
        this.table = new Object[12];
    }

    public AbstractIdentityHashMap(int capacity) {
        this.table = new Object[MathUtils.nextPowerOf2(AbstractHashMap.grow(capacity) << 1)];
    }

    public AbstractIdentityHashMap(Entry<? extends K, ? extends V> @NonNull [] entries) {
        this(entries.length);
        for (Entry<K, V> entry : entries) {
            this.putInternal(entry.getKey(), entry.getValue());
        }
    }

    public AbstractIdentityHashMap(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        this();
        this.putAllInternal(iterable);
    }

    public AbstractIdentityHashMap(SizedIterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        this();
        this.putAllInternal((Iterable<Entry<K, V>>)iterable);
    }

    public AbstractIdentityHashMap(@NonNull Set<? extends @NonNull Entry<? extends K, ? extends V>> set) {
        this(set.size());
        super.loadDistinctEntries(set);
    }

    public AbstractIdentityHashMap(@NonNull Map<? extends K, ? extends V> map) {
        this(map.size());
        super.loadDistinctEntries(map);
    }

    public AbstractIdentityHashMap(@NonNull AbstractIdentityHashMap<? extends K, ? extends V> identityHashMap) {
        this.size = identityHashMap.size;
        this.table = (Object[])identityHashMap.table.clone();
    }

    public static @NonNull Object maskNull(@Nullable Object o) {
        return o == null ? NULL : o;
    }

    public static Object unmaskNull(Object o) {
        return o == NULL ? null : o;
    }

    public static int index(Object x, int length) {
        int h = System.identityHashCode(x);
        h = (h << 1) - (h << 8);
        return h & length - 1;
    }

    public static int nextKeyIndex(int i, int len) {
        return i + 2 < len ? i + 2 : 0;
    }

    protected void flatten() {
        this.ensureCapacityInternal(this.table.length << 1);
    }

    public void ensureCapacity(int newCapacity) {
        if (newCapacity > this.table.length >> 1) {
            this.ensureCapacityInternal(MathUtils.nextPowerOf2(newCapacity) << 1);
        }
    }

    protected void ensureCapacityInternal(int newCapacity) {
        Object[] oldTable = this.table;
        int oldLength = oldTable.length;
        if (newCapacity - 0x7FFFFFF7 > 0) {
            if (oldLength == 0x7FFFFFF7) {
                return;
            }
            newCapacity = 0x7FFFFFF7;
        }
        Object[] newTable = new Object[newCapacity];
        for (int j = 0; j < oldLength; j += 2) {
            Object key = oldTable[j];
            if (key == null) continue;
            Object value = oldTable[j + 1];
            oldTable[j] = null;
            oldTable[j + 1] = null;
            int i = AbstractIdentityHashMap.index(key, newCapacity);
            while (newTable[i] != null) {
                i = AbstractIdentityHashMap.nextKeyIndex(i, newCapacity);
            }
            newTable[i] = key;
            newTable[i + 1] = value;
        }
        this.table = newTable;
        this.updateThreshold(newCapacity >> 1);
    }

    protected void updateThreshold(int newCapacity) {
    }

    protected @Nullable V putInternal(K key, V value) {
        Object item;
        Object k = AbstractIdentityHashMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = AbstractIdentityHashMap.index(k, len);
        while ((item = tab[i]) != null) {
            if (item == k) {
                Object oldValue = tab[i + 1];
                tab[i + 1] = value;
                return (V)oldValue;
            }
            i = AbstractIdentityHashMap.nextKeyIndex(i, len);
        }
        this.addEntry(i, k, value);
        return null;
    }

    protected void addEntry(int index, Object key, V value) {
        int n;
        this.table[index] = key;
        this.table[index + 1] = value;
        ++this.size;
        if ((float)n >= (float)(this.table.length >> 1) * 0.6666667f) {
            this.flatten();
        }
    }

    protected void putAllInternal(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        for (Entry<K, V> entry : iterable) {
            this.putInternal(entry.getKey(), entry.getValue());
        }
    }

    protected void putAllInternal(@NonNull SizedIterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        this.ensureCapacity(this.size + iterable.size());
        this.putAllInternal((Iterable<? extends Entry<? extends K, ? extends V>>)iterable);
    }

    private void loadDistinctEntries(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        int index = 0;
        int size = 0;
        for (Entry<K, V> entry : iterable) {
            this.table[index++] = entry.getKey();
            this.table[index++] = entry.getValue();
            ++size;
        }
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public @NonNull Iterator<Entry<K, V>> iterator() {
        return new TableIterator<Entry<K, V>>(){

            @Override
            public @NonNull Entry<K, V> next() {
                return new TableEntry(this.nextIndex());
            }

            public @NonNull String toString() {
                return "EntryIterator(" + AbstractIdentityHashMap.this + ")";
            }
        };
    }

    @Override
    public @NonNull Iterator<K> keyIterator() {
        return new TableIterator<K>(){

            @Override
            public @NonNull K next() {
                return AbstractIdentityHashMap.this.table[this.nextIndex()];
            }

            public @NonNull String toString() {
                return "KeyIterator(" + AbstractIdentityHashMap.this + ")";
            }
        };
    }

    @Override
    public @NonNull Iterator<V> valueIterator() {
        return new TableIterator<V>(){

            @Override
            public @NonNull V next() {
                return AbstractIdentityHashMap.this.table[this.nextIndex() + 1];
            }

            public @NonNull String toString() {
                return "ValueIterator(" + AbstractIdentityHashMap.this + ")";
            }
        };
    }

    @Override
    public void forEach(@NonNull BiConsumer<? super K, ? super V> action) {
        Object[] tab = this.table;
        for (int i = 0; i < tab.length; i += 2) {
            Object key = tab[i];
            if (key == null) continue;
            action.accept(AbstractIdentityHashMap.unmaskNull(key), tab[i + 1]);
        }
    }

    @Override
    public void forEach(@NonNull Consumer<? super Entry<K, V>> action) {
        Object[] tab = this.table;
        for (int i = 0; i < tab.length; i += 2) {
            Object key = tab[i];
            if (key == null) continue;
            action.accept(new TableEntry(i));
        }
    }

    @Override
    public void forEachKey(@NonNull Consumer<? super K> action) {
        Object[] tab = this.table;
        for (int i = 0; i < tab.length; i += 2) {
            Object key = tab[i];
            if (key == null) continue;
            action.accept(AbstractIdentityHashMap.unmaskNull(key));
        }
    }

    @Override
    public void forEachValue(@NonNull Consumer<? super V> action) {
        Object[] tab = this.table;
        for (int i = 1; i < tab.length; i += 2) {
            if (tab[i - 1] == null) continue;
            action.accept(tab[i]);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getIndex(key) >= 0;
    }

    @Override
    public boolean contains(Object key, Object value) {
        int index = this.getIndex(key);
        return index >= 0 && this.table[index + 1] == value;
    }

    @Override
    public boolean containsValue(Object value) {
        Object[] tab = this.table;
        for (int i = 1; i < tab.length; i += 2) {
            if (tab[i] != value || tab[i - 1] == null) continue;
            return true;
        }
        return false;
    }

    protected int getIndex(Object key) {
        Object k = AbstractIdentityHashMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = AbstractIdentityHashMap.index(k, len);
        Object item;
        while ((item = tab[i]) != k) {
            if (item == null) {
                return -1;
            }
            i = AbstractIdentityHashMap.nextKeyIndex(i, len);
        }
        return i;
    }

    @Override
    public @Nullable V get(Object key) {
        int index = this.getIndex(key);
        if (index < 0) {
            return null;
        }
        return (V)this.table[index + 1];
    }

    @Override
    public @NonNull Option<V> getOption(Object key) {
        int index = this.getIndex(key);
        if (index < 0) {
            return None.instance;
        }
        return new Some<Object>(this.table[index + 1]);
    }

    @Override
    public <RK, RV> @NonNull MutableMap<RK, RV> emptyCopy() {
        return new dyvil.collection.mutable.IdentityHashMap();
    }

    @Override
    public <RK, RV> @NonNull MutableMap<RK, RV> emptyCopy(int capacity) {
        return new dyvil.collection.mutable.IdentityHashMap(capacity);
    }

    @Override
    public @NonNull MutableMap<K, V> mutableCopy() {
        return new dyvil.collection.mutable.IdentityHashMap(this);
    }

    @Override
    public @NonNull ImmutableMap<K, V> immutableCopy() {
        return new dyvil.collection.immutable.IdentityHashMap(this);
    }

    @Override
    public <RK, RV> ImmutableMap.Builder<RK, RV> immutableBuilder() {
        return dyvil.collection.immutable.IdentityHashMap.builder();
    }

    @Override
    public <RK, RV> ImmutableMap.Builder<RK, RV> immutableBuilder(int capacity) {
        return dyvil.collection.immutable.IdentityHashMap.builder(capacity);
    }

    @Override
    public @NonNull java.util.Map<K, V> toJava() {
        IdentityHashMap<Object, Object> map = new IdentityHashMap<Object, Object>(this.size);
        Object[] tab = this.table;
        for (int i = 0; i < tab.length; i += 2) {
            Object key = tab[i];
            if (key == null) continue;
            map.put(AbstractIdentityHashMap.unmaskNull(key), tab[i + 1]);
        }
        return map;
    }

    @Override
    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder("[");
        Object[] table = this.table;
        for (int i = 0; i < table.length; i += 2) {
            Object key = table[i];
            if (key == null) continue;
            builder.append(AbstractIdentityHashMap.unmaskNull(key)).append(": ").append(table[i + 1]).append(", ");
        }
        int len = builder.length();
        return builder.replace(len - ", ".length(), len, "]").toString();
    }

    @Override
    public boolean equals(Object obj) {
        return Map.mapEquals((Map<? extends Object, ? extends Object>)this, obj);
    }

    @Override
    public int hashCode() {
        return Map.mapHashCode(this);
    }

    private void writeObject(@NonNull ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int len = this.table.length;
        out.writeInt(this.size);
        out.writeInt(len);
        for (int i = 0; i < len; i += 2) {
            Object key = this.table[i];
            if (key == null) continue;
            out.writeObject(AbstractIdentityHashMap.unmaskNull(key));
            out.writeObject(this.table[i + 1]);
        }
    }

    private void readObject(@NonNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.size = in.readInt();
        this.table = new Object[in.readInt()];
        for (int i = 0; i < this.size; i += 2) {
            this.putInternal(in.readObject(), in.readObject());
        }
    }

    protected abstract class TableIterator<E>
    implements Iterator<E> {
        protected int index;
        protected int lastReturnedIndex;
        protected boolean indexValid;
        protected Object[] traversalTable;

        protected TableIterator() {
            this.index = AbstractIdentityHashMap.this.size != 0 ? 0 : AbstractIdentityHashMap.this.table.length;
            this.lastReturnedIndex = -1;
            this.traversalTable = AbstractIdentityHashMap.this.table;
        }

        @Override
        public boolean hasNext() {
            Object[] tab = this.traversalTable;
            for (int i = this.index; i < tab.length; i += 2) {
                Object key = tab[i];
                if (key == null) continue;
                this.index = i;
                this.indexValid = true;
                return true;
            }
            this.index = tab.length;
            return false;
        }

        protected int nextIndex() {
            if (!this.indexValid && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.indexValid = false;
            this.lastReturnedIndex = this.index;
            this.index += 2;
            return this.lastReturnedIndex;
        }

        @Override
        public void remove() {
            Object item;
            if (this.lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            if (AbstractIdentityHashMap.this.isImmutable()) {
                throw new ImmutableException("Iterator.remove() on Immutable Map");
            }
            int deletedSlot = this.lastReturnedIndex;
            this.lastReturnedIndex = -1;
            this.index = deletedSlot;
            this.indexValid = false;
            Object[] tab = this.traversalTable;
            int len = tab.length;
            int d = deletedSlot;
            Object key = tab[d];
            tab[d] = null;
            tab[d + 1] = null;
            if (tab != AbstractIdentityHashMap.this.table) {
                AbstractIdentityHashMap.this.removeKey(key);
                return;
            }
            --AbstractIdentityHashMap.this.size;
            int i = AbstractIdentityHashMap.nextKeyIndex(d, len);
            while ((item = tab[i]) != null) {
                int r = AbstractIdentityHashMap.index(item, len);
                if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                    if (i < deletedSlot && d >= deletedSlot && this.traversalTable == AbstractIdentityHashMap.this.table) {
                        int remaining = len - deletedSlot;
                        Object[] newTable = new Object[remaining];
                        System.arraycopy(tab, deletedSlot, newTable, 0, remaining);
                        this.traversalTable = newTable;
                        this.index = 0;
                    }
                    tab[d] = item;
                    tab[d + 1] = tab[i + 1];
                    tab[i] = null;
                    tab[i + 1] = null;
                    d = i;
                }
                i = AbstractIdentityHashMap.nextKeyIndex(i, len);
            }
        }
    }

    protected final class TableEntry
    implements Entry<K, V> {
        private static final long serialVersionUID = 6124362820238071432L;
        protected int index;

        public TableEntry(int index) {
            this.index = index;
        }

        @Override
        public @Nullable K getKey() {
            return AbstractIdentityHashMap.unmaskNull(AbstractIdentityHashMap.this.table[this.index]);
        }

        @Override
        public @NonNull V getValue() {
            return AbstractIdentityHashMap.this.table[this.index + 1];
        }

        public @NonNull String toString() {
            return AbstractIdentityHashMap.unmaskNull(AbstractIdentityHashMap.this.table[this.index]) + " -> " + AbstractIdentityHashMap.this.table[this.index + 1];
        }

        public boolean equals(Object obj) {
            return Entry.entryEquals((Entry<? extends Object, ? extends Object>)this, obj);
        }

        public int hashCode() {
            return Entry.entryHashCode(this);
        }
    }
}

