/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.impl;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Collection;
import dyvil.collection.ImmutableSet;
import dyvil.collection.MutableSet;
import dyvil.collection.Set;
import dyvil.collection.SizedIterable;
import dyvil.collection.impl.AbstractHashMap;
import dyvil.collection.mutable.HashSet;
import dyvil.math.MathUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;

public abstract class AbstractHashSet<E>
implements Set<E> {
    private static final long serialVersionUID = -2574454530914084132L;
    protected transient int size;
    protected transient HashElement<E>[] elements;

    public AbstractHashSet() {
        this.elements = new HashElement[16];
    }

    public AbstractHashSet(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Invalid Capacity: " + capacity);
        }
        this.elements = new HashElement[MathUtils.nextPowerOf2(AbstractHashMap.grow(capacity))];
    }

    public AbstractHashSet(E @NonNull [] elements) {
        this(elements.length);
        for (E element : elements) {
            this.addInternal(element);
        }
    }

    public AbstractHashSet(@NonNull Iterable<? extends E> iterable) {
        this();
        this.addAllInternal(iterable);
    }

    public AbstractHashSet(@NonNull SizedIterable<? extends E> iterable) {
        this(iterable.size());
        this.addAllInternal((Iterable<E>)iterable);
    }

    public AbstractHashSet(@NonNull Set<? extends E> set) {
        this(set.size());
        super.loadDistinct(set);
    }

    public AbstractHashSet(@NonNull AbstractHashSet<? extends E> elements) {
        this(elements.size);
        this.size = elements.size;
        HashElement<E>[] hashElements = this.elements;
        int length = hashElements.length;
        for (HashElement<E> hashElement : elements.elements) {
            while (hashElement != null) {
                int hash = hashElement.hash;
                int index = AbstractHashMap.index(hash, length);
                hashElements[index] = new HashElement(hashElement.element, hash, hashElements[index]);
                hashElement = hashElement.next;
            }
        }
    }

    protected void flatten() {
        this.ensureCapacityInternal(this.elements.length << 1);
    }

    public void ensureCapacity(int newCapacity) {
        if (newCapacity > this.elements.length) {
            this.ensureCapacity(MathUtils.nextPowerOf2(newCapacity));
        }
    }

    protected void ensureCapacityInternal(int newCapacity) {
        HashElement<E>[] oldMap = this.elements;
        int oldCapacity = oldMap.length;
        if (newCapacity - 0x7FFFFFF7 > 0) {
            if (oldCapacity == 0x7FFFFFF7) {
                return;
            }
            newCapacity = 0x7FFFFFF7;
        }
        this.elements = new HashElement[newCapacity];
        HashElement[] newMap = this.elements;
        int i = oldCapacity;
        while (i-- > 0) {
            HashElement<E> e = oldMap[i];
            while (e != null) {
                int index = AbstractHashMap.index(e.hash, newCapacity);
                HashElement next = e.next;
                e.next = newMap[index];
                newMap[index] = e;
                e = next;
            }
        }
        this.updateThreshold(newCapacity);
    }

    protected void updateThreshold(int newCapacity) {
    }

    protected boolean addInternal(E element) {
        int hash = AbstractHashMap.hash(element);
        int i = AbstractHashMap.index(hash, this.elements.length);
        HashElement<E> e = this.elements[i];
        while (e != null) {
            Object key;
            if (e.hash == hash && ((key = e.element) == element || Objects.equals(element, key))) {
                return false;
            }
            e = e.next;
        }
        this.addElement(hash, element, i);
        return true;
    }

    protected abstract void addElement(int var1, E var2, int var3);

    protected void addAllInternal(@NonNull Iterable<? extends E> iterable) {
        for (E element : iterable) {
            this.addInternal(element);
        }
    }

    protected void addAllInternal(@NonNull SizedIterable<? extends E> iterable) {
        this.ensureCapacity(this.size + iterable.size());
        this.addAllInternal((Iterable<? extends E>)iterable);
    }

    private void loadDistinct(@NonNull Iterable<? extends E> iterable) {
        HashElement<E>[] hashElements = this.elements;
        int length = hashElements.length;
        int size = 0;
        for (E element : iterable) {
            ++size;
            int hash = AbstractHashMap.hash(element);
            int index = AbstractHashMap.index(hash, length);
            hashElements[index] = new HashElement<E>(element, hash, hashElements[index]);
        }
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public @NonNull Iterator<E> iterator() {
        return new Iterator<E>(){
            @Nullable HashElement<E> next;
            @Nullable HashElement<E> current;
            int index;
            {
                HashElement<E>[] t = AbstractHashSet.this.elements;
                this.next = null;
                this.current = null;
                this.index = 0;
                if (t != null && AbstractHashSet.this.size > 0) {
                    this.advance(t);
                }
            }

            @Override
            public final boolean hasNext() {
                return this.next != null;
            }

            @Override
            public final E next() {
                HashElement e = this.next;
                if (e == null) {
                    throw new NoSuchElementException();
                }
                this.current = e;
                this.next = this.current.next;
                if (this.next == null) {
                    HashElement<E>[] t = AbstractHashSet.this.elements;
                    if (AbstractHashSet.this.elements != null) {
                        this.advance(t);
                    }
                }
                return e.element;
            }

            private void advance(HashElement<E> @NonNull [] t) {
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }

            @Override
            public final void remove() {
                HashElement e = this.current;
                if (e == null) {
                    throw new IllegalStateException();
                }
                AbstractHashSet.this.removeElement(e);
                this.current = null;
            }
        };
    }

    protected void removeElement(@NonNull HashElement<E> element) {
        --this.size;
        int index = AbstractHashMap.index(element.hash, this.elements.length);
        HashElement<E> e = this.elements[index];
        if (e == element) {
            this.elements[index] = element.next;
        } else {
            do {
                HashElement<E> prev = e;
            } while ((e = e.next) != element);
            prev.next = element.next;
        }
    }

    @Override
    public void forEach(@NonNull Consumer<? super E> action) {
        for (HashElement<E> hashElement : this.elements) {
            while (hashElement != null) {
                action.accept(hashElement.element);
                hashElement = hashElement.next;
            }
        }
    }

    @Override
    public boolean contains(@Nullable Object element) {
        if (element == null) {
            HashElement<E> hashElement = this.elements[0];
            while (hashElement != null) {
                if (hashElement.element == null) {
                    return true;
                }
                hashElement = hashElement.next;
            }
            return false;
        }
        int hash = AbstractHashMap.hash(element);
        int index = AbstractHashMap.index(hash, this.elements.length);
        HashElement<E> hashElement = this.elements[index];
        while (hashElement != null) {
            if (hashElement.hash == hash && element.equals(hashElement.element)) {
                return true;
            }
            hashElement = hashElement.next;
        }
        return false;
    }

    @Override
    public @NonNull MutableSet<E> mutableCopy() {
        return new HashSet(this);
    }

    @Override
    public <R> @NonNull MutableSet<R> emptyCopy() {
        return new HashSet();
    }

    @Override
    public <RE> @NonNull MutableSet<RE> emptyCopy(int capacity) {
        return new HashSet(capacity);
    }

    @Override
    public @NonNull ImmutableSet<E> immutableCopy() {
        return new dyvil.collection.immutable.HashSet(this);
    }

    @Override
    public <RE> ImmutableSet.Builder<RE> immutableBuilder() {
        return dyvil.collection.immutable.HashSet.builder();
    }

    @Override
    public <RE> ImmutableSet.Builder<RE> immutableBuilder(int capacity) {
        return dyvil.collection.immutable.HashSet.builder(capacity);
    }

    @Override
    public java.util.Set<E> toJava() {
        java.util.HashSet<E> set = new java.util.HashSet<E>(this.size);
        for (E element : this) {
            set.add(element);
        }
        return set;
    }

    @Override
    public @NonNull String toString() {
        return Collection.collectionToString(this);
    }

    @Override
    public boolean equals(Object obj) {
        return Set.setEquals((Set<? extends Object>)this, obj);
    }

    @Override
    public int hashCode() {
        return Set.setHashCode(this);
    }

    private void writeObject(@NonNull ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int len = this.elements.length;
        out.writeInt(this.size);
        out.writeInt(len);
        for (int i = 0; i < len; ++i) {
            HashElement<E> element = this.elements[i];
            while (element != null) {
                out.writeObject(element.element);
                out.writeByte(i);
                element = element.next;
            }
        }
    }

    private void readObject(@NonNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.size = in.readInt();
        int len = in.readInt();
        this.elements = new HashElement[len];
        for (int i = 0; i < len; ++i) {
            this.addInternal(in.readObject());
        }
    }

    protected static final class HashElement<E> {
        public E element;
        public int hash;
        public HashElement<E> next;

        public HashElement(E element, int hash) {
            this.element = element;
            this.hash = hash;
        }

        public HashElement(E element, int hash, HashElement<E> next) {
            this.element = element;
            this.hash = hash;
            this.next = next;
        }
    }
}

