/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.impl;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.array.ObjectArray;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.Map;
import dyvil.collection.MutableMap;
import dyvil.collection.Set;
import dyvil.collection.SizedIterable;
import dyvil.collection.immutable.HashMap;
import dyvil.math.MathUtils;
import dyvil.ref.InvalidReferenceException;
import dyvil.ref.ObjectRef;
import dyvil.util.Option;
import dyvil.util.Some;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public abstract class AbstractHashMap<K, V>
implements Map<K, V> {
    private static final long serialVersionUID = 408161126967974108L;
    public static final float GROWTH_FACTOR = 1.125f;
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    protected transient int size;
    protected transient HashEntry<K, V>[] entries;

    public AbstractHashMap() {
        this.entries = new HashEntry[16];
    }

    public AbstractHashMap(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Invalid Capacity: " + capacity);
        }
        this.entries = new HashEntry[MathUtils.nextPowerOf2(AbstractHashMap.grow(capacity))];
    }

    public AbstractHashMap(Entry<? extends K, ? extends V> @NonNull [] entries) {
        this(entries.length);
        super.putAllInternal(ObjectArray.asIterable(entries));
    }

    public AbstractHashMap(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        this();
        super.putAllInternal(iterable);
    }

    public AbstractHashMap(@NonNull SizedIterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        this(iterable.size());
        super.putAllInternal((Iterable<Entry<K, V>>)iterable);
    }

    public AbstractHashMap(@NonNull Set<? extends @NonNull Entry<? extends K, ? extends V>> set) {
        this(set.size());
        super.loadDistinct(set);
    }

    public AbstractHashMap(@NonNull Map<? extends K, ? extends V> map) {
        this(map.size());
        super.loadDistinct(map);
    }

    public AbstractHashMap(@NonNull AbstractHashMap<? extends K, ? extends V> map) {
        this(map.size);
        this.size = map.size;
        HashEntry<K, V>[] hashEntries = this.entries;
        int length = hashEntries.length;
        for (HashEntry<K, V> hashEntry : map.entries) {
            while (hashEntry != null) {
                int hash = hashEntry.hash;
                int index = AbstractHashMap.index(hash, length);
                hashEntries[index] = new HashEntry(hashEntry.key, hashEntry.value, hash, hashEntries[index]);
                hashEntry = hashEntry.next;
            }
        }
    }

    public static int hash(@Nullable Object key) {
        int h = key == null ? 0 : key.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    public static int index(int h, int length) {
        return h & length - 1;
    }

    public static int grow(int size) {
        return (int)((float)(size + 1) * 1.125f);
    }

    protected void flatten() {
        this.ensureCapacityInternal(this.entries.length << 1);
    }

    public void ensureCapacity(int newCapacity) {
        if (newCapacity > this.entries.length) {
            this.ensureCapacityInternal(MathUtils.nextPowerOf2(newCapacity));
        }
    }

    protected void ensureCapacityInternal(int newCapacity) {
        HashEntry<K, V>[] oldMap = this.entries;
        int oldCapacity = oldMap.length;
        if (newCapacity - 0x7FFFFFF7 > 0) {
            if (oldCapacity == 0x7FFFFFF7) {
                return;
            }
            newCapacity = 0x7FFFFFF7;
        }
        this.entries = new HashEntry[newCapacity];
        HashEntry[] newMap = this.entries;
        int i = oldCapacity;
        while (i-- > 0) {
            HashEntry<K, V> e = oldMap[i];
            while (e != null) {
                int index = AbstractHashMap.index(e.hash, newCapacity);
                HashEntry next = e.next;
                e.next = newMap[index];
                newMap[index] = e;
                e = next;
            }
        }
        this.updateThreshold(newCapacity);
    }

    protected void updateThreshold(int newCapacity) {
    }

    protected void putInternal(@Nullable K key, V value) {
        int hash = AbstractHashMap.hash(key);
        int i = AbstractHashMap.index(hash, this.entries.length);
        HashEntry<K, V> e = this.entries[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.addEntry(hash, key, value, i);
    }

    protected abstract void addEntry(int var1, K var2, V var3, int var4);

    private void putAllInternal(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        for (Entry<K, V> entry : iterable) {
            this.putInternal(entry.getKey(), entry.getValue());
        }
    }

    protected void putAllInternal(@NonNull SizedIterable<? extends @NonNull Entry<? extends K, ? extends V>> map) {
        this.ensureCapacity(this.size + map.size());
        this.putAllInternal((Iterable<? extends Entry<? extends K, ? extends V>>)map);
    }

    private void loadDistinct(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        HashEntry<K, V>[] entries = this.entries;
        int length = this.entries.length;
        int size = 0;
        for (Entry<K, V> entry : iterable) {
            K key = entry.getKey();
            int hash = AbstractHashMap.hash(key);
            int i = AbstractHashMap.index(hash, length);
            entries[i] = new HashEntry<K, V>(key, entry.getValue(), hash, entries[i]);
            ++size;
        }
        this.size = size;
    }

    protected void removeEntry(@NonNull HashEntry<K, V> entry) {
        --this.size;
        int index = AbstractHashMap.index(entry.hash, this.entries.length);
        HashEntry<K, V> e = this.entries[index];
        if (e == entry) {
            this.entries[index] = entry.next;
        } else {
            do {
                HashEntry<K, V> prev = e;
            } while ((e = e.next) != entry);
            prev.next = entry.next;
        }
        entry.invalidate();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public @NonNull Iterator<Entry<K, V>> iterator() {
        return new EntryIterator<Entry<K, V>>(){

            @Override
            public @Nullable HashEntry<K, V> next() {
                return this.nextEntry();
            }

            public @NonNull String toString() {
                return "EntryIterator(" + AbstractHashMap.this + ")";
            }
        };
    }

    @Override
    public @NonNull Iterator<K> keyIterator() {
        return new EntryIterator<K>(){

            @Override
            public @Nullable K next() {
                return this.nextEntry().key;
            }

            public @NonNull String toString() {
                return "KeyIterator(" + AbstractHashMap.this + ")";
            }
        };
    }

    @Override
    public @NonNull Iterator<V> valueIterator() {
        return new EntryIterator<V>(){

            @Override
            public @Nullable V next() {
                return this.nextEntry().value;
            }

            public @NonNull String toString() {
                return "ValueIterator(" + AbstractHashMap.this + ")";
            }
        };
    }

    @Override
    public void forEach(@NonNull Consumer<? super Entry<K, V>> action) {
        for (HashEntry<K, V> e : this.entries) {
            while (e != null) {
                action.accept(e);
                e = e.next;
            }
        }
    }

    @Override
    public void forEach(@NonNull BiConsumer<? super K, ? super V> action) {
        for (HashEntry<K, V> e : this.entries) {
            while (e != null) {
                action.accept(e.key, e.value);
                e = e.next;
            }
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (HashEntry<K, V> e : this.entries) {
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    @Override
    public boolean contains(Object key, Object value) {
        HashEntry<K, V> entry = this.getEntryInternal(key);
        return entry != null && Objects.equals(entry.value, value);
    }

    @Override
    public @Nullable V get(Object key) {
        HashEntry<K, V> entry = this.getEntryInternal(key);
        return entry == null ? null : (V)entry.value;
    }

    @Override
    public @Nullable Entry<K, V> getEntry(Object key) {
        return this.getEntryInternal(key);
    }

    protected @Nullable HashEntry<K, V> getEntryInternal(@Nullable Object key) {
        if (key == null) {
            HashEntry<K, V> e = this.entries[0];
            while (e != null) {
                if (e.key == null) {
                    return e;
                }
                e = e.next;
            }
            return null;
        }
        int hash = AbstractHashMap.hash(key);
        HashEntry<K, V> e = this.entries[AbstractHashMap.index(hash, this.entries.length)];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public @NonNull Option<V> getOption(Object key) {
        HashEntry<K, V> entry = this.getEntryInternal(key);
        return entry == null ? Option.apply() : new Some(entry.value);
    }

    @Override
    public <RK, RV> @NonNull MutableMap<RK, RV> emptyCopy() {
        return new dyvil.collection.mutable.HashMap();
    }

    @Override
    public <RK, RV> @NonNull MutableMap<RK, RV> emptyCopy(int capacity) {
        return new dyvil.collection.mutable.HashMap(capacity);
    }

    @Override
    public @NonNull MutableMap<K, V> mutableCopy() {
        return new dyvil.collection.mutable.HashMap(this);
    }

    @Override
    public @NonNull ImmutableMap<K, V> immutableCopy() {
        return new HashMap(this);
    }

    @Override
    public <RK, RV> ImmutableMap.Builder<RK, RV> immutableBuilder() {
        return HashMap.builder();
    }

    @Override
    public <RK, RV> ImmutableMap.Builder<RK, RV> immutableBuilder(int capacity) {
        return HashMap.builder(capacity);
    }

    @Override
    public java.util.Map<K, V> toJava() {
        java.util.HashMap<K, V> map = new java.util.HashMap<K, V>(this.size);
        for (Entry<K, V> entry : this) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    @Override
    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder("[");
        for (HashEntry<K, V> entry : this.entries) {
            while (entry != null) {
                builder.append(entry.key).append(": ").append(entry.value).append(", ");
                entry = entry.next;
            }
        }
        int len = builder.length();
        return builder.replace(len - ", ".length(), len, "]").toString();
    }

    @Override
    public boolean equals(Object obj) {
        return Map.mapEquals((Map<? extends Object, ? extends Object>)this, obj);
    }

    @Override
    public int hashCode() {
        return Map.mapHashCode(this);
    }

    private void writeObject(@NonNull ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int len = this.entries.length;
        out.writeInt(this.size);
        out.writeInt(len);
        HashEntry<K, V>[] hashEntryArray = this.entries;
        int n = hashEntryArray.length;
        for (int i = 0; i < n; ++i) {
            HashEntry<K, V> entry;
            HashEntry<K, V> subEntry = entry = hashEntryArray[i];
            while (subEntry != null) {
                out.writeObject(subEntry.key);
                out.writeObject(subEntry.value);
                subEntry = subEntry.next;
            }
        }
    }

    private void readObject(@NonNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.size = in.readInt();
        int len = in.readInt();
        this.entries = new HashEntry[len];
        for (int i = 0; i < len; ++i) {
            this.putInternal(in.readObject(), in.readObject());
        }
    }

    protected abstract class EntryIterator<E>
    implements Iterator<E> {
        @Nullable HashEntry<K, V> next;
        @Nullable HashEntry<K, V> current;
        int index;

        EntryIterator() {
            HashEntry<K, V>[] t = AbstractHashMap.this.entries;
            this.next = null;
            this.current = null;
            this.index = 0;
            if (t != null && AbstractHashMap.this.size > 0) {
                this.advance(t);
            }
        }

        private void advance(HashEntry<K, V> @NonNull [] t) {
            while (this.index < t.length && (this.next = t[this.index++]) == null) {
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final @Nullable HashEntry<K, V> nextEntry() {
            HashEntry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.current = e;
            this.next = this.current.next;
            if (this.next == null) {
                HashEntry<K, V>[] t = AbstractHashMap.this.entries;
                if (AbstractHashMap.this.entries != null) {
                    this.advance(t);
                }
            }
            return e;
        }

        @Override
        public final void remove() {
            HashEntry e = this.current;
            if (e == null) {
                throw new IllegalStateException();
            }
            AbstractHashMap.this.removeEntry(e);
            this.current = null;
        }
    }

    protected static final class HashEntry<K, V>
    implements Entry<K, V>,
    ObjectRef<V> {
        private static final long serialVersionUID = 6421167357975687099L;
        public transient @Nullable K key;
        public transient @Nullable V value;
        public transient int hash;
        public transient @Nullable HashEntry<K, V> next;

        public HashEntry(K key, V value, int hash) {
            this.key = key;
            this.value = value;
            this.hash = hash;
        }

        public HashEntry(K key, V value, int hash, HashEntry<K, V> next) {
            this.key = key;
            this.value = value;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public @Nullable V get() {
            this.validateReference();
            return this.value;
        }

        @Override
        public void set(V value) {
            this.validateReference();
            this.value = value;
        }

        private void validateReference() {
            if (this.isInvalid()) {
                throw new InvalidReferenceException("Entry was removed from Map");
            }
        }

        @Override
        public @Nullable K getKey() {
            return this.key;
        }

        @Override
        public @Nullable V getValue() {
            return this.value;
        }

        public void invalidate() {
            this.key = null;
            this.value = null;
            this.hash = -1;
            this.next = null;
        }

        private boolean isInvalid() {
            return this.hash == -1 && this.key == null;
        }

        public @Nullable String toString() {
            return this.key + " -> " + this.value;
        }

        public boolean equals(Object obj) {
            return Entry.entryEquals((Entry<? extends Object, ? extends Object>)this, obj);
        }

        public int hashCode() {
            return Entry.entryHashCode(this);
        }

        private void writeObject(@NonNull ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeObject(this.key);
            out.writeObject(this.value);
            out.writeObject(this.next);
        }

        private void readObject(@NonNull ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.key = in.readObject();
            this.value = in.readObject();
            this.next = (HashEntry)in.readObject();
            this.hash = AbstractHashMap.hash(this.key);
        }
    }
}

