/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.impl;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.Map;
import dyvil.collection.MutableMap;
import dyvil.reflect.EnumReflection;
import dyvil.reflect.types.Type;
import dyvil.util.None;
import dyvil.util.Option;
import dyvil.util.Some;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public abstract class AbstractEnumMap<K extends Enum<K>, V>
implements Map<K, V> {
    private static final long serialVersionUID = 7946242151088885999L;
    protected transient Class<K> type;
    protected transient K[] keys;
    protected transient Object[] values;
    protected transient int size;

    protected AbstractEnumMap(Class<K> type, K[] keys, V[] values, int size) {
        this.type = type;
        this.keys = keys;
        this.values = values;
        this.size = size;
    }

    public AbstractEnumMap(@NonNull Type<K> type) {
        this(type.erasure());
    }

    public AbstractEnumMap(Class<K> type) {
        this.keys = EnumReflection.getEnumConstants(type);
        this.values = new Object[this.keys.length];
        this.type = type;
    }

    public AbstractEnumMap(Entry<? extends K, ? extends V> @NonNull [] entries) {
        this(AbstractEnumMap.getKeyType(entries));
        for (Entry<K, V> entry : entries) {
            this.putInternal((Enum)entry.getKey(), entry.getValue());
        }
    }

    public AbstractEnumMap(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> map) {
        this(AbstractEnumMap.getKeyType(map));
        super.putAllInternal(map);
    }

    public AbstractEnumMap(@NonNull AbstractEnumMap<? extends K, ? extends V> map) {
        this.keys = map.keys;
        this.type = map.type;
        this.values = (Object[])map.values.clone();
        this.size = map.size;
    }

    protected static <K extends Enum<K>> Class<K> getKeyType(@Nullable K key) {
        if (key != null) {
            return key.getDeclaringClass();
        }
        throw new IllegalArgumentException("Invalid Enum Map - Could not get Enum type");
    }

    protected static <K extends Enum<K>> Class<K> getKeyType(Entry<? extends K, ?> @NonNull [] array) {
        for (Entry<K, ?> entry : array) {
            Enum key = (Enum)entry.getKey();
            if (key == null) continue;
            return key.getDeclaringClass();
        }
        throw new IllegalArgumentException("Invalid Enum Map - Could not get Enum type");
    }

    protected static <K extends Enum<K>> Class<K> getKeyType(@NonNull Iterable<? extends @NonNull Entry<? extends K, ?>> iterable) {
        for (Entry<K, ?> entry : iterable) {
            Enum key = (Enum)entry.getKey();
            if (key == null) continue;
            return key.getDeclaringClass();
        }
        throw new IllegalArgumentException("Invalid Enum Map - Could not get Enum type");
    }

    protected void putInternal(@NonNull K key, V value) {
        int index = ((Enum)key).ordinal();
        if (this.values[index] == null) {
            ++this.size;
        }
        this.values[index] = value;
    }

    private void putAllInternal(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> map) {
        for (Entry<K, V> entry : map) {
            this.putInternal((Enum)entry.getKey(), entry.getValue());
        }
    }

    protected static boolean checkType(Class<?> type, @Nullable Object key) {
        return key != null && key.getClass() == type;
    }

    protected static int index(@NonNull Object key) {
        return ((Enum)key).ordinal();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public @NonNull Iterator<Entry<K, V>> iterator() {
        return new EnumIterator<Entry<K, V>>(){

            @Override
            public @NonNull Entry<K, V> next() {
                return new EnumEntry(this.nextIndex());
            }

            public @NonNull String toString() {
                return "EntryIterator(" + AbstractEnumMap.this + ")";
            }
        };
    }

    @Override
    public @NonNull Iterator<K> keyIterator() {
        return new EnumIterator<K>(){

            @Override
            public K next() {
                return AbstractEnumMap.this.keys[this.nextIndex()];
            }

            public @NonNull String toString() {
                return "KeyIterator(" + AbstractEnumMap.this + ")";
            }
        };
    }

    @Override
    public @NonNull Iterator<V> valueIterator() {
        return new EnumIterator<V>(){

            @Override
            public @NonNull V next() {
                return AbstractEnumMap.this.values[this.nextIndex()];
            }

            public @NonNull String toString() {
                return "ValueIterator(" + AbstractEnumMap.this + ")";
            }
        };
    }

    protected abstract void removeAt(int var1);

    @Override
    public boolean containsKey(@NonNull Object key) {
        return AbstractEnumMap.checkType(this.type, key) && this.values[AbstractEnumMap.index(key)] != null;
    }

    @Override
    public boolean contains(@NonNull Object key, Object value) {
        if (!AbstractEnumMap.checkType(this.type, key)) {
            return false;
        }
        Object v = this.values[((Enum)key).ordinal()];
        return Objects.equals(v, value);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Object thisValue : this.values) {
            if (!Objects.equals(thisValue, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(@NonNull Object key) {
        if (!AbstractEnumMap.checkType(this.type, key)) {
            return null;
        }
        return (V)this.values[AbstractEnumMap.index(key)];
    }

    @Override
    public @Nullable Entry<K, V> getEntry(final @NonNull Object key) {
        if (!AbstractEnumMap.checkType(this.type, key)) {
            return null;
        }
        final int index = AbstractEnumMap.index(key);
        if (this.values[index] == null) {
            return null;
        }
        return new Entry<K, V>(){

            @Override
            public @NonNull K getKey() {
                return (Enum)key;
            }

            @Override
            public @NonNull V getValue() {
                return AbstractEnumMap.this.values[index];
            }
        };
    }

    @Override
    public @NonNull Option<V> getOption(@NonNull Object key) {
        if (!AbstractEnumMap.checkType(this.type, key)) {
            return None.instance;
        }
        return new Some<Object>(this.values[AbstractEnumMap.index(key)]);
    }

    @Override
    public <RK, RV> @NonNull MutableMap<RK, RV> emptyCopy() {
        return MutableMap.apply();
    }

    @Override
    public <RK, RV> MutableMap<RK, RV> emptyCopy(int capacity) {
        return MutableMap.withCapacity(capacity);
    }

    @Override
    public @NonNull MutableMap<K, V> mutableCopy() {
        return new dyvil.collection.mutable.EnumMap(this);
    }

    @Override
    public @NonNull ImmutableMap<K, V> immutableCopy() {
        return new dyvil.collection.immutable.EnumMap(this);
    }

    @Override
    public <RK, RV> ImmutableMap.Builder<RK, RV> immutableBuilder() {
        return ImmutableMap.builder();
    }

    @Override
    public <RK, RV> ImmutableMap.Builder<RK, RV> immutableBuilder(int capacity) {
        return ImmutableMap.builder();
    }

    @Override
    public java.util.Map<K, V> toJava() {
        EnumMap<K, Object> map = new EnumMap<K, Object>(this.type);
        for (int i = 0; i < this.keys.length; ++i) {
            Object value = this.values[i];
            if (value == null) continue;
            map.put(this.keys[i], value);
        }
        return map;
    }

    @Override
    public String toString() {
        return Map.mapToString(this);
    }

    @Override
    public boolean equals(Object obj) {
        return Map.mapEquals((Map<? extends Object, ? extends Object>)this, obj);
    }

    @Override
    public int hashCode() {
        return Map.mapHashCode(this);
    }

    private void writeObject(@NonNull ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.type);
        out.writeInt(this.size);
        int entriesToBeWritten = this.size;
        int i = 0;
        while (entriesToBeWritten > 0) {
            if (this.values[i] != null) {
                out.writeObject(this.keys[i]);
                out.writeObject(this.values[i]);
                --entriesToBeWritten;
            }
            ++i;
        }
    }

    private void readObject(@NonNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.type = (Class)in.readObject();
        this.keys = EnumReflection.getEnumConstants(this.type);
        this.values = new Object[this.keys.length];
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Enum key = (Enum)in.readObject();
            Object value = in.readObject();
            this.putInternal(key, value);
        }
    }

    protected abstract class EnumIterator<E>
    implements Iterator<E> {
        private int index;
        private boolean indexValid;

        protected EnumIterator() {
        }

        @Override
        public boolean hasNext() {
            Object[] tab = AbstractEnumMap.this.values;
            for (int i = this.index; i < tab.length; ++i) {
                Object key = tab[i];
                if (key == null) continue;
                this.index = i;
                this.indexValid = true;
                return true;
            }
            this.index = tab.length;
            return false;
        }

        protected int nextIndex() {
            if (!this.indexValid && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.indexValid = false;
            return this.index++;
        }

        @Override
        public void remove() {
            if (this.index == 0) {
                throw new IllegalStateException();
            }
            AbstractEnumMap.this.removeAt(--this.index);
        }
    }

    protected class EnumEntry
    implements Entry<K, V> {
        private static final long serialVersionUID = 4125489955668261409L;
        int index;

        EnumEntry(int index) {
            this.index = index;
        }

        @Override
        public K getKey() {
            return AbstractEnumMap.this.keys[this.index];
        }

        @Override
        public @NonNull V getValue() {
            return AbstractEnumMap.this.values[this.index];
        }

        public @NonNull String toString() {
            return AbstractEnumMap.this.keys[this.index] + " -> " + AbstractEnumMap.this.values[this.index];
        }

        public boolean equals(Object obj) {
            return Entry.entryEquals((Entry<? extends Object, ? extends Object>)this, obj);
        }

        public int hashCode() {
            return Entry.entryHashCode(this);
        }
    }
}

