/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.impl;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.array.LongArray;
import dyvil.collection.Collection;
import dyvil.collection.ImmutableSet;
import dyvil.collection.MutableSet;
import dyvil.collection.Set;
import dyvil.collection.SizedIterable;
import dyvil.collection.immutable.BitSet;
import dyvil.collection.impl.AbstractBitSet;
import dyvil.math.MathUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Iterator;

public abstract class AbstractBitSet
implements Set<Integer> {
    protected static final int DEFAULT_CAPACITY = 10;
    protected transient int size;
    protected transient long @NonNull [] words = null;

    public AbstractBitSet() {
        this(10);
    }

    public AbstractBitSet(int capacity) {
        this.words = new long[MathUtils.ceil((float)capacity / (float)64)];
    }

    public AbstractBitSet(int @NonNull [] elements) {
        this(elements.length);
        int[] nArray = elements;
        int n = nArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                int i = nArray[n2];
                this.setBit(i);
            } while (++n2 < n);
        }
    }

    public AbstractBitSet(@NonNull Iterable<? extends Integer> iterable) {
        this();
        Iterator<? extends Integer> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            int i = iterator.next();
            this.setBit(i);
        }
    }

    public AbstractBitSet(@NonNull SizedIterable<? extends Integer> iterable) {
        this(iterable.size());
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            this.setBit(i);
        }
    }

    public AbstractBitSet(@NonNull AbstractBitSet bitSet) {
        this.size = bitSet.size;
        this.words = LongArray.copy(bitSet.words);
    }

    protected static int wordIndex(int bit) {
        return bit / 64;
    }

    protected static int bitIndex(int bit) {
        return bit % 64;
    }

    protected static boolean bitSet(long word, int bit) {
        return (word & 1L << bit) != 0L;
    }

    protected static long mask(int bit) {
        return 1L << bit;
    }

    protected void ensureWordCapacity(int wordCount) {
        long[] newWords = new long[wordCount];
        System.arraycopy(this.words, 0, newWords, 0, this.words.length);
        this.words = newWords;
    }

    protected boolean bitSet(int bit) {
        int wordIndex = AbstractBitSet.wordIndex(bit);
        if (wordIndex >= this.words.length) {
            return false;
        }
        int bitIndex = AbstractBitSet.bitIndex(bit);
        long word = this.words[wordIndex];
        return AbstractBitSet.bitSet(word, bitIndex);
    }

    protected int nextSetBit(int start) {
        int n = this.words.length * 64;
        for (int i = start + 1; i < n; ++i) {
            if (!this.bitSet(i)) continue;
            return i;
        }
        return -1;
    }

    protected void setBit(int bit) {
        int wordIndex = AbstractBitSet.wordIndex(bit);
        long value = AbstractBitSet.mask(AbstractBitSet.bitIndex(bit));
        if (wordIndex >= this.words.length) {
            this.ensureWordCapacity(wordIndex + 1);
            this.words[wordIndex] = value;
            AbstractBitSet sideEffect$0 = this;
            ++sideEffect$0.size;
            return;
        }
        long l = this.words[wordIndex];
        long newWord = l | value;
        if (newWord != l) {
            this.words[wordIndex] = newWord;
            AbstractBitSet sideEffect$0 = this;
            ++sideEffect$0.size;
        }
    }

    protected void clearBit(int bit) {
        int wordIndex = AbstractBitSet.wordIndex(bit);
        if (wordIndex >= this.words.length) {
            return;
        }
        long word = this.words[wordIndex];
        long newWord = word & (AbstractBitSet.mask(AbstractBitSet.bitIndex(bit)) ^ 0xFFFFFFFFFFFFFFFFL);
        if (newWord != word) {
            this.words[wordIndex] = newWord;
            AbstractBitSet sideEffect$0 = this;
            --sideEffect$0.size;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public @NonNull Iterator<@Primitive Integer> iterator() {
        return new 1(this);
    }

    protected abstract void removeAt(int var1);

    @Override
    public boolean contains(@Primitive Object element) {
        boolean bl;
        Object object = element;
        if (object instanceof Integer) {
            int n = (Integer)object;
            bl = this.bitSet(n);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void toArray(int index, Object @NonNull [] store) {
        int n = this.words.length;
        for (int wordIndex = 0; wordIndex < n; ++wordIndex) {
            long word = this.words[wordIndex];
            int n2 = 64;
            for (int bit = 0; bit < n2; ++bit) {
                if (!AbstractBitSet.bitSet(word, bit)) continue;
                store[index] = wordIndex * 64 + bit;
                ++index;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public int @NonNull [] toIntArray() {
        void var1_1;
        int[] store = new int[this.size];
        this.toIntArray(0, store);
        return var1_1;
    }

    public void toIntArray(int @NonNull [] store) {
        this.toIntArray(0, store);
    }

    public void toIntArray(int index, int @NonNull [] store) {
        int n = this.words.length;
        for (int wordIndex = 0; wordIndex < n; ++wordIndex) {
            long word = this.words[wordIndex];
            int n2 = 64;
            for (int bit = 0; bit < n2; ++bit) {
                if (!AbstractBitSet.bitSet(word, bit)) continue;
                store[index] = wordIndex * 64 + bit;
                ++index;
            }
        }
    }

    @Override
    public <RE> @NonNull MutableSet<RE> emptyCopy() {
        return MutableSet.apply();
    }

    @Override
    public <RE> @NonNull MutableSet<RE> emptyCopy(int capacity) {
        return MutableSet.withCapacity(capacity);
    }

    @Override
    public @NonNull MutableSet<@Primitive Integer> mutableCopy() {
        return new dyvil.collection.mutable.BitSet(this);
    }

    @Override
    public @NonNull ImmutableSet<@Primitive Integer> immutableCopy() {
        return new BitSet(this);
    }

    @Override
    public <RE> @NonNull ImmutableSet.Builder<RE> immutableBuilder() {
        return ImmutableSet.builder();
    }

    @Override
    public <RE> @NonNull ImmutableSet.Builder<RE> immutableBuilder(int capacity) {
        return ImmutableSet.builder(capacity);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public @NonNull java.util.Set<@Primitive Integer> toJava() {
        void var1_1;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            int element = (Integer)iterator.next();
            hashSet.add(element);
        }
        return var1_1;
    }

    @Override
    public @NonNull String toString() {
        return Collection.collectionToString(this);
    }

    @Override
    public boolean equals(@Primitive Object obj) {
        return Set.setEquals((Set<? extends Object>)this, obj);
    }

    @Override
    public int hashCode() {
        return Set.setHashCode(this);
    }

    private void writeObject(@NonNull ObjectOutputStream out) throws @NonNull IOException {
        out.defaultWriteObject();
        out.writeInt(this.size);
        out.writeInt(this.words.length);
        long[] lArray = this.words;
        int n = lArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                long word = lArray[n2];
                out.writeLong(word);
            } while (++n2 < n);
        }
    }

    private void readObject(@NonNull ObjectInputStream in) throws @NonNull IOException, @NonNull ClassNotFoundException {
        in.defaultReadObject();
        this.size = in.readInt();
        int wordCount = in.readInt();
        this.words = new long[wordCount];
        int n = wordCount;
        for (int i = 0; i < n; ++i) {
            this.words[i] = in.readLong();
        }
    }
}

