/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.impl;

import dyvil.annotation.internal.NonNull;
import dyvil.collection.Collection;
import dyvil.collection.ImmutableSet;
import dyvil.collection.MutableSet;
import dyvil.collection.Set;
import dyvil.collection.mutable.ArraySet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.function.Function;

public abstract class AbstractArraySet<E>
implements Set<E> {
    private static final long serialVersionUID = -7004392809193010314L;
    protected static final int DEFAULT_CAPACITY = 16;
    protected transient Object[] elements;
    protected transient int size;

    protected AbstractArraySet() {
        this.elements = new Object[16];
    }

    protected AbstractArraySet(int capacity) {
        this.elements = new Object[capacity];
    }

    @SafeVarargs
    public AbstractArraySet(E ... elements) {
        this.elements = (Object[])elements.clone();
        this.size = Set.distinct(this.elements, elements.length);
    }

    public AbstractArraySet(E @NonNull [] elements, int size) {
        this.elements = new Object[size];
        System.arraycopy(elements, 0, this.elements, 0, size);
        this.size = Set.distinct(this.elements, size);
    }

    public AbstractArraySet(E @NonNull [] elements, boolean trusted) {
        this.elements = elements;
        this.size = Set.distinct(elements, elements.length);
    }

    public AbstractArraySet(E[] elements, int size, boolean trusted) {
        this.elements = elements;
        this.size = size;
    }

    public AbstractArraySet(@NonNull Iterable<? extends E> iterable) {
        this();
        this.addAllInternal(iterable);
    }

    public AbstractArraySet(@NonNull Collection<? extends E> collection) {
        this(collection.size());
        this.addAllInternal(collection);
    }

    public AbstractArraySet(@NonNull Set<? extends E> set) {
        this(set.size());
        this.addAllInternal(set);
    }

    public AbstractArraySet(@NonNull AbstractArraySet<? extends E> arraySet) {
        this.elements = (Object[])arraySet.elements.clone();
        this.size = arraySet.size;
    }

    protected boolean addInternal(E element) {
        for (int i = 0; i < this.size; ++i) {
            if (!Objects.equals(this.elements[i], element)) continue;
            return false;
        }
        int index = this.size++;
        this.ensureCapacityInternal(index + 1);
        this.elements[index] = element;
        return true;
    }

    protected void addAllInternal(@NonNull Iterable<? extends E> iterable) {
        for (E element : iterable) {
            this.addInternal(element);
        }
    }

    protected void addAllInternal(@NonNull Set<? extends E> set) {
        this.ensureCapacityInternal(this.size + set.size());
        set.toArray(this.size, this.elements);
    }

    protected void ensureCapacityInternal(int minCapacity) {
        int length = this.elements.length;
        if (minCapacity - length <= 0) {
            return;
        }
        int newCapacity = length + (length >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        this.elements = Arrays.copyOf(this.elements, newCapacity);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean isSorted() {
        return Collection.isSorted(this.elements, this.size);
    }

    @Override
    public boolean isSorted(@NonNull Comparator<? super E> comparator) {
        return Collection.isSorted(this.elements, this.size, comparator);
    }

    @Override
    public @NonNull Iterator<E> iterator() {
        return new Iterator<E>(){
            int index;

            @Override
            public boolean hasNext() {
                return this.index < AbstractArraySet.this.size;
            }

            @Override
            public @NonNull E next() {
                return AbstractArraySet.this.elements[this.index++];
            }

            @Override
            public void remove() {
                if (this.index <= 0) {
                    throw new IllegalStateException();
                }
                AbstractArraySet.this.removeAt(--this.index);
            }

            public @NonNull String toString() {
                return "SetIterator(" + AbstractArraySet.this + ")";
            }
        };
    }

    protected abstract void removeAt(int var1);

    @Override
    public boolean contains(Object element) {
        for (int i = 0; i < this.size; ++i) {
            if (!Objects.equals(this.elements[i], element)) continue;
            return true;
        }
        return false;
    }

    protected void mapImpl(@NonNull Function<? super E, ? extends E> mapper) {
        int index = 0;
        block0: for (int i = 0; i < this.size; ++i) {
            E newElement = mapper.apply(this.elements[i]);
            for (int j = 0; j < index; ++j) {
                if (Objects.equals(this.elements[i], newElement)) continue block0;
            }
            this.elements[index++] = newElement;
        }
        this.size = index;
    }

    protected void flatMapImpl(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends E>> mapper) {
        Object[] newArray = new Object[this.size << 2];
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            block1: for (E result : mapper.apply(this.elements[i])) {
                int index1;
                for (int j = 0; j < index; ++j) {
                    if (Objects.equals(newArray[j], result)) continue block1;
                }
                if ((index1 = index++) >= newArray.length) {
                    Object[] temp = new Object[index << 1];
                    System.arraycopy(newArray, 0, temp, 0, newArray.length);
                    newArray = temp;
                }
                newArray[index1] = result;
            }
        }
        this.elements = newArray;
        this.size = index;
    }

    @Override
    public void toArray(int index, @NonNull Object @NonNull [] store) {
        System.arraycopy(this.elements, 0, store, index, this.size);
    }

    @Override
    public <R> @NonNull MutableSet<R> emptyCopy() {
        return new ArraySet();
    }

    @Override
    public <RE> @NonNull MutableSet<RE> emptyCopy(int capacity) {
        return new ArraySet(capacity);
    }

    @Override
    public @NonNull MutableSet<E> mutableCopy() {
        return new ArraySet<Object>(this.elements, this.size);
    }

    @Override
    public @NonNull ImmutableSet<E> immutableCopy() {
        return new dyvil.collection.immutable.ArraySet<Object>(this.elements, this.size);
    }

    @Override
    public <RE> @NonNull ImmutableSet.Builder<RE> immutableBuilder() {
        return dyvil.collection.immutable.ArraySet.builder();
    }

    @Override
    public <RE> @NonNull ImmutableSet.Builder<RE> immutableBuilder(int capacity) {
        return dyvil.collection.immutable.ArraySet.builder(capacity);
    }

    @Override
    public java.util.Set<E> toJava() {
        LinkedHashSet<Object> set = new LinkedHashSet<Object>(this.size);
        for (int i = 0; i < this.size; ++i) {
            set.add(this.elements[i]);
        }
        return set;
    }

    @Override
    public @NonNull String toString() {
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder(this.size << 3).append("[");
        builder.append(this.elements[0]);
        for (int i = 1; i < this.size; ++i) {
            builder.append(", ").append(this.elements[i]);
        }
        return builder.append("]").toString();
    }

    @Override
    public boolean equals(Object obj) {
        return Set.setEquals((Set<? extends Object>)this, obj);
    }

    @Override
    public int hashCode() {
        return Set.setHashCode(this);
    }

    private void writeObject(@NonNull ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeObject(this.elements[i]);
        }
    }

    private void readObject(@NonNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.size = in.readInt();
        this.elements = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.elements[i] = in.readObject();
        }
    }
}

