/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.immutable;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Collection;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.Map;
import dyvil.collection.MutableMap;
import dyvil.collection.Set;
import dyvil.collection.SizedIterable;
import dyvil.collection.impl.AbstractTupleMap;
import dyvil.lang.LiteralConvertible;
import dyvil.tuple.Tuple;
import dyvil.util.ImmutableException;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

@Immutable
@LiteralConvertible.FromArray
public class TupleMap<K, V>
extends AbstractTupleMap<K, V>
implements ImmutableMap<K, V> {
    private static final long serialVersionUID = -5372836862143742212L;

    public static <K, V> @NonNull TupleMap<K, V> singleton(K key, V value) {
        return TupleMap.apply(new Tuple.Of2<K, V>(key, value));
    }

    public static <K, V> @NonNull TupleMap<K, V> apply() {
        return new TupleMap<K, V>(0);
    }

    @SafeVarargs
    public static <K, V> @NonNull TupleMap<K, V> apply(Entry<? extends K, ? extends V> ... entries) {
        return new TupleMap<K, V>(entries);
    }

    @SafeVarargs
    public static <K, V> @NonNull TupleMap<K, V> apply(Tuple.Of2<? extends K, ? extends V> ... entries) {
        return new TupleMap<K, V>(entries, true);
    }

    public static <K, V> @NonNull TupleMap<K, V> from(@NonNull Entry<? extends K, ? extends V> @NonNull [] array) {
        return new TupleMap<K, V>(array);
    }

    public static <K, V> @NonNull TupleMap<K, V> from(@NonNull Tuple.Of2<? extends K, ? extends V> @NonNull [] array) {
        return new TupleMap<K, V>(array);
    }

    public static <K, V> @NonNull TupleMap<K, V> from(@NonNull Set<? extends @NonNull Entry<? extends K, ? extends V>> set) {
        return new TupleMap<K, V>(set);
    }

    public static <K, V> @NonNull TupleMap<K, V> from(@NonNull Map<? extends K, ? extends V> map) {
        return new TupleMap<K, V>(map);
    }

    public static <K, V> @NonNull TupleMap<K, V> from(@NonNull AbstractTupleMap<? extends K, ? extends V> tupleMap) {
        return new TupleMap<K, V>(tupleMap);
    }

    public static <K, V> @NonNull Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> @NonNull Builder<K, V> builder(int capacity) {
        return new Builder(capacity);
    }

    protected TupleMap(int capacity) {
        super(capacity);
    }

    public TupleMap(@NonNull Entry<? extends K, ? extends V> @NonNull [] entries) {
        super(entries);
    }

    public TupleMap(@NonNull Tuple.Of2<? extends K, ? extends V> @NonNull [] entries) {
        super(entries);
    }

    public TupleMap(@NonNull Tuple.Of2<? extends K, ? extends V> @NonNull [] entries, int size) {
        super(entries, size);
    }

    public TupleMap(@NonNull Tuple.Of2<? extends K, ? extends V> @NonNull [] entries, boolean trusted) {
        super(entries, trusted);
    }

    public TupleMap(@NonNull Tuple.Of2<? extends K, ? extends V> @NonNull [] entries, int size, boolean trusted) {
        super(entries, size, trusted);
    }

    public TupleMap(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        super(iterable);
    }

    public TupleMap(@NonNull SizedIterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        super(iterable);
    }

    public TupleMap(@NonNull Set<? extends @NonNull Entry<? extends K, ? extends V>> set) {
        super(set);
    }

    public TupleMap(@NonNull Map<? extends K, ? extends V> map) {
        super(map);
    }

    public TupleMap(@NonNull AbstractTupleMap<? extends K, ? extends V> map) {
        super(map);
    }

    @Override
    public @Nullable Entry<K, V> getEntry(Object key) {
        int index = this.getIndex(key);
        if (index < 0) {
            return null;
        }
        return new Tuple.Of2(key, this.entries[index]._2);
    }

    @Override
    protected void removeAt(int index) {
        throw new ImmutableException("Iterator.remove() on Immutable Map");
    }

    @Override
    public @NonNull ImmutableMap<K, V> withEntry(K key, V value) {
        TupleMap<K, V> copy = new TupleMap<K, V>(this);
        copy.putInternal(new Tuple.Of2<K, V>(key, value));
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> union(@NonNull Map<? extends K, ? extends V> map) {
        TupleMap<? extends K, ? extends V> copy = new TupleMap<K, V>(this);
        for (Entry<K, V> entry : map) {
            copy.putInternal(entry.toTuple());
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> keyRemoved(Object key) {
        Tuple.Of2[] entries = new Tuple.Of2[this.size];
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            Tuple.Of2 entry = this.entries[i];
            if (Objects.equals(key, entry._1)) continue;
            entries[index++] = entry;
        }
        return new TupleMap<K, V>(entries, index, true);
    }

    @Override
    public @NonNull ImmutableMap<K, V> removed(Object key, Object value) {
        Tuple.Of2[] entries = new Tuple.Of2[this.size];
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            Tuple.Of2 entry = this.entries[i];
            if (Objects.equals(key, entry._1) && Objects.equals(value, entry._2)) continue;
            entries[index++] = entry;
        }
        return new TupleMap<K, V>(entries, index, true);
    }

    @Override
    public @NonNull ImmutableMap<K, V> valueRemoved(Object value) {
        Tuple.Of2[] entries = new Tuple.Of2[this.size];
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            Tuple.Of2 entry = this.entries[i];
            if (Objects.equals(value, entry._2)) continue;
            entries[index++] = entry;
        }
        return new TupleMap<K, V>(entries, index, true);
    }

    @Override
    public @NonNull ImmutableMap<K, V> difference(@NonNull Map<?, ?> map) {
        Tuple.Of2[] entries = new Tuple.Of2[this.size];
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            Tuple.Of2 entry = this.entries[i];
            if (map.contains(entry)) continue;
            entries[index++] = entry;
        }
        return new TupleMap<K, V>(entries, index, true);
    }

    @Override
    public @NonNull ImmutableMap<K, V> keyDifference(@NonNull Collection<?> keys) {
        Tuple.Of2[] entries = new Tuple.Of2[this.size];
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            Tuple.Of2 entry = this.entries[i];
            if (keys.contains(entry._1)) continue;
            entries[index++] = entry;
        }
        return new TupleMap<K, V>(entries, index, true);
    }

    @Override
    public <NK> @NonNull ImmutableMap<NK, V> keyMapped(@NonNull BiFunction<? super K, ? super V, ? extends NK> mapper) {
        int len = this.size;
        TupleMap copy = new TupleMap(len);
        for (int i = 0; i < len; ++i) {
            Tuple.Of2 entry = this.entries[i];
            Object value = entry._2;
            copy.putInternal(new Tuple.Of2(mapper.apply(entry._1, value), value));
        }
        return copy;
    }

    @Override
    public <NV> @NonNull ImmutableMap<K, NV> valueMapped(@NonNull BiFunction<? super K, ? super V, ? extends NV> mapper) {
        Tuple.Of2[] entries = new Tuple.Of2[this.size];
        for (int i = 0; i < this.size; ++i) {
            Tuple.Of2 entry = this.entries[i];
            Object key = entry._1;
            entries[i] = new Tuple.Of2(key, mapper.apply(key, entry._2));
        }
        return new TupleMap<K, V>(entries, this.size, true);
    }

    @Override
    public <NK, NV> @NonNull ImmutableMap<NK, NV> entryMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Entry<? extends NK, ? extends NV>> mapper) {
        int len = this.size;
        TupleMap<? extends NK, ? extends NV> copy = new TupleMap<NK, NV>(len);
        for (int i = 0; i < len; ++i) {
            Tuple.Of2 entry = this.entries[i];
            Entry<NK, NV> newEntry = mapper.apply(entry._1, entry._2);
            if (newEntry == null) continue;
            copy.putInternal(newEntry.toTuple());
        }
        return copy;
    }

    @Override
    public <NK, NV> @NonNull ImmutableMap<NK, NV> flatMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Iterable<? extends @NonNull Entry<? extends NK, ? extends NV>>> mapper) {
        int len = this.size;
        TupleMap<? extends NK, ? extends NV> copy = new TupleMap<NK, NV>(len);
        for (int i = 0; i < len; ++i) {
            Tuple.Of2 entry = this.entries[i];
            for (Entry<NK, NV> newEntry : mapper.apply(entry._1, entry._2)) {
                copy.putInternal(newEntry.toTuple());
            }
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> filtered(@NonNull BiPredicate<? super K, ? super V> predicate) {
        Tuple.Of2[] entries = new Tuple.Of2[this.size];
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            Tuple.Of2 entry = this.entries[i];
            if (!predicate.test(entry._1, entry._2)) continue;
            entries[index++] = entry;
        }
        return new TupleMap<K, V>(entries, index, true);
    }

    @Override
    public @NonNull ImmutableMap<V, K> inverted() {
        int len = this.size;
        TupleMap copy = new TupleMap(len);
        for (int i = 0; i < len; ++i) {
            Tuple.Of2 entry = this.entries[i];
            copy.putInternal(new Tuple.Of2(entry._2, entry._1));
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> copy() {
        return this.immutableCopy();
    }

    @Override
    public @NonNull MutableMap<K, V> mutable() {
        return this.mutableCopy();
    }

    @Override
    public @NonNull java.util.Map<K, V> toJava() {
        return Collections.unmodifiableMap(super.toJava());
    }

    public static class Builder<K, V>
    implements ImmutableMap.Builder<K, V> {
        private TupleMap<K, V> map;

        public Builder() {
            this.map = new TupleMap(16);
        }

        public Builder(int capacity) {
            this.map = new TupleMap(capacity);
        }

        @Override
        public void put(K key, V value) {
            if (this.map == null) {
                throw new IllegalStateException("Already built");
            }
            ((TupleMap)this.map).putInternal(new Tuple.Of2<K, V>(key, value));
        }

        @Override
        public void put(@NonNull Entry<? extends K, ? extends V> entry) {
            if (this.map == null) {
                throw new IllegalStateException("Already built");
            }
            ((TupleMap)this.map).putInternal(entry.toTuple());
        }

        @Override
        public TupleMap<K, V> build() {
            TupleMap<K, V> map = this.map;
            this.map = null;
            return map;
        }
    }
}

