/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.immutable;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.ImmutableSet;
import dyvil.collection.immutable.MapBasedSet;
import dyvil.collection.immutable.TreeMap;
import dyvil.lang.LiteralConvertible;
import java.util.Comparator;

@Immutable
@LiteralConvertible.FromArray
public class TreeSet<E>
extends MapBasedSet<E> {
    private static final long serialVersionUID = -6636571715777235576L;

    public static <E> @NonNull TreeSet<E> apply() {
        return new TreeSet<E>();
    }

    @SafeVarargs
    public static <E> @NonNull TreeSet<E> apply(E ... elements) {
        return new TreeSet<E>(elements);
    }

    public static <E> @NonNull TreeSet<E> from(E @NonNull [] array) {
        return new TreeSet<E>(array);
    }

    public static <E> @NonNull TreeSet<E> from(@NonNull Iterable<? extends E> iterable) {
        return new TreeSet<E>(TreeSet.buildMap(iterable));
    }

    public static <E> @NonNull Builder<E> builder() {
        return new Builder();
    }

    public static <E> @NonNull Builder<E> builder(Comparator<? super E> comparator) {
        return new Builder<E>(comparator);
    }

    private TreeSet() {
        super(new TreeMap());
    }

    public TreeSet(Comparator<? super E> comparator) {
        super(new TreeMap(comparator));
    }

    public TreeSet(E @NonNull [] elements) {
        super(TreeSet.buildMap(elements));
    }

    public TreeSet(@NonNull Iterable<? extends E> iterable) {
        super(TreeSet.buildMap(iterable));
    }

    protected TreeSet(TreeMap<E, Boolean> map) {
        super(map);
    }

    private static <E> @Nullable TreeMap<E, Boolean> buildMap(E @NonNull [] array) {
        TreeMap.Builder<E, Boolean> builder = new TreeMap.Builder<E, Boolean>();
        for (E element : array) {
            builder.put(element, true);
        }
        return builder.build();
    }

    private static <E> @Nullable TreeMap<E, Boolean> buildMap(@NonNull Iterable<? extends E> iterable) {
        TreeMap.Builder<E, Boolean> builder = new TreeMap.Builder<E, Boolean>();
        for (E element : iterable) {
            builder.put(element, true);
        }
        return builder.build();
    }

    public static class Builder<E>
    implements ImmutableSet.Builder<E> {
        private TreeMap.Builder<E, Boolean> mapBuilder;

        public Builder() {
            this.mapBuilder = new TreeMap.Builder();
        }

        public Builder(Comparator<? super E> comparator) {
            this.mapBuilder = new TreeMap.Builder(comparator);
        }

        @Override
        public void add(E element) {
            this.mapBuilder.put(element, true);
        }

        @Override
        public ImmutableSet<E> build() {
            return new TreeSet(this.mapBuilder.build());
        }
    }
}

