/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.immutable;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Collection;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.Map;
import dyvil.collection.MutableMap;
import dyvil.collection.impl.AbstractTreeMap;
import dyvil.lang.LiteralConvertible;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

@Immutable
@LiteralConvertible.FromArray
public class TreeMap<K, V>
extends AbstractTreeMap<K, V>
implements ImmutableMap<K, V> {
    private static final long serialVersionUID = 2012245218476747334L;

    public static <K, V> @NonNull TreeMap<K, V> singleton(K key, V value) {
        TreeMap<K, V> result = new TreeMap<K, V>();
        result.putInternal(key, value);
        return result;
    }

    @SafeVarargs
    public static <K extends Comparable<K>, V> @NonNull TreeMap<K, V> apply(Entry<? extends K, ? extends V> ... entries) {
        return new TreeMap<K, V>(entries);
    }

    public static <K extends Comparable<K>, V> @NonNull TreeMap<K, V> from(@NonNull Entry<? extends K, ? extends V> @NonNull [] array) {
        return new TreeMap<K, V>(array);
    }

    public static <K extends Comparable<K>, V> @NonNull TreeMap<K, V> from(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        return new TreeMap<K, V>(iterable);
    }

    public static <K extends Comparable<K>, V> @NonNull TreeMap<K, V> from(@NonNull AbstractTreeMap<? extends K, ? extends V> treeMap) {
        return new TreeMap<K, V>(treeMap);
    }

    public static <K, V> @NonNull Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> @NonNull Builder<K, V> builder(Comparator<? super K> comparator) {
        return new Builder(comparator);
    }

    protected TreeMap() {
    }

    public TreeMap(Comparator<? super K> comparator) {
        super(comparator);
    }

    public TreeMap(@NonNull Entry<? extends K, ? extends V> @NonNull [] entries) {
        super(entries);
    }

    public TreeMap(@NonNull Entry<? extends K, ? extends V> @NonNull [] entries, Comparator<? super K> comparator) {
        super(entries, comparator);
    }

    public TreeMap(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> map) {
        super(map);
    }

    public TreeMap(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> map, Comparator<? super K> comparator) {
        super(map, comparator);
    }

    public TreeMap(@NonNull AbstractTreeMap<? extends K, ? extends V> treeMap) {
        super(treeMap);
    }

    public TreeMap(@NonNull AbstractTreeMap<? extends K, ? extends V> treeMap, Comparator<? super K> comparator) {
        super(treeMap, comparator);
    }

    @Override
    public @NonNull ImmutableMap<K, V> withEntry(K key, V value) {
        TreeMap<K, V> copy = new TreeMap<K, V>(this, this.comparator);
        copy.putInternal(key, value);
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> union(@NonNull Map<? extends K, ? extends V> map) {
        TreeMap<K, V> copy = new TreeMap<K, V>(this, this.comparator);
        for (Entry<K, V> entry : map) {
            copy.putInternal(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> keyRemoved(Object key) {
        TreeMap copy = new TreeMap(this, this.comparator);
        boolean found = false;
        AbstractTreeMap.TreeEntry entry = this.getFirstEntry();
        while (entry != null) {
            Object entryKey = entry.getKey();
            if (!found && Objects.equals(key, entryKey)) {
                found = true;
            } else {
                copy.putInternal(entryKey, entry.getValue());
            }
            entry = TreeMap.successor(entry);
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> removed(Object key, Object value) {
        TreeMap copy = new TreeMap(this, this.comparator);
        boolean found = false;
        AbstractTreeMap.TreeEntry entry = this.getFirstEntry();
        while (entry != null) {
            block4: {
                Object entryValue;
                Object entryKey;
                block3: {
                    entryKey = entry.getKey();
                    entryValue = entry.getValue();
                    if (found || !Objects.equals(key, entryKey)) break block3;
                    found = true;
                    if (Objects.equals(value, entryValue)) break block4;
                }
                copy.putInternal(entryKey, entryValue);
            }
            entry = TreeMap.successor(entry);
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> valueRemoved(Object value) {
        TreeMap copy = new TreeMap(this, this.comparator);
        AbstractTreeMap.TreeEntry entry = this.getFirstEntry();
        while (entry != null) {
            Object entryValue = entry.getValue();
            if (!Objects.equals(value, entryValue)) {
                copy.putInternal(entry.getKey(), entryValue);
            }
            entry = TreeMap.successor(entry);
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> difference(@NonNull Map<?, ?> map) {
        TreeMap copy = new TreeMap(this, this.comparator);
        AbstractTreeMap.TreeEntry entry = this.getFirstEntry();
        while (entry != null) {
            Object entryValue;
            Object entryKey = entry.getKey();
            if (!map.contains(entryKey, entryValue = entry.getValue())) {
                copy.putInternal(entryKey, entryValue);
            }
            entry = TreeMap.successor(entry);
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> keyDifference(@NonNull Collection<?> keys) {
        TreeMap copy = new TreeMap(this, this.comparator);
        AbstractTreeMap.TreeEntry entry = this.getFirstEntry();
        while (entry != null) {
            Object entryKey = entry.getKey();
            if (!keys.contains(entryKey)) {
                copy.putInternal(entryKey, entry.getValue());
            }
            entry = TreeMap.successor(entry);
        }
        return copy;
    }

    @Override
    public <NK> @NonNull ImmutableMap<NK, V> keyMapped(@NonNull BiFunction<? super K, ? super V, ? extends NK> mapper) {
        TreeMap copy = new TreeMap();
        AbstractTreeMap.TreeEntry entry = this.getFirstEntry();
        while (entry != null) {
            Object value = entry.value;
            copy.putInternal(mapper.apply(entry.key, value), value);
            entry = TreeMap.successor(entry);
        }
        return copy;
    }

    @Override
    public <NV> @Nullable ImmutableMap<K, NV> valueMapped(@NonNull BiFunction<? super K, ? super V, ? extends NV> mapper) {
        TreeMap copy = new TreeMap();
        AbstractTreeMap.TreeEntry entry = this.getFirstEntry();
        while (entry != null) {
            Object key = entry.key;
            copy.putInternal(key, mapper.apply(key, entry.getValue()));
            entry = TreeMap.successor(entry);
        }
        return null;
    }

    @Override
    public <NK, NV> @NonNull ImmutableMap<NK, NV> entryMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Entry<? extends NK, ? extends NV>> mapper) {
        TreeMap<NK, NV> copy = new TreeMap<NK, NV>();
        AbstractTreeMap.TreeEntry entry = this.getFirstEntry();
        while (entry != null) {
            Entry<NK, NV> newEntry = mapper.apply(entry.key, entry.value);
            if (newEntry != null) {
                copy.putInternal(newEntry.getKey(), newEntry.getValue());
            }
            entry = TreeMap.successor(entry);
        }
        return copy;
    }

    @Override
    public <NK, NV> @NonNull ImmutableMap<NK, NV> flatMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Iterable<? extends @NonNull Entry<? extends NK, ? extends NV>>> mapper) {
        TreeMap<NK, NV> copy = new TreeMap<NK, NV>();
        AbstractTreeMap.TreeEntry entry = this.getFirstEntry();
        while (entry != null) {
            for (Entry<NK, NV> newEntry : mapper.apply(entry.key, entry.value)) {
                copy.putInternal(newEntry.getKey(), newEntry.getValue());
            }
            entry = TreeMap.successor(entry);
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> filtered(@NonNull BiPredicate<? super K, ? super V> predicate) {
        TreeMap copy = new TreeMap(this, this.comparator);
        AbstractTreeMap.TreeEntry entry = this.getFirstEntry();
        while (entry != null) {
            Object key = entry.key;
            Object value = entry.value;
            if (predicate.test(key, value)) {
                copy.putInternal(key, value);
            }
            entry = TreeMap.successor(entry);
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<V, K> inverted() {
        TreeMap copy = new TreeMap();
        AbstractTreeMap.TreeEntry entry = this.getFirstEntry();
        while (entry != null) {
            copy.putInternal(entry.value, entry.key);
            entry = TreeMap.successor(entry);
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> copy() {
        return this.immutableCopy();
    }

    @Override
    public @NonNull MutableMap<K, V> mutable() {
        return this.mutableCopy();
    }

    @Override
    public <RK, RV> @NonNull ImmutableMap.Builder<RK, RV> immutableBuilder() {
        return TreeMap.builder();
    }

    @Override
    public @NonNull java.util.Map<K, V> toJava() {
        return Collections.unmodifiableMap(super.toJava());
    }

    protected static final class Builder<K, V>
    implements ImmutableMap.Builder<K, V> {
        private TreeMap<K, V> map;

        public Builder() {
            this.map = new TreeMap();
        }

        public Builder(Comparator<? super K> comparator) {
            this.map = new TreeMap(comparator);
        }

        @Override
        public void put(K key, V value) {
            if (this.map == null) {
                throw new IllegalStateException("Already built!");
            }
            ((TreeMap)this.map).putInternal(key, value);
        }

        @Override
        public TreeMap<K, V> build() {
            TreeMap<K, V> map = this.map;
            this.map = null;
            return map;
        }
    }
}

