/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.immutable;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.NonNull;
import dyvil.collection.Collection;
import dyvil.collection.ImmutableSet;
import dyvil.collection.MutableSet;
import dyvil.collection.Set;
import dyvil.collection.immutable.ArraySet;
import dyvil.collection.iterator.SingletonIterator;
import dyvil.lang.LiteralConvertible;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

@Immutable
@LiteralConvertible.FromTuple
public class SingletonSet<E>
implements ImmutableSet<E> {
    private static final long serialVersionUID = 4398163898648791092L;
    private transient E element;

    public static <E> @NonNull SingletonSet<E> apply(E element) {
        return new SingletonSet<E>(element);
    }

    public SingletonSet(E element) {
        this.element = element;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public @NonNull Iterator<E> iterator() {
        return new SingletonIterator<E>(this.element);
    }

    @Override
    public void forEach(@NonNull Consumer<? super E> action) {
        action.accept(this.element);
    }

    @Override
    public boolean contains(Object element) {
        return Objects.equals(element, this.element);
    }

    @Override
    public @NonNull ImmutableSet<E> added(E element) {
        return ImmutableSet.apply(this.element, element);
    }

    @Override
    public ImmutableSet<E> removed(Object element) {
        if (Objects.equals(this.element, element)) {
            return ImmutableSet.apply();
        }
        return ImmutableSet.apply(this.element);
    }

    @Override
    public ImmutableSet<E> difference(@NonNull Collection<?> collection) {
        if (collection.contains(this.element)) {
            return ImmutableSet.apply();
        }
        return ImmutableSet.apply(this.element);
    }

    @Override
    public ImmutableSet<E> intersection(@NonNull Collection<? extends E> collection) {
        if (!collection.contains(this.element)) {
            return ImmutableSet.apply();
        }
        return this;
    }

    @Override
    public @NonNull ImmutableSet<E> union(@NonNull Collection<? extends E> collection) {
        if (!collection.contains(this)) {
            return ImmutableSet.from(collection);
        }
        Object[] array = new Object[1 + collection.size()];
        int index = 1;
        array[0] = this.element;
        block0: for (E element : collection) {
            for (int i = 1; i < index; ++i) {
                if (Objects.equals(array[i], element)) continue block0;
            }
            array[index++] = element;
        }
        return new ArraySet<Object>(array, index, true);
    }

    @Override
    public @NonNull ImmutableSet<E> symmetricDifference(@NonNull Collection<? extends E> collection) {
        if (!collection.contains(this.element)) {
            return ImmutableSet.from(collection);
        }
        Object[] array = new Object[1 + collection.size()];
        int index = 1;
        array[0] = this.element;
        block0: for (E element : collection) {
            for (int i = 1; i < index; ++i) {
                if (Objects.equals(array[i], element)) continue block0;
            }
            array[index++] = element;
        }
        return new ArraySet<Object>(array, index, true);
    }

    @Override
    public <R> @NonNull ImmutableSet<R> mapped(@NonNull Function<? super E, ? extends R> mapper) {
        return ImmutableSet.apply(mapper.apply(this.element));
    }

    @Override
    public <R> @NonNull ImmutableSet<R> flatMapped(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends R>> mapper) {
        return ImmutableSet.from(mapper.apply(this.element));
    }

    @Override
    public @NonNull ImmutableSet<E> filtered(@NonNull Predicate<? super E> predicate) {
        if (predicate.test(this.element)) {
            return ImmutableSet.apply(this.element);
        }
        return ImmutableSet.apply();
    }

    @Override
    public Object @NonNull [] toArray() {
        return new Object[]{this.element};
    }

    @Override
    public <R> R @NonNull [] toArray(@NonNull Class<R> type) {
        Object[] array = (Object[])Array.newInstance(type, 1);
        array[0] = type.cast(this.element);
        return array;
    }

    @Override
    public void toArray(int index, Object @NonNull [] store) {
        store[index] = this.element;
    }

    @Override
    public @NonNull ImmutableSet<E> copy() {
        return ImmutableSet.apply(this.element);
    }

    @Override
    public <RE> MutableSet<RE> emptyCopy() {
        return MutableSet.apply();
    }

    @Override
    public <RE> @NonNull MutableSet<RE> emptyCopy(int capacity) {
        return MutableSet.withCapacity(capacity);
    }

    @Override
    public @NonNull MutableSet<E> mutable() {
        return MutableSet.apply(new Object[]{this.element});
    }

    @Override
    public <RE> @NonNull ImmutableSet.Builder<RE> immutableBuilder() {
        return ImmutableSet.builder();
    }

    @Override
    public <RE> @NonNull ImmutableSet.Builder<RE> immutableBuilder(int capacity) {
        return ImmutableSet.builder(capacity);
    }

    @Override
    public @NonNull java.util.Set<E> toJava() {
        return Collections.singleton(this.element);
    }

    @Override
    public @NonNull String toString() {
        String elementToString = String.valueOf(this.element);
        return new StringBuilder(elementToString.length() + "[".length() + "]".length()).append("[").append(elementToString).append("]").toString();
    }

    @Override
    public boolean equals(Object obj) {
        return Set.setEquals((Set<? extends Object>)this, obj);
    }

    @Override
    public int hashCode() {
        return Set.setHashCode(this);
    }

    private void writeObject(@NonNull ObjectOutputStream out) throws IOException {
        out.writeObject(this.element);
    }

    private void readObject(@NonNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.element = in.readObject();
    }
}

