/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.immutable;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Collection;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.Map;
import dyvil.collection.MutableMap;
import dyvil.collection.immutable.ArrayMap;
import dyvil.collection.immutable.EmptyMap;
import dyvil.collection.iterator.SingletonIterator;
import dyvil.lang.LiteralConvertible;
import dyvil.tuple.Tuple;
import dyvil.util.Option;
import dyvil.util.Some;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;

@Immutable
@LiteralConvertible.FromColonOperator
public class SingletonMap<K, V>
implements ImmutableMap<K, V>,
Entry<K, V> {
    private static final long serialVersionUID = 2791619158507681686L;
    private transient K key;
    private transient V value;

    public static <K, V> @NonNull SingletonMap<K, V> apply(K key, V value) {
        return new SingletonMap<K, V>(key, value);
    }

    public static <K, V> @NonNull SingletonMap<K, V> apply(@NonNull Entry<K, V> entry) {
        return new SingletonMap<K, V>(entry.getKey(), entry.getValue());
    }

    public SingletonMap(K key, V value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public @NonNull Iterator<Entry<K, V>> iterator() {
        return new SingletonIterator<Entry<K, V>>(this);
    }

    @Override
    public @NonNull Iterator<K> keyIterator() {
        return new SingletonIterator<K>(this.key);
    }

    @Override
    public @NonNull Iterator<V> valueIterator() {
        return new SingletonIterator<V>(this.value);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public void forEach(@NonNull Consumer<? super Entry<K, V>> action) {
        action.accept(this);
    }

    @Override
    public void forEach(@NonNull BiConsumer<? super K, ? super V> action) {
        action.accept(this.key, this.value);
    }

    @Override
    public boolean containsKey(Object key) {
        return Objects.equals(this.key, key);
    }

    @Override
    public boolean contains(Object key, Object value) {
        return Objects.equals(this.key, key) && Objects.equals(this.value, value);
    }

    @Override
    public boolean containsValue(Object value) {
        return Objects.equals(this.value, value);
    }

    @Override
    public @Nullable V get(Object key) {
        return Objects.equals(key, this.key) ? (V)this.value : null;
    }

    @Override
    public @Nullable Entry<K, V> getEntry(Object key) {
        return Objects.equals(key, this.key) ? this : null;
    }

    @Override
    public @NonNull Option<V> getOption(Object key) {
        return Objects.equals(key, this.key) ? new Some<V>(this.value) : Option.apply();
    }

    @Override
    public @NonNull ImmutableMap<K, V> withEntry(K key, V value) {
        return ImmutableMap.singleton(key, value);
    }

    @Override
    public @NonNull ImmutableMap<K, V> union(@NonNull Map<? extends K, ? extends V> map) {
        ArrayMap.Builder<K, V> builder = new ArrayMap.Builder<K, V>(map.size() + 1);
        builder.put(this.key, this.value);
        builder.putAll(map);
        return builder.build();
    }

    @Override
    public @NonNull ImmutableMap<K, V> keyRemoved(Object key) {
        return Objects.equals(this.key, key) ? EmptyMap.instance : this;
    }

    @Override
    public @NonNull ImmutableMap<K, V> removed(Object key, Object value) {
        return Objects.equals(this.key, key) && Objects.equals(this.value, value) ? EmptyMap.instance : this;
    }

    @Override
    public @NonNull ImmutableMap<K, V> valueRemoved(Object value) {
        return Objects.equals(this.value, value) ? EmptyMap.instance : this;
    }

    @Override
    public @NonNull ImmutableMap<K, V> difference(@NonNull Map<?, ?> map) {
        return map.contains(this.key, this.value) ? EmptyMap.instance : this;
    }

    @Override
    public @NonNull ImmutableMap<K, V> keyDifference(@NonNull Collection<?> keys) {
        return keys.contains(this.key) ? EmptyMap.instance : this;
    }

    @Override
    public <NK> @NonNull ImmutableMap<NK, V> keyMapped(@NonNull BiFunction<? super K, ? super V, ? extends NK> mapper) {
        return new SingletonMap<NK, V>(mapper.apply(this.key, this.value), this.value);
    }

    @Override
    public <NV> @NonNull ImmutableMap<K, NV> valueMapped(@NonNull BiFunction<? super K, ? super V, ? extends NV> mapper) {
        return new SingletonMap<K, NV>(this.key, mapper.apply(this.key, this.value));
    }

    @Override
    public <NK, NV> @NonNull ImmutableMap<NK, NV> entryMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Entry<? extends NK, ? extends NV>> mapper) {
        Entry<NK, NV> entry = mapper.apply(this.key, this.value);
        return entry == null ? EmptyMap.instance : new SingletonMap<NK, NV>(entry.getKey(), entry.getValue());
    }

    @Override
    public <NK, NV> @Nullable ImmutableMap<NK, NV> flatMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Iterable<? extends @NonNull Entry<? extends NK, ? extends NV>>> mapper) {
        ArrayMap.Builder<NK, NV> builder = new ArrayMap.Builder<NK, NV>();
        for (Entry<NK, NV> entry : mapper.apply(this.key, this.value)) {
            builder.put(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    @Override
    public @NonNull ImmutableMap<K, V> filtered(@NonNull BiPredicate<? super K, ? super V> predicate) {
        return predicate.test(this.key, this.value) ? this : EmptyMap.instance;
    }

    @Override
    public Entry<K, V> @NonNull [] toArray() {
        return new Entry[]{this};
    }

    @Override
    public void toArray(int index, @NonNull Entry<K, V> @NonNull [] store) {
        store[index] = this;
    }

    @Override
    public Object @NonNull [] toKeyArray() {
        return new Object[]{this.key};
    }

    @Override
    public void toKeyArray(int index, Object @NonNull [] store) {
        store[index] = this.key;
    }

    @Override
    public Object @NonNull [] toValueArray() {
        return new Object[]{this.value};
    }

    @Override
    public void toValueArray(int index, Object @NonNull [] store) {
        store[index] = this.value;
    }

    @Override
    public @NonNull ImmutableMap<V, K> inverted() {
        return new SingletonMap<V, K>(this.value, this.key);
    }

    @Override
    public @NonNull ImmutableMap<K, V> copy() {
        return new SingletonMap<K, V>(this.key, this.value);
    }

    @Override
    public <RK, RV> MutableMap<RK, RV> emptyCopy() {
        return MutableMap.apply();
    }

    @Override
    public <RK, RV> MutableMap<RK, RV> emptyCopy(int capacity) {
        return MutableMap.withCapacity(capacity);
    }

    @Override
    public @NonNull MutableMap<K, V> mutable() {
        return MutableMap.apply(new Tuple.Of2<K, V>(this.key, this.value));
    }

    @Override
    public <RK, RV> ImmutableMap.Builder<RK, RV> immutableBuilder() {
        return ImmutableMap.builder();
    }

    @Override
    public <RK, RV> ImmutableMap.Builder<RK, RV> immutableBuilder(int capacity) {
        return ImmutableMap.builder(capacity);
    }

    @Override
    public @NonNull String toString() {
        return "[" + this.key + ": " + this.value + "]";
    }

    @Override
    public @NonNull java.util.Map<K, V> toJava() {
        return Collections.singletonMap(this.key, this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Map) {
            return Map.mapEquals((Map<? extends Object, ? extends Object>)this, (Map)obj);
        }
        return obj instanceof Entry && Entry.entryEquals((Entry<? extends Object, ? extends Object>)this, (Entry)obj);
    }

    @Override
    public int hashCode() {
        return Entry.entryHashCode(this);
    }

    private void writeObject(@NonNull ObjectOutputStream out) throws IOException {
        out.writeObject(this.key);
        out.writeObject(this.value);
    }

    private void readObject(@NonNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.key = in.readObject();
        this.value = in.readObject();
    }
}

