/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.immutable;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.NonNull;
import dyvil.collection.Collection;
import dyvil.collection.ImmutableList;
import dyvil.collection.List;
import dyvil.collection.MutableList;
import dyvil.collection.Set;
import dyvil.collection.immutable.AppendList;
import dyvil.collection.immutable.EmptyList;
import dyvil.collection.iterator.AppendIterator;
import dyvil.collection.iterator.PrependIterator;
import dyvil.collection.mutable.LinkedList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

@Immutable
public class PrependList<E>
implements ImmutableList<E> {
    private static final long serialVersionUID = -989114482136946209L;
    private transient E head;
    private transient ImmutableList<E> tail;
    private transient int size;

    public static <E> @NonNull PrependList<E> apply(E head) {
        return new PrependList<E>(head);
    }

    public PrependList(E element) {
        this.head = element;
        this.tail = EmptyList.instance;
        this.size = 1;
    }

    public PrependList(E head, @NonNull ImmutableList<E> tail) {
        this.head = head;
        this.tail = tail;
        this.size = 1 + tail.size();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public @NonNull Iterator<E> iterator() {
        return new PrependIterator<E>(this.head, this.tail.iterator());
    }

    @Override
    public @NonNull Iterator<E> reverseIterator() {
        return new AppendIterator<E>(this.tail.reverseIterator(), this.head);
    }

    @Override
    public E subscript(int index) {
        if (index == 0) {
            return this.head;
        }
        return this.tail.subscript(index - 1);
    }

    @Override
    public E get(int index) {
        if (index == 0) {
            return this.head;
        }
        return this.tail.get(index - 1);
    }

    @Override
    public @NonNull ImmutableList<E> subList(int startIndex, int length) {
        if (startIndex == 0) {
            return new PrependList<E>(this.head, this.tail.subList(startIndex - 1, length - 1));
        }
        return this.tail.subList(startIndex - 1, length - 1);
    }

    @Override
    public @NonNull ImmutableList<E> added(E element) {
        return new PrependList<E>(this.head, this.tail.added((Object)element));
    }

    @Override
    public @NonNull ImmutableList<E> union(@NonNull Collection<? extends E> collection) {
        return new PrependList<E>(this.head, this.tail.union((Collection)collection));
    }

    @Override
    public @NonNull ImmutableList<E> removed(Object element) {
        if (Objects.equals(element, this.head)) {
            return this.tail.removed(element);
        }
        return new PrependList<E>(this.head, this.tail.removed(element));
    }

    @Override
    public @NonNull ImmutableList<E> difference(@NonNull Collection<?> collection) {
        if (collection.contains(this.head)) {
            return this.tail.difference((Collection)collection);
        }
        return new PrependList<E>(this.head, this.tail.difference((Collection)collection));
    }

    @Override
    public @NonNull ImmutableList<E> intersection(@NonNull Collection<? extends E> collection) {
        if (!collection.contains(this.head)) {
            return this.tail.intersection((Collection)collection);
        }
        return new PrependList<E>(this.head, this.tail.intersection((Collection)collection));
    }

    @Override
    public <R> @NonNull ImmutableList<R> mapped(@NonNull Function<? super E, ? extends R> mapper) {
        return new PrependList<R>(mapper.apply(this.head), this.tail.mapped((Function)mapper));
    }

    @Override
    public <R> @NonNull ImmutableList<R> flatMapped(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends R>> mapper) {
        ImmutableList<Object> head = EmptyList.instance;
        for (Object element : mapper.apply(this.head)) {
            head = new AppendList<R>(head, element);
        }
        for (Object element : this.tail) {
            for (R result : mapper.apply(element)) {
                head = new AppendList<R>(head, result);
            }
        }
        return head;
    }

    @Override
    public @NonNull ImmutableList<E> filtered(@NonNull Predicate<? super E> predicate) {
        if (!predicate.test(this.head)) {
            return this.tail.filtered((Predicate)predicate);
        }
        return new PrependList<E>(this.head, this.tail.filtered((Predicate)predicate));
    }

    @Override
    public @NonNull ImmutableList<E> reversed() {
        return new AppendList<E>(this.tail.reversed(), this.head);
    }

    private static <E> @NonNull ImmutableList<E> fromArray(Object[] array, int length) {
        ImmutableList<Object> list = EmptyList.instance;
        for (int i = length - 1; i >= 0; --i) {
            list = new PrependList<Object>(array[i], list);
        }
        return list;
    }

    @Override
    public @NonNull ImmutableList<E> sorted() {
        Object[] array = this.toArray();
        Arrays.sort(array);
        return PrependList.fromArray(array, this.size);
    }

    @Override
    public @NonNull ImmutableList<E> sorted(@NonNull Comparator<? super E> comparator) {
        Object[] array = this.toArray();
        Arrays.sort(array, comparator);
        return PrependList.fromArray(array, this.size);
    }

    @Override
    public @NonNull ImmutableList<E> distinct() {
        Object[] array = this.toArray();
        int size = Set.distinct(array, this.size);
        return PrependList.fromArray(array, size);
    }

    @Override
    public @NonNull ImmutableList<E> distinct(@NonNull Comparator<? super E> comparator) {
        Object[] array = this.toArray();
        int size = Set.sortDistinct(array, this.size, comparator);
        return PrependList.fromArray(array, size);
    }

    @Override
    public int indexOf(Object element) {
        if (Objects.equals(element, this.head)) {
            return 0;
        }
        int i = this.tail.indexOf(element);
        return i >= 0 ? i + 1 : -1;
    }

    @Override
    public int lastIndexOf(Object element) {
        int i = this.tail.lastIndexOf(element);
        if (i >= 0) {
            return i + 1;
        }
        return Objects.equals(element, this.head) ? 0 : -1;
    }

    @Override
    public void toArray(int index, Object @NonNull [] store) {
        store[index] = this.head;
        this.tail.toArray(index + 1, store);
    }

    @Override
    public @NonNull ImmutableList<E> copy() {
        return new PrependList<E>(this.head, this.tail.copy());
    }

    @Override
    public <RE> @NonNull MutableList<RE> emptyCopy() {
        return MutableList.apply();
    }

    @Override
    public <RE> @NonNull MutableList<RE> emptyCopy(int capacity) {
        return MutableList.withCapacity(capacity);
    }

    @Override
    public @NonNull MutableList<E> mutable() {
        LinkedList<E> list = new LinkedList<E>();
        list.addFirst(this.head);
        list.addAll(this.tail);
        return list;
    }

    @Override
    public <RE> ImmutableList.Builder<RE> immutableBuilder() {
        return ImmutableList.builder();
    }

    @Override
    public <RE> ImmutableList.Builder<RE> immutableBuilder(int capacity) {
        return ImmutableList.builder(capacity);
    }

    @Override
    public @NonNull java.util.List<E> toJava() {
        java.util.LinkedList<E> list = new java.util.LinkedList<E>();
        list.addFirst(this.head);
        for (E element : this.tail) {
            list.addLast(element);
        }
        return list;
    }

    @Override
    public @NonNull String toString() {
        return Collection.collectionToString(this);
    }

    @Override
    public boolean equals(Object obj) {
        return List.listEquals(this, obj);
    }

    @Override
    public int hashCode() {
        return List.listHashCode(this);
    }

    private void writeObject(@NonNull ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.head);
        out.writeObject(this.tail);
    }

    private void readObject(@NonNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.head = in.readObject();
        this.tail = (ImmutableList)in.readObject();
        this.size = 1 + this.tail.size();
    }
}

