/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.immutable;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.NonNull;
import dyvil.collection.Collection;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.ImmutableSet;
import dyvil.collection.Map;
import dyvil.collection.MutableSet;
import dyvil.collection.impl.AbstractMapBasedSet;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

@Immutable
public class MapBasedSet<E>
extends AbstractMapBasedSet<E>
implements ImmutableSet<E> {
    private static final long serialVersionUID = 2820007412138106503L;
    protected @NonNull ImmutableMap<E, Boolean> map;

    public static <E> @NonNull ImmutableSet.Builder<E> builder(@NonNull ImmutableMap.Builder<E, Boolean> mapBuilder) {
        return new Builder<E>(mapBuilder);
    }

    public MapBasedSet(@NonNull ImmutableMap<E, Boolean> map) {
        this.map = map;
    }

    @Override
    protected @NonNull Map<E, Boolean> map() {
        return this.map;
    }

    @Override
    public @NonNull ImmutableSet<E> added(E element) {
        return new MapBasedSet<E>(this.map.withEntry(element, (Object)true));
    }

    @Override
    public @NonNull ImmutableSet<E> removed(Object element) {
        return new MapBasedSet<E>(this.map.keyRemoved(element));
    }

    @Override
    public @NonNull ImmutableSet<E> difference(@NonNull Collection<?> collection) {
        ImmutableMap.Builder builder = this.map.immutableBuilder();
        for (Entry<E, Boolean> entry : this.map) {
            E element = entry.getKey();
            if (collection.contains(element)) continue;
            builder.put(element, true);
        }
        return new MapBasedSet(builder.build());
    }

    @Override
    public @NonNull ImmutableSet<E> intersection(@NonNull Collection<? extends E> collection) {
        ImmutableMap.Builder builder = this.map.immutableBuilder();
        for (Entry<E, Boolean> entry : this.map) {
            E element = entry.getKey();
            if (!collection.contains(element)) continue;
            builder.put(element, true);
        }
        return new MapBasedSet(builder.build());
    }

    @Override
    public @NonNull ImmutableSet<E> union(@NonNull Collection<? extends E> collection) {
        ImmutableMap.Builder builder = this.map.immutableBuilder();
        builder.putAll(this.map);
        for (E element : collection) {
            builder.put(element, true);
        }
        return new MapBasedSet(builder.build());
    }

    @Override
    public @NonNull ImmutableSet<E> symmetricDifference(@NonNull Collection<? extends E> collection) {
        ImmutableMap.Builder builder = this.map.immutableBuilder();
        for (Entry<E, Boolean> entry : this.map) {
            E element = entry.getKey();
            if (collection.contains(element)) continue;
            builder.put(element, true);
        }
        for (Entry<Object, Boolean> entry : collection) {
            if (this.contains(entry)) continue;
            builder.put(entry, true);
        }
        return new MapBasedSet(builder.build());
    }

    @Override
    public <R> @NonNull ImmutableSet<R> mapped(@NonNull Function<? super E, ? extends R> mapper) {
        ImmutableMap.Builder builder = this.map.immutableBuilder();
        for (Entry<E, Boolean> entry : this.map) {
            builder.put(mapper.apply(entry.getKey()), true);
        }
        return new MapBasedSet(builder.build());
    }

    @Override
    public <R> @NonNull ImmutableSet<R> flatMapped(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends R>> mapper) {
        ImmutableMap.Builder builder = this.map.immutableBuilder();
        for (Entry<E, Boolean> entry : this.map) {
            for (R element : mapper.apply(entry.getKey())) {
                builder.put(element, true);
            }
        }
        return new MapBasedSet(builder.build());
    }

    @Override
    public @NonNull ImmutableSet<E> filtered(@NonNull Predicate<? super E> predicate) {
        ImmutableMap.Builder builder = this.map.immutableBuilder();
        for (Entry<E, Boolean> entry : this.map) {
            E element = entry.getKey();
            if (!predicate.test(element)) continue;
            builder.put(element, true);
        }
        return new MapBasedSet(builder.build());
    }

    @Override
    public @NonNull ImmutableSet<E> copy() {
        return new MapBasedSet<E>(this.map.copy());
    }

    @Override
    public @NonNull MutableSet<E> mutable() {
        return new dyvil.collection.mutable.MapBasedSet<E>(this.map.mutable());
    }

    @Override
    public @NonNull Set<E> toJava() {
        return Collections.unmodifiableSet(super.toJava());
    }

    public static class Builder<E>
    implements ImmutableSet.Builder<E> {
        private final ImmutableMap.Builder<E, Boolean> mapBuilder;

        public Builder(ImmutableMap.Builder<E, Boolean> mapBuilder) {
            this.mapBuilder = mapBuilder;
        }

        @Override
        public void add(E element) {
            this.mapBuilder.put(element, true);
        }

        @Override
        public ImmutableSet<E> build() {
            return new MapBasedSet<E>(this.mapBuilder.build());
        }
    }
}

