/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.immutable;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.NonNull;
import dyvil.collection.Collection;
import dyvil.collection.ImmutableSet;
import dyvil.collection.MutableSet;
import dyvil.collection.Set;
import dyvil.collection.SizedIterable;
import dyvil.collection.impl.AbstractIdentityHashSet;
import dyvil.lang.LiteralConvertible;
import java.util.function.Function;
import java.util.function.Predicate;

@Immutable
@LiteralConvertible.FromArray
public class IdentityHashSet<E>
extends AbstractIdentityHashSet<E>
implements ImmutableSet<E> {
    private static final long serialVersionUID = -1347044009183554635L;

    @SafeVarargs
    public static <E> @NonNull IdentityHashSet<E> apply(E ... elements) {
        return new IdentityHashSet<E>(elements);
    }

    public static <E> @NonNull IdentityHashSet<E> from(@NonNull Iterable<? extends E> iterable) {
        return new IdentityHashSet<E>(iterable);
    }

    public static <E> @NonNull IdentityHashSet<E> from(@NonNull SizedIterable<? extends E> iterable) {
        return new IdentityHashSet<E>(iterable);
    }

    public static <E> @NonNull IdentityHashSet<E> from(@NonNull Set<? extends E> iterable) {
        return new IdentityHashSet<E>(iterable);
    }

    public static <E> @NonNull IdentityHashSet<E> from(@NonNull AbstractIdentityHashSet<? extends E> iterable) {
        return new IdentityHashSet<E>(iterable);
    }

    public static <E> @NonNull Builder<E> builder() {
        return new Builder();
    }

    public static <E> @NonNull Builder<E> builder(int capacity) {
        return new Builder(capacity);
    }

    protected IdentityHashSet() {
        super(16);
    }

    protected IdentityHashSet(int capacity) {
        super(capacity);
    }

    public IdentityHashSet(E @NonNull [] elements) {
        super(elements);
    }

    public IdentityHashSet(@NonNull Iterable<? extends E> iterable) {
        super(iterable);
    }

    public IdentityHashSet(@NonNull SizedIterable<? extends E> iterable) {
        super(iterable);
    }

    public IdentityHashSet(@NonNull Set<? extends E> set) {
        super(set);
    }

    public IdentityHashSet(@NonNull AbstractIdentityHashSet<? extends E> set) {
        super(set);
    }

    @Override
    public @NonNull ImmutableSet<E> added(E element) {
        IdentityHashSet<E> copy = new IdentityHashSet<E>(this);
        copy.ensureCapacity(this.size + 1);
        copy.addInternal(element);
        return copy;
    }

    @Override
    public @NonNull ImmutableSet<E> removed(Object element) {
        IdentityHashSet copy = new IdentityHashSet(this.size);
        for (Object e : this) {
            if (element == e) continue;
            copy.addInternal(e);
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableSet<E> difference(@NonNull Collection<?> collection) {
        IdentityHashSet copy = new IdentityHashSet(this.size);
        for (Object e : this) {
            if (collection.contains(e)) continue;
            copy.addInternal(e);
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableSet<E> intersection(@NonNull Collection<? extends E> collection) {
        IdentityHashSet copy = new IdentityHashSet(this.size);
        for (Object e : this) {
            if (!collection.contains(e)) continue;
            copy.addInternal(e);
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableSet<E> union(@NonNull Collection<? extends E> collection) {
        IdentityHashSet copy = new IdentityHashSet(this.size + collection.size());
        for (Object e : this) {
            copy.addInternal(e);
        }
        for (Object e : collection) {
            copy.addInternal(e);
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableSet<E> symmetricDifference(@NonNull Collection<? extends E> collection) {
        IdentityHashSet copy = new IdentityHashSet(this.size + collection.size());
        for (Object e : this) {
            if (collection.contains(e)) continue;
            copy.addInternal(e);
        }
        for (Object e : collection) {
            if (this.contains(e)) continue;
            copy.addInternal(e);
        }
        return copy;
    }

    @Override
    public <R> @NonNull ImmutableSet<R> mapped(@NonNull Function<? super E, ? extends R> mapper) {
        IdentityHashSet<R> copy = new IdentityHashSet<R>(this.size);
        for (Object e : this) {
            copy.addInternal(mapper.apply(e));
        }
        return copy;
    }

    @Override
    public <R> @NonNull ImmutableSet<R> flatMapped(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends R>> mapper) {
        IdentityHashSet<R> copy = new IdentityHashSet<R>(this.size << 2);
        for (Object e : this) {
            for (R result : mapper.apply(e)) {
                copy.addInternal(result);
            }
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableSet<E> filtered(@NonNull Predicate<? super E> predicate) {
        IdentityHashSet set = new IdentityHashSet(this.size);
        for (Object e : this) {
            if (!predicate.test(e)) continue;
            set.addInternal(e);
        }
        return set;
    }

    @Override
    public @NonNull ImmutableSet<E> copy() {
        return this.immutableCopy();
    }

    @Override
    public @NonNull MutableSet<E> mutable() {
        return this.mutableCopy();
    }

    public static class Builder<E>
    implements ImmutableSet.Builder<E> {
        private IdentityHashSet<E> set;

        public Builder() {
            this.set = new IdentityHashSet(16);
        }

        public Builder(int capacity) {
            this.set = new IdentityHashSet(capacity);
        }

        @Override
        public void add(E element) {
            if (this.set == null) {
                throw new IllegalStateException("Already built!");
            }
            ((IdentityHashSet)this.set).addInternal(element);
        }

        @Override
        public ImmutableSet<E> build() {
            IdentityHashSet<E> set = this.set;
            this.set = null;
            return set;
        }
    }
}

