/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.immutable;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Collection;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.Map;
import dyvil.collection.MutableMap;
import dyvil.collection.Set;
import dyvil.collection.SizedIterable;
import dyvil.collection.impl.AbstractIdentityHashMap;
import dyvil.lang.LiteralConvertible;
import dyvil.tuple.Tuple;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

@Immutable
@LiteralConvertible.FromArray
public class IdentityHashMap<K, V>
extends AbstractIdentityHashMap<K, V>
implements ImmutableMap<K, V> {
    private static final long serialVersionUID = 7106880090218416170L;

    public static <K, V> @NonNull IdentityHashMap<K, V> singleton(K key, V value) {
        IdentityHashMap<K, V> result = new IdentityHashMap<K, V>(1);
        result.putInternal(key, value);
        return result;
    }

    @SafeVarargs
    public static <K, V> @NonNull IdentityHashMap<K, V> apply(Entry<? extends K, ? extends V> ... entries) {
        return new IdentityHashMap<K, V>(entries);
    }

    public static <K, V> @NonNull IdentityHashMap<K, V> from(@NonNull Entry<? extends K, ? extends V> @NonNull [] entries) {
        return new IdentityHashMap<K, V>(entries);
    }

    public static <K, V> @NonNull IdentityHashMap<K, V> from(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        return new IdentityHashMap<K, V>(iterable);
    }

    public static <K, V> @NonNull IdentityHashMap<K, V> from(SizedIterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        return new IdentityHashMap<K, V>(iterable);
    }

    public static <K, V> @NonNull IdentityHashMap<K, V> from(@NonNull Set<? extends @NonNull Entry<? extends K, ? extends V>> set) {
        return new IdentityHashMap<K, V>(set);
    }

    public static <K, V> @NonNull IdentityHashMap<K, V> from(@NonNull Map<? extends K, ? extends V> map) {
        return new IdentityHashMap<K, V>(map);
    }

    public static <K, V> @NonNull IdentityHashMap<K, V> from(@NonNull AbstractIdentityHashMap<? extends K, ? extends V> identityHashMap) {
        return new IdentityHashMap<K, V>(identityHashMap);
    }

    public static <K, V> @NonNull Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> @NonNull Builder<K, V> builder(int capacity) {
        return new Builder(capacity);
    }

    protected IdentityHashMap() {
    }

    protected IdentityHashMap(int capacity) {
        super(capacity);
    }

    public IdentityHashMap(@NonNull Entry<? extends K, ? extends V> @NonNull [] entries) {
        super(entries);
    }

    public IdentityHashMap(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        super(iterable);
    }

    public IdentityHashMap(SizedIterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        super(iterable);
    }

    public IdentityHashMap(@NonNull Set<? extends @NonNull Entry<? extends K, ? extends V>> set) {
        super(set);
    }

    public IdentityHashMap(@NonNull Map<? extends K, ? extends V> map) {
        super(map);
    }

    public IdentityHashMap(@NonNull AbstractIdentityHashMap<? extends K, ? extends V> identityHashMap) {
        super(identityHashMap);
    }

    @Override
    public @Nullable Entry<K, V> getEntry(Object key) {
        int index = this.getIndex(key);
        if (index < 0) {
            return null;
        }
        return new Tuple.Of2<Object, Object>(key, this.table[index + 1]);
    }

    @Override
    public @NonNull ImmutableMap<K, V> withEntry(K key, V value) {
        IdentityHashMap<K, V> map = new IdentityHashMap<K, V>(this);
        map.ensureCapacity(this.size + 1);
        map.putInternal(key, value);
        return map;
    }

    @Override
    public @NonNull ImmutableMap<K, V> union(@NonNull Map<? extends K, ? extends V> map) {
        IdentityHashMap<K, V> copy = new IdentityHashMap<K, V>(this);
        copy.putAllInternal(map);
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> keyRemoved(Object key) {
        IdentityHashMap copy = new IdentityHashMap(this.size);
        for (Entry entry : this) {
            Object entryKey = entry.getKey();
            if (entryKey == key) continue;
            copy.putInternal(entryKey, entry.getValue());
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> removed(Object key, Object value) {
        IdentityHashMap copy = new IdentityHashMap(this.size);
        for (Entry entry : this) {
            Object entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            if (entryKey == key || entryValue == value) continue;
            copy.putInternal(entryKey, entryValue);
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> valueRemoved(Object value) {
        IdentityHashMap copy = new IdentityHashMap(this.size);
        for (Entry entry : this) {
            Object v = entry.getValue();
            if (v == value) continue;
            copy.putInternal(entry.getKey(), v);
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> difference(@NonNull Map<?, ?> map) {
        IdentityHashMap copy = new IdentityHashMap(this.size);
        for (Entry entry : this) {
            Object entryValue;
            Object entryKey = entry.getKey();
            if (map.contains(entryKey, entryValue = entry.getValue())) continue;
            copy.putInternal(entryKey, entryValue);
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> keyDifference(@NonNull Collection<?> keys) {
        IdentityHashMap copy = new IdentityHashMap(this.size);
        for (Entry entry : this) {
            Object entryKey = entry.getKey();
            if (keys.contains(entryKey)) continue;
            copy.putInternal(entryKey, entry.getValue());
        }
        return copy;
    }

    @Override
    public <NK> @NonNull ImmutableMap<NK, V> keyMapped(@NonNull BiFunction<? super K, ? super V, ? extends NK> mapper) {
        IdentityHashMap copy = new IdentityHashMap(this.size);
        for (Entry entry : this) {
            Object value = entry.getValue();
            copy.putInternal(mapper.apply(entry.getKey(), value), value);
        }
        return copy;
    }

    @Override
    public <NV> @NonNull ImmutableMap<K, NV> valueMapped(@NonNull BiFunction<? super K, ? super V, ? extends NV> mapper) {
        IdentityHashMap copy = new IdentityHashMap(this.size);
        for (Entry entry : this) {
            Object key = entry.getKey();
            copy.putInternal(key, mapper.apply(key, entry.getValue()));
        }
        return copy;
    }

    @Override
    public <NK, NV> @NonNull ImmutableMap<NK, NV> entryMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Entry<? extends NK, ? extends NV>> mapper) {
        IdentityHashMap<NK, NV> copy = new IdentityHashMap<NK, NV>(this.size);
        for (Entry entry : this) {
            Entry<NK, NV> result = mapper.apply(entry.getKey(), entry.getValue());
            if (result == null) continue;
            copy.putInternal(result.getKey(), result.getValue());
        }
        return copy;
    }

    @Override
    public <NK, NV> @NonNull ImmutableMap<NK, NV> flatMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Iterable<? extends @NonNull Entry<? extends NK, ? extends NV>>> mapper) {
        IdentityHashMap<NK, NV> copy = new IdentityHashMap<NK, NV>(this.size);
        for (Entry entry : this) {
            for (Entry<NK, NV> result : mapper.apply(entry.getKey(), entry.getValue())) {
                copy.putInternal(result.getKey(), result.getValue());
            }
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> filtered(@NonNull BiPredicate<? super K, ? super V> predicate) {
        IdentityHashMap copy = new IdentityHashMap(this.size);
        for (Entry entry : this) {
            Object value;
            Object key = entry.getKey();
            if (!predicate.test(key, value = entry.getValue())) continue;
            copy.putInternal(key, value);
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<V, K> inverted() {
        IdentityHashMap copy = new IdentityHashMap(this.size);
        for (Entry entry : this) {
            copy.putInternal(entry.getValue(), entry.getKey());
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> copy() {
        return this.immutableCopy();
    }

    @Override
    public @NonNull MutableMap<K, V> mutable() {
        return this.mutableCopy();
    }

    public static class Builder<K, V>
    implements ImmutableMap.Builder<K, V> {
        private IdentityHashMap<K, V> map;

        public Builder() {
            this.map = new IdentityHashMap();
        }

        public Builder(int capacity) {
            this.map = new IdentityHashMap(capacity);
        }

        @Override
        public void put(K key, V value) {
            if (this.map == null) {
                throw new IllegalStateException("Already built!");
            }
            ((IdentityHashMap)this.map).putInternal(key, value);
        }

        @Override
        public IdentityHashMap<K, V> build() {
            IdentityHashMap<K, V> map = this.map;
            this.map = null;
            return map;
        }
    }
}

