/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.immutable;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Collection;
import dyvil.collection.ImmutableSet;
import dyvil.collection.MutableSet;
import dyvil.collection.Set;
import dyvil.collection.SizedIterable;
import dyvil.collection.impl.AbstractHashSet;
import dyvil.lang.LiteralConvertible;
import dyvil.util.ImmutableException;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Predicate;

@Immutable
@LiteralConvertible.FromArray
public class HashSet<E>
extends AbstractHashSet<E>
implements ImmutableSet<E> {
    private static final long serialVersionUID = -1698577535888129119L;

    @SafeVarargs
    public static <E> @NonNull HashSet<E> apply(E ... elements) {
        return new HashSet<E>(elements);
    }

    public static <E> @NonNull HashSet<E> from(E @NonNull [] array) {
        return new HashSet<E>(array);
    }

    public static <E> @NonNull HashSet<E> from(@NonNull Iterable<? extends E> iterable) {
        return new HashSet<E>(iterable);
    }

    public static <E> @NonNull HashSet<E> from(@NonNull SizedIterable<? extends E> iterable) {
        return new HashSet<E>(iterable);
    }

    public static <E> @NonNull HashSet<E> from(@NonNull Set<? extends E> set) {
        return new HashSet<E>(set);
    }

    public static <E> @NonNull HashSet<E> from(@NonNull AbstractHashSet<? extends E> hashSet) {
        return new HashSet<E>(hashSet);
    }

    public static <E> @NonNull Builder<E> builder() {
        return new Builder();
    }

    public static <E> @NonNull Builder<E> builder(int capacity) {
        return new Builder(capacity);
    }

    protected HashSet() {
    }

    protected HashSet(int capacity) {
        super(capacity);
    }

    public HashSet(E @NonNull [] elements) {
        super(elements);
    }

    public HashSet(@NonNull Iterable<? extends E> iterable) {
        super(iterable);
    }

    public HashSet(@NonNull SizedIterable<? extends E> iterable) {
        super(iterable);
    }

    public HashSet(@NonNull Set<? extends E> set) {
        super(set);
    }

    public HashSet(@NonNull AbstractHashSet<? extends E> hashSet) {
        super(hashSet);
    }

    @Override
    protected void addElement(int hash, E element, int index) {
        this.elements[index] = new AbstractHashSet.HashElement<E>(element, hash, this.elements[index]);
        ++this.size;
    }

    @Override
    protected void removeElement(@NonNull AbstractHashSet.HashElement<E> element) {
        throw new ImmutableException("Iterator.remove() on Immutable Set");
    }

    @Override
    public @NonNull ImmutableSet<E> added(E element) {
        HashSet<E> newSet = new HashSet<E>(this);
        newSet.ensureCapacityInternal(this.size + 1);
        newSet.addInternal(element);
        return newSet;
    }

    @Override
    public @NonNull ImmutableSet<E> removed(@Nullable Object element) {
        HashSet newSet = new HashSet(this.size);
        for (Object element1 : this) {
            if (element1 == element || element != null && element.equals(element1)) continue;
            newSet.addInternal(element1);
        }
        return newSet;
    }

    @Override
    public @NonNull ImmutableSet<E> difference(@NonNull Collection<?> collection) {
        HashSet newSet = new HashSet(this.size);
        for (Object element1 : this) {
            if (collection.contains(element1)) continue;
            newSet.addInternal(element1);
        }
        return newSet;
    }

    @Override
    public @NonNull ImmutableSet<E> intersection(@NonNull Collection<? extends E> collection) {
        HashSet newSet = new HashSet(this.size);
        for (Object element1 : this) {
            if (!collection.contains(element1)) continue;
            newSet.addInternal(element1);
        }
        return newSet;
    }

    @Override
    public @NonNull ImmutableSet<E> union(@NonNull Collection<? extends E> collection) {
        HashSet<E> newSet = new HashSet<E>(this);
        newSet.ensureCapacity(this.size + collection.size());
        for (E element : collection) {
            newSet.addInternal(element);
        }
        return newSet;
    }

    @Override
    public @NonNull ImmutableSet<E> symmetricDifference(@NonNull Collection<? extends E> collection) {
        HashSet newSet = new HashSet(this.size + collection.size());
        for (Object element : this) {
            if (collection.contains(element)) continue;
            newSet.addInternal(element);
        }
        for (Object element : collection) {
            if (this.contains(element)) continue;
            newSet.addInternal(element);
        }
        return newSet;
    }

    @Override
    public <R> @NonNull ImmutableSet<R> mapped(@NonNull Function<? super E, ? extends R> mapper) {
        HashSet<R> newSet = new HashSet<R>(this.size);
        for (Object element : this) {
            newSet.addInternal(mapper.apply(element));
        }
        return newSet;
    }

    @Override
    public <R> @NonNull ImmutableSet<R> flatMapped(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends R>> mapper) {
        HashSet<R> newSet = new HashSet<R>(this.size << 2);
        for (Object element : this) {
            for (R newElement : mapper.apply(element)) {
                newSet.addInternal(newElement);
            }
        }
        newSet.flatten();
        return newSet;
    }

    @Override
    public @NonNull ImmutableSet<E> filtered(@NonNull Predicate<? super E> predicate) {
        HashSet newSet = new HashSet(this.size);
        for (Object element : this) {
            if (!predicate.test(element)) continue;
            newSet.addInternal(element);
        }
        return newSet;
    }

    @Override
    public @NonNull ImmutableSet<E> copy() {
        return new HashSet<E>(this);
    }

    @Override
    public @NonNull MutableSet<E> mutable() {
        return new dyvil.collection.mutable.HashSet(this);
    }

    @Override
    public @NonNull java.util.Set<E> toJava() {
        return Collections.unmodifiableSet(super.toJava());
    }

    public static class Builder<E>
    implements ImmutableSet.Builder<E> {
        private HashSet<E> set;

        public Builder() {
            this.set = new HashSet();
        }

        public Builder(int capacity) {
            this.set = new HashSet(capacity);
        }

        @Override
        public void add(E element) {
            if (this.set == null) {
                throw new IllegalStateException("Already built!");
            }
            ((HashSet)this.set).addInternal(element);
        }

        @Override
        public ImmutableSet<E> build() {
            HashSet<E> set = this.set;
            this.set = null;
            return set;
        }
    }
}

