/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.immutable;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.NonNull;
import dyvil.collection.Collection;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.Map;
import dyvil.collection.MutableMap;
import dyvil.collection.Set;
import dyvil.collection.SizedIterable;
import dyvil.collection.impl.AbstractHashMap;
import dyvil.lang.LiteralConvertible;
import dyvil.ref.ObjectRef;
import dyvil.util.ImmutableException;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

@Immutable
@LiteralConvertible.FromArray
public class HashMap<K, V>
extends AbstractHashMap<K, V>
implements ImmutableMap<K, V> {
    private static final long serialVersionUID = -1489214367993445801L;

    public static <K, V> @NonNull HashMap<K, V> singleton(K key, V value) {
        HashMap<K, V> result = new HashMap<K, V>(1);
        result.putInternal(key, value);
        return result;
    }

    public static <K, V> @NonNull HashMap<K, V> apply() {
        return new HashMap<K, V>(0);
    }

    @SafeVarargs
    public static <K, V> @NonNull HashMap<K, V> apply(Entry<K, V> ... entries) {
        return new HashMap<K, V>(entries);
    }

    public static <K, V> @NonNull HashMap<K, V> from(@NonNull Entry<? extends K, ? extends V> @NonNull [] array) {
        return new HashMap<K, V>(array);
    }

    public static <K, V> @NonNull HashMap<K, V> from(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        return new HashMap<K, V>(iterable);
    }

    public static <K, V> @NonNull HashMap<K, V> from(@NonNull SizedIterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        return new HashMap<K, V>(iterable);
    }

    public static <K, V> @NonNull HashMap<K, V> from(@NonNull Set<? extends @NonNull Entry<? extends K, ? extends V>> set) {
        return new HashMap<K, V>(set);
    }

    public static <K, V> @NonNull HashMap<K, V> from(@NonNull Map<? extends K, ? extends V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K, V> @NonNull HashMap<K, V> from(@NonNull AbstractHashMap<? extends K, ? extends V> hashMap) {
        return new HashMap<K, V>(hashMap);
    }

    public static <K, V> @NonNull Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> @NonNull Builder<K, V> builder(int capacity) {
        return new Builder(capacity);
    }

    protected HashMap() {
    }

    protected HashMap(int capacity) {
        super(capacity);
    }

    public HashMap(@NonNull Entry<? extends K, ? extends V> @NonNull [] entries) {
        super(entries);
    }

    public HashMap(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        super(iterable);
    }

    public HashMap(@NonNull SizedIterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        super(iterable);
    }

    public HashMap(@NonNull Set<? extends @NonNull Entry<? extends K, ? extends V>> set) {
        super(set);
    }

    public HashMap(@NonNull Map<? extends K, ? extends V> map) {
        super(map);
    }

    public HashMap(@NonNull AbstractHashMap<? extends K, ? extends V> hashMap) {
        super(hashMap);
    }

    @Override
    public @NonNull ObjectRef<V> subscript_$amp(final K key) {
        return new ObjectRef<V>(){
            private final AbstractHashMap.HashEntry<K, V> entry;
            {
                this.entry = HashMap.this.getEntryInternal(key);
            }

            @Override
            public V get() {
                return this.entry.get();
            }

            @Override
            public void set(V value) {
                throw new ImmutableException("set() on Immutable Map Entry Reference");
            }
        };
    }

    @Override
    protected void addEntry(int hash, K key, V value, int index) {
        this.entries[index] = new AbstractHashMap.HashEntry<K, V>(key, value, hash, this.entries[index]);
        ++this.size;
    }

    @Override
    protected void removeEntry(@NonNull AbstractHashMap.HashEntry<K, V> entry) {
        throw new ImmutableException("Iterator.remove() on Immutable Map");
    }

    @Override
    public @NonNull ImmutableMap<K, V> withEntry(K key, V value) {
        HashMap<K, V> copy = new HashMap<K, V>(this);
        copy.ensureCapacity(this.size + 1);
        copy.putInternal(key, value);
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> union(@NonNull Map<? extends K, ? extends V> map) {
        HashMap<K, V> copy = new HashMap<K, V>(this);
        copy.putAllInternal(map);
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> keyRemoved(Object key) {
        HashMap copy = new HashMap(this.size);
        for (Entry entry : this) {
            Object entryKey = entry.getKey();
            if (Objects.equals(entryKey, key)) continue;
            copy.putInternal(entryKey, entry.getValue());
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> removed(Object key, Object value) {
        HashMap copy = new HashMap(this.size);
        for (Entry entry : this) {
            Object entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            if (Objects.equals(entryKey, key) && Objects.equals(entryValue, value)) continue;
            copy.putInternal(entryKey, entryValue);
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> valueRemoved(Object value) {
        HashMap copy = new HashMap(this.size);
        for (Entry entry : this) {
            Object entryValue = entry.getValue();
            if (Objects.equals(entryValue, value)) continue;
            copy.putInternal(entry.getKey(), entryValue);
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> difference(@NonNull Map<?, ?> map) {
        HashMap copy = new HashMap(this.size);
        for (Entry entry : this) {
            Object entryValue;
            Object entryKey = entry.getKey();
            if (map.contains(entryKey, entryValue = entry.getValue())) continue;
            copy.putInternal(entryKey, entryValue);
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> keyDifference(@NonNull Collection<?> keys) {
        HashMap copy = new HashMap(this.size);
        for (Entry entry : this) {
            Object entryKey = entry.getKey();
            if (keys.contains(entryKey)) continue;
            copy.putInternal(entryKey, entry.getValue());
        }
        return copy;
    }

    @Override
    public <NK> @NonNull ImmutableMap<NK, V> keyMapped(@NonNull BiFunction<? super K, ? super V, ? extends NK> mapper) {
        HashMap copy = new HashMap(this.size);
        for (Entry entry : this) {
            Object value = entry.getValue();
            copy.putInternal(mapper.apply(entry.getKey(), value), value);
        }
        return copy;
    }

    @Override
    public <NV> @NonNull ImmutableMap<K, NV> valueMapped(@NonNull BiFunction<? super K, ? super V, ? extends NV> mapper) {
        HashMap copy = new HashMap(this.size);
        for (Entry entry : this) {
            Object key = entry.getKey();
            copy.putInternal(key, mapper.apply(key, entry.getValue()));
        }
        return copy;
    }

    @Override
    public <NK, NV> @NonNull ImmutableMap<NK, NV> entryMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Entry<? extends NK, ? extends NV>> mapper) {
        HashMap<NK, NV> copy = new HashMap<NK, NV>(this.size);
        for (Entry entry : this) {
            Entry<NK, NV> newEntry = mapper.apply(entry.getKey(), entry.getValue());
            if (newEntry == null) continue;
            copy.putInternal(newEntry.getKey(), newEntry.getValue());
        }
        return copy;
    }

    @Override
    public <NK, NV> @NonNull ImmutableMap<NK, NV> flatMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Iterable<? extends @NonNull Entry<? extends NK, ? extends NV>>> mapper) {
        HashMap<NK, NV> copy = new HashMap<NK, NV>(this.size);
        for (Entry entry : this) {
            for (Entry<NK, NV> newEntry : mapper.apply(entry.getKey(), entry.getValue())) {
                copy.putInternal(newEntry.getKey(), newEntry.getValue());
            }
        }
        copy.flatten();
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> filtered(@NonNull BiPredicate<? super K, ? super V> predicate) {
        HashMap copy = new HashMap(this.size);
        for (Entry entry : this) {
            Object value;
            Object key = entry.getKey();
            if (!predicate.test(key, value = entry.getValue())) continue;
            copy.putInternal(key, value);
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<V, K> inverted() {
        HashMap copy = new HashMap(this.size);
        for (Entry entry : this) {
            copy.putInternal(entry.getValue(), entry.getKey());
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> copy() {
        return this.immutableCopy();
    }

    @Override
    public @NonNull MutableMap<K, V> mutable() {
        return this.mutableCopy();
    }

    @Override
    public <RK, RV> @NonNull ImmutableMap.Builder<RK, RV> immutableBuilder() {
        return HashMap.builder();
    }

    @Override
    public <RK, RV> @NonNull ImmutableMap.Builder<RK, RV> immutableBuilder(int capacity) {
        return HashMap.builder(capacity);
    }

    @Override
    public @NonNull java.util.Map<K, V> toJava() {
        return Collections.unmodifiableMap(super.toJava());
    }

    public static class Builder<K, V>
    implements ImmutableMap.Builder<K, V> {
        private HashMap<K, V> map;

        public Builder() {
            this.map = new HashMap();
        }

        public Builder(int capacity) {
            this.map = new HashMap(capacity);
        }

        @Override
        public void put(K key, V value) {
            if (this.map == null) {
                throw new IllegalStateException("Already built!");
            }
            ((HashMap)this.map).putInternal(key, value);
        }

        @Override
        public HashMap<K, V> build() {
            HashMap<K, V> map = this.map;
            this.map = null;
            ((HashMap)map).flatten();
            return map;
        }
    }
}

