/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.immutable;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.NonNull;
import dyvil.collection.ImmutableList;
import dyvil.collection.ImmutableMatrix;
import dyvil.collection.MutableMatrix;
import dyvil.collection.immutable.ArrayList;
import dyvil.collection.impl.AbstractFlatArrayMatrix;
import java.util.function.Function;

@Immutable
public class FlatArrayMatrix<E>
extends AbstractFlatArrayMatrix<E>
implements ImmutableMatrix<E> {
    private static final long serialVersionUID = 7265281981107132533L;

    public FlatArrayMatrix() {
    }

    public FlatArrayMatrix(int rows, int columns, E @NonNull [] cells) {
        super(rows, columns, cells);
    }

    public FlatArrayMatrix(int rows, int columns, Object[] cells, boolean trusted) {
        super(rows, columns, cells, trusted);
    }

    public FlatArrayMatrix(int rows, int columns, Object[][] cells) {
        super(rows, columns, cells);
    }

    public FlatArrayMatrix(int rows, int columns) {
        super(rows, columns);
    }

    public FlatArrayMatrix(Object[] ... cells) {
        super(cells);
    }

    @Override
    public @NonNull ImmutableMatrix<E> subMatrix(int row, int rows, int column, int columns) {
        this.rangeCheck(row, column);
        this.rangeCheck(row + rows - 1, column + columns - 1);
        Object[] newCells = new Object[rows * columns];
        for (int i = 0; i < rows; ++i) {
            System.arraycopy(this.cells, this.index(row + i, column), newCells, columns * i, columns);
        }
        return new FlatArrayMatrix<E>(rows, columns, newCells, true);
    }

    @Override
    public @NonNull ImmutableList<E> row(int row) {
        this.rowRangeCheck(row);
        Object[] array = new Object[this.columns];
        System.arraycopy(this.cells, row * this.columns, array, 0, this.columns);
        return new ArrayList<Object>(array, this.columns, true);
    }

    @Override
    public @NonNull ImmutableList<E> column(int column) {
        this.columnRangeCheck(column);
        Object[] array = new Object[this.rows];
        for (int i = 0; i < this.columns; ++i) {
            array[i] = this.cells[column + i * this.rows];
        }
        return new ArrayList<Object>(array, this.rows, true);
    }

    @Override
    public @NonNull ImmutableList<E> flatten() {
        int len = this.rows * this.columns;
        Object[] array = new Object[len];
        System.arraycopy(this.cells, 0, array, 0, len);
        return new ArrayList<Object>(array, len, true);
    }

    @Override
    public @NonNull ImmutableMatrix<E> transposed() {
        int len = this.rows * this.columns;
        Object[] newArray = new Object[len];
        for (int i = 0; i < this.rows; ++i) {
            int i1 = i * this.columns;
            for (int j = 0; j < this.columns; ++j) {
                newArray[i + j * this.rows] = this.cells[j + i1];
            }
        }
        return new FlatArrayMatrix<E>(this.columns, this.rows, newArray, true);
    }

    @Override
    public <R> @NonNull ImmutableMatrix<R> mapped(@NonNull Function<? super E, ? extends R> mapper) {
        int len = this.rows * this.columns;
        Object[] array = new Object[len];
        for (int i = 0; i < len; ++i) {
            array[i] = mapper.apply(this.cells[i]);
        }
        return new FlatArrayMatrix<E>(this.rows, this.columns, array, true);
    }

    @Override
    public @NonNull ImmutableMatrix<E> copy() {
        return new FlatArrayMatrix<Object>(this.rows, this.columns, this.cells);
    }

    @Override
    public @NonNull MutableMatrix<E> mutable() {
        return new dyvil.collection.mutable.FlatArrayMatrix<Object>(this.rows, this.columns, this.cells);
    }
}

