/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.immutable;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.NonNull;
import dyvil.collection.Collection;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.Map;
import dyvil.collection.MutableMap;
import dyvil.collection.immutable.ArrayMap;
import dyvil.collection.impl.AbstractEnumMap;
import dyvil.lang.LiteralConvertible;
import dyvil.reflect.EnumReflection;
import dyvil.reflect.types.Type;
import dyvil.util.ImmutableException;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

@Immutable
@LiteralConvertible.FromArray
public class EnumMap<K extends Enum<K>, V>
extends AbstractEnumMap<K, V>
implements ImmutableMap<K, V> {
    private static final long serialVersionUID = -2305035920228304893L;

    public static <K extends Enum<K>, V> @NonNull EnumMap<K, V> singleton(@NonNull K key, V value) {
        EnumMap<K, V> result = new EnumMap<K, V>(EnumMap.getKeyType(key));
        result.putInternal(key, value);
        return result;
    }

    @SafeVarargs
    public static <K extends Enum<K>, V> @NonNull EnumMap<K, V> apply(Entry<K, V> ... entries) {
        return new EnumMap<K, V>(entries);
    }

    public static <K extends Enum<K>, V> @NonNull EnumMap<K, V> from(@NonNull Entry<? extends K, ? extends V> @NonNull [] entries) {
        return new EnumMap<K, V>(entries);
    }

    public static <K extends Enum<K>, V> @NonNull EnumMap<K, V> from(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> map) {
        return new EnumMap<K, V>(map);
    }

    public static <K extends Enum<K>, V> @NonNull EnumMap<K, V> from(@NonNull AbstractEnumMap<? extends K, ? extends V> map) {
        return new EnumMap<K, V>(map);
    }

    public static <K extends Enum<K>, V> @NonNull Builder<K, V> builder(@NonNull Type<K> type) {
        return new Builder(type.erasure());
    }

    public static <K extends Enum<K>, V> @NonNull Builder<K, V> builder(@NonNull Class<K> type) {
        return new Builder(type);
    }

    @DyvilModifiers(value=0x100000L)
    private EnumMap(@NonNull Class<K> type, K @NonNull [] keys, V @NonNull [] values, int size) {
        super(type, keys, (Object[])values, size);
    }

    public EnumMap(@NonNull Class<K> type) {
        super(type);
    }

    public EnumMap(@NonNull Type<K> type) {
        super(type.erasure());
    }

    public EnumMap(@NonNull Entry<? extends K, ? extends V> @NonNull [] entries) {
        super(entries);
    }

    public EnumMap(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> map) {
        super(map);
    }

    public EnumMap(@NonNull AbstractEnumMap<? extends K, ? extends V> map) {
        super(map);
    }

    @Override
    protected void removeAt(int index) {
        throw new ImmutableException("Iterator.remove() on Immutable Map");
    }

    @Override
    public @NonNull ImmutableMap<K, V> withEntry(@NonNull K key, V value) {
        if (!EnumMap.checkType(this.type, key)) {
            return this;
        }
        int index = EnumMap.index(key);
        Object[] newValues = (Object[])this.values.clone();
        int newSize = this.size;
        if (newValues[index] == null) {
            ++newSize;
        }
        newValues[index] = value;
        return new EnumMap(this.type, this.keys, newValues, newSize);
    }

    @Override
    public @NonNull ImmutableMap<K, V> union(@NonNull Map<? extends K, ? extends V> map) {
        Object[] newValues = (Object[])this.values.clone();
        int newSize = this.size;
        for (Entry<K, V> entry : map) {
            Enum key = (Enum)entry.getKey();
            V value = entry.getValue();
            int index = EnumMap.index(key);
            if (newValues[index] == null) {
                ++newSize;
            }
            newValues[index] = value;
        }
        return new EnumMap(this.type, this.keys, newValues, newSize);
    }

    @Override
    public @NonNull ImmutableMap<K, V> keyRemoved(@NonNull Object key) {
        if (!EnumMap.checkType(this.type, key)) {
            return this;
        }
        int index = EnumMap.index(key);
        if (this.values[index] == null) {
            return this;
        }
        Object[] newValues = (Object[])this.values.clone();
        newValues[index] = null;
        return new EnumMap(this.type, this.keys, newValues, this.size - 1);
    }

    @Override
    public @NonNull ImmutableMap<K, V> removed(@NonNull Object key, Object value) {
        if (!EnumMap.checkType(this.type, key)) {
            return this;
        }
        int index = EnumMap.index(key);
        if (!Objects.equals(this.values[index], value)) {
            return this;
        }
        Object[] newValues = (Object[])this.values.clone();
        newValues[index] = null;
        return new EnumMap(this.type, this.keys, newValues, this.size - 1);
    }

    @Override
    public @NonNull ImmutableMap<K, V> valueRemoved(Object value) {
        Object[] newValues = (Object[])this.values.clone();
        int newSize = this.size;
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (!Objects.equals(value, this.values[i])) continue;
            newValues[i] = null;
            --newSize;
        }
        return new EnumMap(this.type, this.keys, newValues, newSize);
    }

    @Override
    public @NonNull ImmutableMap<K, V> difference(@NonNull Map<?, ?> map) {
        Object[] newValues = (Object[])this.values.clone();
        int newSize = this.size;
        for (Entry<?, ?> entry : map) {
            Object key = entry.getKey();
            int index = EnumMap.index(key);
            Object value = newValues[index];
            if (value == null || !Objects.equals(value, entry.getValue())) continue;
            --newSize;
            newValues[index] = null;
        }
        return new EnumMap(this.type, this.keys, newValues, newSize);
    }

    @Override
    public @NonNull ImmutableMap<K, V> keyDifference(@NonNull Collection<?> keys) {
        Object[] newValues = (Object[])this.values.clone();
        int newSize = this.size;
        for (Object key : keys) {
            int index = EnumMap.index(key);
            Object value = newValues[index];
            if (value == null) continue;
            --newSize;
            newValues[index] = null;
        }
        return new EnumMap(this.type, this.keys, newValues, newSize);
    }

    @Override
    public <NK> ImmutableMap<NK, V> keyMapped(@NonNull BiFunction<? super K, ? super V, ? extends NK> mapper) {
        int len = this.values.length;
        ArrayMap.Builder<NK, Object> builder = new ArrayMap.Builder<NK, Object>(this.size);
        for (int i = 0; i < len; ++i) {
            Object value = this.values[i];
            if (value == null) continue;
            builder.put(mapper.apply(this.keys[i], value), value);
        }
        return builder.build();
    }

    @Override
    public <NV> @NonNull ImmutableMap<K, NV> valueMapped(@NonNull BiFunction<? super K, ? super V, ? extends NV> mapper) {
        int len = this.values.length;
        Object[] newValues = new Object[len];
        for (int i = 0; i < len; ++i) {
            Object value = this.values[i];
            if (value == null) continue;
            newValues[i] = mapper.apply(this.keys[i], value);
        }
        return new EnumMap(this.type, this.keys, newValues, this.size);
    }

    @Override
    public <NK, NV> ImmutableMap<NK, NV> entryMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Entry<? extends NK, ? extends NV>> mapper) {
        ArrayMap.Builder<? extends NK, ? extends NV> builder = new ArrayMap.Builder<NK, NV>(this.size);
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            Entry<? extends NK, ? extends NV> entry;
            Object value = this.values[i];
            if (value == null || (entry = mapper.apply(this.keys[i], value)) == null) continue;
            builder.put(entry);
        }
        return builder.build();
    }

    @Override
    public <NK, NV> ImmutableMap<NK, NV> flatMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Iterable<? extends @NonNull Entry<? extends NK, ? extends NV>>> mapper) {
        ArrayMap.Builder<NK, NV> builder = new ArrayMap.Builder<NK, NV>(this.size);
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            Object value = this.values[i];
            if (value == null) continue;
            for (Entry<NK, NV> entry : mapper.apply(this.keys[i], value)) {
                builder.put(entry);
            }
        }
        return builder.build();
    }

    @Override
    public @NonNull ImmutableMap<K, V> filtered(@NonNull BiPredicate<? super K, ? super V> predicate) {
        Object[] newValues = (Object[])this.values.clone();
        int newSize = this.size;
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            Object value = this.values[i];
            if (value == null || predicate.test(this.keys[i], value)) continue;
            newValues[i] = null;
            --newSize;
        }
        return new EnumMap(this.type, this.keys, newValues, newSize);
    }

    @Override
    public @NonNull ImmutableMap<V, K> inverted() {
        ArrayMap.Builder<Object, Enum> builder = new ArrayMap.Builder<Object, Enum>(this.size);
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            builder.put(this.values[i], this.keys[i]);
        }
        return builder.build();
    }

    @Override
    public @NonNull ImmutableMap<K, V> copy() {
        return this.immutableCopy();
    }

    @Override
    public @NonNull MutableMap<K, V> mutable() {
        return this.mutableCopy();
    }

    @Override
    public @NonNull java.util.Map<K, V> toJava() {
        return Collections.unmodifiableMap(super.toJava());
    }

    public static class Builder<K extends Enum<K>, V>
    implements ImmutableMap.Builder<K, V> {
        private Class<K> type;
        private Object[] values;
        private int size;

        public Builder(Class<K> type) {
            this.type = type;
            this.values = new Object[EnumReflection.getEnumCount(type)];
        }

        @Override
        public void put(@NonNull K key, V value) {
            if (this.size < 0) {
                throw new IllegalStateException("Already built");
            }
            if (!EnumMap.checkType(this.type, key)) {
                return;
            }
            int index = EnumMap.index(key);
            if (this.values[index] == null) {
                ++this.size;
            }
            this.values[index] = value;
        }

        @Override
        public EnumMap<K, V> build() {
            EnumMap map = new EnumMap(this.type, EnumReflection.getEnumConstants(this.type), this.values, this.size);
            this.size = -1;
            return map;
        }
    }
}

