/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.immutable;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.NonNull;
import dyvil.array.ObjectArray;
import dyvil.collection.Collection;
import dyvil.collection.ImmutableSet;
import dyvil.collection.MutableSet;
import dyvil.collection.Set;
import dyvil.collection.immutable.SingletonSet;
import dyvil.collection.iterator.EmptyIterator;
import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

@DyvilModifiers(value=65552L)
@Immutable
public final class EmptySet<E>
implements ImmutableSet<E> {
    private static final long serialVersionUID = -6445525479912514756L;
    public static final EmptySet instance = new EmptySet();

    public static <E> @NonNull EmptySet<E> apply() {
        return instance;
    }

    private EmptySet() {
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public @NonNull Iterator<E> iterator() {
        return EmptyIterator.instance;
    }

    @Override
    public @NonNull Spliterator<E> spliterator() {
        return Spliterators.emptySpliterator();
    }

    @Override
    public void forEach(@NonNull Consumer<? super E> action) {
    }

    @Override
    public boolean contains(Object element) {
        return false;
    }

    @Override
    public @NonNull ImmutableSet<E> added(E element) {
        return new SingletonSet<E>(element);
    }

    @Override
    public @NonNull ImmutableSet<E> removed(Object element) {
        return this;
    }

    @Override
    public @NonNull ImmutableSet<E> difference(@NonNull Collection<?> collection) {
        return this;
    }

    @Override
    public @NonNull ImmutableSet<E> intersection(@NonNull Collection<? extends E> collection) {
        return this;
    }

    @Override
    public @NonNull ImmutableSet<E> union(@NonNull Collection<? extends E> collection) {
        return ImmutableSet.from(collection);
    }

    @Override
    public @NonNull ImmutableSet<E> symmetricDifference(@NonNull Collection<? extends E> collection) {
        return ImmutableSet.from(collection);
    }

    @Override
    public <R> @NonNull ImmutableSet<R> mapped(@NonNull Function<? super E, ? extends R> mapper) {
        return this;
    }

    @Override
    public <R> @NonNull ImmutableSet<R> flatMapped(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends R>> mapper) {
        return this;
    }

    @Override
    public @NonNull ImmutableSet<E> filtered(@NonNull Predicate<? super E> predicate) {
        return this;
    }

    @Override
    public Object @NonNull [] toArray() {
        return ObjectArray.EMPTY;
    }

    @Override
    public <R> R @NonNull [] toArray(@NonNull Class<R> type) {
        return ObjectArray.ofType(0, type);
    }

    @Override
    public void toArray(int index, Object @NonNull [] store) {
    }

    @Override
    public @NonNull ImmutableSet<E> copy() {
        return this;
    }

    @Override
    public <RE> MutableSet<RE> emptyCopy() {
        return MutableSet.apply();
    }

    @Override
    public <RE> @NonNull MutableSet<RE> emptyCopy(int capacity) {
        return MutableSet.withCapacity(capacity);
    }

    @Override
    public @NonNull MutableSet<E> mutable() {
        return MutableSet.apply();
    }

    @Override
    public <RE> @NonNull ImmutableSet.Builder<RE> immutableBuilder() {
        return ImmutableSet.builder();
    }

    @Override
    public <RE> @NonNull ImmutableSet.Builder<RE> immutableBuilder(int capacity) {
        return ImmutableSet.builder(capacity);
    }

    @Override
    public @NonNull java.util.Set<E> toJava() {
        return Collections.EMPTY_SET;
    }

    @Override
    public @NonNull String toString() {
        return "[]";
    }

    @Override
    public boolean equals(Object obj) {
        return Set.setEquals((Set<? extends Object>)this, obj);
    }

    @Override
    public int hashCode() {
        return Set.setHashCode(this);
    }

    private @NonNull Object writeReplace() throws ObjectStreamException {
        return instance;
    }

    private @NonNull Object readResolve() throws ObjectStreamException {
        return instance;
    }
}

