/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.immutable;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.array.ObjectArray;
import dyvil.collection.Collection;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.Map;
import dyvil.collection.MutableMap;
import dyvil.collection.immutable.SingletonMap;
import dyvil.collection.iterator.EmptyIterator;
import dyvil.util.Option;
import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;

@DyvilModifiers(value=65552L)
@Immutable
public final class EmptyMap<K, V>
implements ImmutableMap<K, V> {
    private static final long serialVersionUID = 4719096668028950933L;
    public static final EmptyMap instance = new EmptyMap();

    public static <K, V> @NonNull EmptyMap<K, V> apply() {
        return instance;
    }

    private EmptyMap() {
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public @NonNull Iterator<Entry<K, V>> iterator() {
        return EmptyIterator.apply();
    }

    @Override
    public @NonNull Iterator<K> keyIterator() {
        return EmptyIterator.apply();
    }

    @Override
    public @NonNull Iterator<V> valueIterator() {
        return EmptyIterator.apply();
    }

    @Override
    public void forEach(@NonNull Consumer<? super Entry<K, V>> action) {
    }

    @Override
    public void forEach(@NonNull BiConsumer<? super K, ? super V> action) {
    }

    @Override
    public boolean containsKey(Object key) {
        return false;
    }

    @Override
    public boolean contains(Object key, Object value) {
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public @Nullable V get(Object key) {
        return null;
    }

    @Override
    public @Nullable Entry<K, V> getEntry(Object key) {
        return null;
    }

    @Override
    public @NonNull Option<V> getOption(Object key) {
        return Option.apply();
    }

    @Override
    public @NonNull ImmutableMap<K, V> withEntry(K key, V value) {
        return SingletonMap.apply(key, value);
    }

    @Override
    public @NonNull ImmutableMap<K, V> union(@NonNull Map<? extends K, ? extends V> map) {
        return map.immutable();
    }

    @Override
    public @NonNull ImmutableMap<K, V> keyRemoved(Object key) {
        return this;
    }

    @Override
    public @NonNull ImmutableMap<K, V> removed(Object key, Object value) {
        return this;
    }

    @Override
    public @NonNull ImmutableMap<K, V> valueRemoved(Object value) {
        return this;
    }

    @Override
    public @NonNull ImmutableMap<K, V> difference(@NonNull Map<?, ?> map) {
        return this;
    }

    @Override
    public @NonNull ImmutableMap<K, V> keyDifference(@NonNull Collection<?> keys) {
        return this;
    }

    @Override
    public <NK> @NonNull ImmutableMap<NK, V> keyMapped(@NonNull BiFunction<? super K, ? super V, ? extends NK> mapper) {
        return this;
    }

    @Override
    public <NV> @NonNull ImmutableMap<K, NV> valueMapped(@NonNull BiFunction<? super K, ? super V, ? extends NV> mapper) {
        return this;
    }

    @Override
    public <NK, NV> @NonNull ImmutableMap<NK, NV> entryMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Entry<? extends NK, ? extends NV>> mapper) {
        return this;
    }

    @Override
    public <NK, NV> @NonNull ImmutableMap<NK, NV> flatMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Iterable<? extends @NonNull Entry<? extends NK, ? extends NV>>> mapper) {
        return this;
    }

    @Override
    public @NonNull ImmutableMap<K, V> filtered(@NonNull BiPredicate<? super K, ? super V> predicate) {
        return this;
    }

    @Override
    public @NonNull ImmutableMap<V, K> inverted() {
        return this;
    }

    @Override
    public Entry<K, V> @NonNull [] toArray() {
        return new Entry[0];
    }

    @Override
    public void toArray(int index, @NonNull Entry<K, V> @NonNull [] store) {
    }

    @Override
    public Object @NonNull [] toKeyArray() {
        return ObjectArray.EMPTY;
    }

    @Override
    public void toKeyArray(int index, Object @NonNull [] store) {
    }

    @Override
    public Object @NonNull [] toValueArray() {
        return ObjectArray.EMPTY;
    }

    @Override
    public void toValueArray(int index, Object @NonNull [] store) {
    }

    @Override
    public @NonNull ImmutableMap<K, V> copy() {
        return this;
    }

    @Override
    public <RK, RV> MutableMap<RK, RV> emptyCopy() {
        return MutableMap.apply();
    }

    @Override
    public <RK, RV> MutableMap<RK, RV> emptyCopy(int capacity) {
        return MutableMap.withCapacity(capacity);
    }

    @Override
    public @NonNull MutableMap<K, V> mutable() {
        return MutableMap.apply();
    }

    @Override
    public <RK, RV> ImmutableMap.Builder<RK, RV> immutableBuilder() {
        return ImmutableMap.builder();
    }

    @Override
    public <RK, RV> ImmutableMap.Builder<RK, RV> immutableBuilder(int capacity) {
        return ImmutableMap.builder(capacity);
    }

    @Override
    public java.util.Map<K, V> toJava() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public @NonNull String toString() {
        return "[]";
    }

    @Override
    public boolean equals(Object obj) {
        return Map.mapEquals((Map<? extends Object, ? extends Object>)this, obj);
    }

    @Override
    public int hashCode() {
        return Map.mapHashCode(this);
    }

    private @NonNull Object writeReplace() throws ObjectStreamException {
        return instance;
    }

    private @NonNull Object readResolve() throws ObjectStreamException {
        return instance;
    }
}

