/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.immutable;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.array.ObjectArray;
import dyvil.collection.Collection;
import dyvil.collection.ImmutableList;
import dyvil.collection.List;
import dyvil.collection.MutableList;
import dyvil.collection.immutable.AppendList;
import dyvil.collection.immutable.SingletonList;
import dyvil.collection.iterator.EmptyIterator;
import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

@DyvilModifiers(value=65552L)
@Immutable
public final class EmptyList<E>
implements ImmutableList<E> {
    private static final long serialVersionUID = -6059901529322971155L;
    public static final EmptyList instance = new EmptyList();

    public static <E> @NonNull EmptyList<E> apply() {
        return instance;
    }

    private EmptyList() {
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public @NonNull Iterator<E> iterator() {
        return EmptyIterator.instance;
    }

    @Override
    public @NonNull Iterator<E> reverseIterator() {
        return EmptyIterator.instance;
    }

    @Override
    public @NonNull Spliterator<E> spliterator() {
        return Spliterators.emptySpliterator();
    }

    @Override
    public void forEach(@NonNull Consumer<? super E> action) {
    }

    @Override
    public <R> R foldLeft(R initialValue, @NonNull BiFunction<? super R, ? super E, ? extends R> reducer) {
        return initialValue;
    }

    @Override
    public <R> R foldRight(R initialValue, @NonNull BiFunction<? super E, ? super R, ? extends R> reducer) {
        return initialValue;
    }

    @Override
    public @Nullable E reduceLeft(@NonNull BiFunction<? super E, ? super E, ? extends E> reducer) {
        return null;
    }

    @Override
    public @Nullable E reduceRight(@NonNull BiFunction<? super E, ? super E, ? extends E> reducer) {
        return null;
    }

    @Override
    public boolean contains(Object element) {
        return false;
    }

    @Override
    public @NonNull E subscript(int index) {
        throw new IndexOutOfBoundsException("Empty List.apply()");
    }

    @Override
    public E get(int index) {
        return null;
    }

    @Override
    public @NonNull ImmutableList<E> subList(int startIndex, int length) {
        if (startIndex > 0 || length > 0) {
            throw new IndexOutOfBoundsException("Empty List Slice out of range");
        }
        return this;
    }

    @Override
    public int indexOf(Object element) {
        return -1;
    }

    @Override
    public int lastIndexOf(Object element) {
        return -1;
    }

    @Override
    public @NonNull ImmutableList<E> added(E element) {
        return new SingletonList<E>(element);
    }

    @Override
    public @NonNull ImmutableList<E> union(@NonNull Collection<? extends E> collection) {
        return ImmutableList.from(collection);
    }

    @Override
    public @NonNull ImmutableList<E> removed(Object element) {
        return this;
    }

    @Override
    public @NonNull ImmutableList<E> difference(@NonNull Collection<?> collection) {
        return this;
    }

    @Override
    public @NonNull ImmutableList<E> intersection(@NonNull Collection<? extends E> collection) {
        return this;
    }

    @Override
    public <R> @NonNull ImmutableList<R> mapped(@NonNull Function<? super E, ? extends R> mapper) {
        return this;
    }

    @Override
    public <R> @NonNull ImmutableList<R> flatMapped(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends R>> mapper) {
        return this;
    }

    @Override
    public @NonNull ImmutableList<E> filtered(@NonNull Predicate<? super E> predicate) {
        return this;
    }

    @Override
    public @NonNull ImmutableList<E> reversed() {
        return this;
    }

    @Override
    public @NonNull ImmutableList<E> sorted() {
        return this;
    }

    @Override
    public @NonNull ImmutableList<E> sorted(@NonNull Comparator<? super E> comparator) {
        return this;
    }

    @Override
    public @NonNull ImmutableList<E> distinct() {
        return this;
    }

    @Override
    public @NonNull ImmutableList<E> distinct(@NonNull Comparator<? super E> comparator) {
        return this;
    }

    @Override
    public Object @NonNull [] toArray() {
        return ObjectArray.EMPTY;
    }

    @Override
    public <R> R @NonNull [] toArray(@NonNull Class<R> type) {
        return ObjectArray.ofType(0, type);
    }

    @Override
    public void toArray(int index, Object @NonNull [] store) {
    }

    @Override
    public @NonNull ImmutableList<E> copy() {
        return this;
    }

    @Override
    public <RE> @NonNull MutableList<RE> emptyCopy() {
        return MutableList.apply();
    }

    @Override
    public <RE> @NonNull MutableList<RE> emptyCopy(int capacity) {
        return MutableList.withCapacity(capacity);
    }

    @Override
    public @NonNull MutableList<E> mutable() {
        return MutableList.apply();
    }

    @Override
    public <RE> ImmutableList.Builder<RE> immutableBuilder() {
        return AppendList.builder();
    }

    @Override
    public <RE> ImmutableList.Builder<RE> immutableBuilder(int capacity) {
        return ImmutableList.builder(capacity);
    }

    @Override
    public @NonNull java.util.List<E> toJava() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public @NonNull String toString() {
        return "[]";
    }

    @Override
    public boolean equals(Object obj) {
        return List.listEquals(this, obj);
    }

    @Override
    public int hashCode() {
        return List.listHashCode(this);
    }

    private @NonNull Object writeReplace() throws ObjectStreamException {
        return instance;
    }

    private @NonNull Object readResolve() throws ObjectStreamException {
        return instance;
    }
}

