/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.immutable;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.collection.Collection;
import dyvil.collection.ImmutableCollection;
import dyvil.collection.ImmutableSet;
import dyvil.collection.MutableSet;
import dyvil.collection.SizedIterable;
import dyvil.collection.impl.AbstractBitSet;
import dyvil.lang.LiteralConvertible;
import dyvil.util.ImmutableException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

@Immutable
@LiteralConvertible.FromArray
public class BitSet
extends AbstractBitSet
implements ImmutableSet<Integer> {
    protected BitSet() {
    }

    protected BitSet(int capacity) {
        super(capacity);
    }

    public BitSet(int @NonNull [] elements) {
        super(elements);
    }

    public BitSet(@NonNull Iterable<? extends Integer> iterable) {
        super(iterable);
    }

    public BitSet(@NonNull SizedIterable<? extends Integer> iterable) {
        super(iterable);
    }

    public BitSet(@NonNull AbstractBitSet bitSet) {
        super(bitSet);
    }

    public static @NonNull BitSet apply() {
        return new BitSet();
    }

    public static @NonNull BitSet apply(int ... elements) {
        return new BitSet(elements);
    }

    public static @NonNull BitSet from(int @NonNull [] array) {
        return new BitSet(array);
    }

    public static @NonNull BitSet from(@NonNull Iterable<? extends Integer> iterable) {
        return new BitSet(iterable);
    }

    public static @NonNull BitSet from(@NonNull SizedIterable<? extends Integer> iterable) {
        return new BitSet(iterable);
    }

    public static @NonNull BitSet from(@NonNull AbstractBitSet bitSet) {
        return new BitSet(bitSet);
    }

    @Override
    protected void removeAt(int bit) {
        throw new ImmutableException("Iterator.remove() on Immutable Set");
    }

    /*
     * WARNING - void declaration
     */
    public @NonNull BitSet added(int element) {
        void var2_2;
        if (this.bitSet(element)) {
            return this;
        }
        BitSet copy = new BitSet(this);
        copy.setBit(element);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public @NonNull BitSet removed(@Primitive Object element) {
        void var3_3;
        if (!(element instanceof Integer)) {
            return this;
        }
        int bit = (Integer)element;
        if (!this.bitSet(bit)) {
            return this;
        }
        BitSet copy = new BitSet(this);
        copy.clearBit(bit);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public @NonNull BitSet union(@NonNull Collection<? extends Integer> collection) {
        void var2_2;
        if (collection.isEmpty()) {
            return this;
        }
        BitSet copy = new BitSet(this);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            int element = (Integer)iterator.next();
            copy.setBit(element);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public @NonNull BitSet difference(@NonNull Collection<? extends @Primitive Object> collection) {
        void var2_2;
        if (collection.isEmpty() || this.isEmpty()) {
            return this;
        }
        BitSet copy = new BitSet(this);
        for (Object t : collection) {
            if (!(t instanceof Integer)) continue;
            copy.clearBit((Integer)t);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public @NonNull BitSet intersection(@NonNull Collection<? extends Integer> collection) {
        void var2_2;
        if (collection.isEmpty() || this.isEmpty()) {
            return this;
        }
        BitSet copy = new BitSet(this.size);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            int element = (Integer)iterator.next();
            if (!this.bitSet(element)) continue;
            copy.setBit(element);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public @NonNull BitSet symmetricDifference(@NonNull Collection<? extends Integer> collection) {
        void var2_2;
        int element;
        if (collection.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return new BitSet((SizedIterable<? extends Integer>)collection);
        }
        BitSet copy = new BitSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            element = (Integer)iterator.next();
            if (this.bitSet(element)) continue;
            copy.setBit(element);
        }
        iterator = this.iterator();
        while (iterator.hasNext()) {
            element = (Integer)iterator.next();
            if (collection.contains(element)) continue;
            copy.setBit(element);
        }
        return var2_2;
    }

    @Override
    public <R> @NonNull ImmutableSet<R> mapped(@NonNull Function<? super Integer, ? extends R> mapper) {
        ImmutableSet.Builder<R> builder = ImmutableSet.builder();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            int element = (Integer)iterator.next();
            builder.add(mapper.apply(element));
        }
        ImmutableCollection immutableCollection = builder.build();
        immutableCollection.getClass();
        immutableCollection.getClass();
        return immutableCollection;
    }

    @Override
    public <R> @NonNull ImmutableSet<R> flatMapped(@NonNull Function<? super Integer, ? extends @NonNull Iterable<? extends R>> mapper) {
        ImmutableSet.Builder<R> builder = ImmutableSet.builder();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            int element = (Integer)iterator.next();
            for (R result : mapper.apply(element)) {
                builder.add(result);
            }
        }
        ImmutableCollection immutableCollection = builder.build();
        immutableCollection.getClass();
        immutableCollection.getClass();
        return immutableCollection;
    }

    /*
     * WARNING - void declaration
     */
    public @NonNull BitSet filtered(@NonNull Predicate<? super Integer> predicate) {
        void var2_2;
        BitSet copy = new BitSet(this.size);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            int element = (Integer)iterator.next();
            if (!predicate.test((Integer)element)) continue;
            copy.setBit(element);
        }
        return var2_2;
    }

    @Override
    public @NonNull ImmutableSet<@Primitive Integer> copy() {
        return this.immutableCopy();
    }

    @Override
    public @NonNull MutableSet<@Primitive Integer> mutable() {
        return this.mutableCopy();
    }

    @Override
    public @NonNull Set<@Primitive Integer> toJava() {
        Set<Integer> set = Collections.unmodifiableSet(super.toJava());
        set.getClass();
        return set;
    }
}

