/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.immutable;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.NonNull;
import dyvil.collection.Collection;
import dyvil.collection.ImmutableSet;
import dyvil.collection.MutableSet;
import dyvil.collection.Set;
import dyvil.collection.impl.AbstractArraySet;
import dyvil.lang.LiteralConvertible;
import dyvil.util.ImmutableException;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

@Immutable
@LiteralConvertible.FromArray
public class ArraySet<E>
extends AbstractArraySet<E>
implements ImmutableSet<E> {
    private static final long serialVersionUID = 5534347282324757054L;

    @SafeVarargs
    public static <E> @NonNull ArraySet<E> apply(E ... elements) {
        return new ArraySet<E>(elements, true);
    }

    public static <E> @NonNull ArraySet<E> from(E[] array) {
        return new ArraySet<E>(array);
    }

    public static <E> @NonNull ArraySet<E> from(@NonNull Iterable<? extends E> iterable) {
        return new ArraySet<E>(iterable);
    }

    public static <E> @NonNull ArraySet<E> from(@NonNull Collection<? extends E> collection) {
        return new ArraySet<E>(collection);
    }

    public static <E> @NonNull ArraySet<E> from(@NonNull Set<? extends E> set) {
        return new ArraySet<E>(set);
    }

    public static <E> @NonNull ArraySet<E> from(@NonNull AbstractArraySet<E> arraySet) {
        return new ArraySet<E>(arraySet);
    }

    public static <E> @NonNull Builder<E> builder() {
        return new Builder();
    }

    public static <E> @NonNull Builder<E> builder(int capacity) {
        return new Builder(capacity);
    }

    protected ArraySet() {
    }

    protected ArraySet(int capacity) {
        super(capacity);
    }

    public ArraySet(E[] elements) {
        super(elements);
    }

    public ArraySet(E @NonNull [] elements, int size) {
        super(elements, size);
    }

    public ArraySet(E @NonNull [] elements, boolean trusted) {
        super(elements, trusted);
    }

    public ArraySet(E[] elements, int size, boolean trusted) {
        super(elements, size, trusted);
    }

    public ArraySet(@NonNull Iterable<? extends E> iterable) {
        super(iterable);
    }

    public ArraySet(@NonNull Collection<? extends E> collection) {
        super(collection);
    }

    public ArraySet(@NonNull Set<? extends E> set) {
        super(set);
    }

    public ArraySet(@NonNull AbstractArraySet<E> arraySet) {
        super(arraySet);
    }

    @Override
    protected void removeAt(int index) {
        throw new ImmutableException("removeAt() on Immutable Set");
    }

    @Override
    public @NonNull ImmutableSet<E> added(E element) {
        if (this.contains(element)) {
            return this;
        }
        Object[] newArray = new Object[this.size + 1];
        System.arraycopy(this.elements, 0, newArray, 0, this.size);
        newArray[this.size] = element;
        return new ArraySet<Object>(newArray, this.size + 1, true);
    }

    @Override
    public @NonNull ImmutableSet<E> removed(Object element) {
        Object[] newArray = new Object[this.size];
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            Object thisElement = this.elements[i];
            if (Objects.equals(thisElement, element)) continue;
            newArray[index++] = thisElement;
        }
        return new ArraySet<Object>(newArray, index, true);
    }

    @Override
    public @NonNull ImmutableSet<E> difference(@NonNull Collection<?> collection) {
        Object[] newArray = new Object[this.size];
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            Object element = this.elements[i];
            if (collection.contains(element)) continue;
            newArray[index++] = element;
        }
        return new ArraySet<Object>(newArray, index, true);
    }

    @Override
    public @NonNull ImmutableSet<E> intersection(@NonNull Collection<? extends E> collection) {
        Object[] newArray = new Object[Math.min(this.size, collection.size())];
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            Object element = this.elements[i];
            if (!collection.contains(element)) continue;
            newArray[index++] = element;
        }
        return new ArraySet<Object>(newArray, index, true);
    }

    @Override
    public @NonNull ImmutableSet<E> union(@NonNull Collection<? extends E> collection) {
        int size = this.size;
        Object[] newArray = new Object[size + collection.size()];
        System.arraycopy(this.elements, 0, newArray, 0, this.size);
        for (E element : collection) {
            if (this.contains(element)) continue;
            newArray[size++] = element;
        }
        return new ArraySet<Object>(newArray, size, true);
    }

    @Override
    public @NonNull ImmutableSet<E> symmetricDifference(@NonNull Collection<? extends E> collection) {
        Object[] newArray = new Object[this.size + collection.size()];
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            Object element = this.elements[i];
            if (collection.contains(element)) continue;
            newArray[index++] = element;
        }
        for (Object element : collection) {
            if (this.contains(element)) continue;
            newArray[index++] = element;
        }
        return new ArraySet<Object>(newArray, index, true);
    }

    @Override
    public <R> @NonNull ImmutableSet<R> mapped(@NonNull Function<? super E, ? extends R> mapper) {
        ArraySet copy = (ArraySet)this.copy();
        copy.mapImpl(mapper);
        return copy;
    }

    @Override
    public <R> @NonNull ImmutableSet<R> flatMapped(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends R>> mapper) {
        ArraySet copy = (ArraySet)this.copy();
        copy.flatMapImpl(mapper);
        return copy;
    }

    @Override
    public @NonNull ImmutableSet<E> filtered(@NonNull Predicate<? super E> predicate) {
        Object[] newArray = new Object[this.size];
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            Object element = this.elements[i];
            if (!predicate.test(element)) continue;
            newArray[index++] = element;
        }
        return new ArraySet<Object>(newArray, index, true);
    }

    @Override
    public @NonNull ImmutableSet<E> copy() {
        return this.immutableCopy();
    }

    @Override
    public @NonNull MutableSet<E> mutable() {
        return this.mutableCopy();
    }

    @Override
    public @NonNull java.util.Set<E> toJava() {
        return Collections.unmodifiableSet(super.toJava());
    }

    public static class Builder<E>
    implements ImmutableSet.Builder<E> {
        private ArraySet<E> result;

        public Builder() {
            this.result = new ArraySet();
        }

        public Builder(int capacity) {
            this.result = new ArraySet(capacity);
        }

        @Override
        public void add(E element) {
            if (this.result == null) {
                throw new IllegalStateException("Already built");
            }
            ((ArraySet)this.result).addInternal(element);
        }

        @Override
        public ArraySet<E> build() {
            ArraySet<E> result = this.result;
            this.result = null;
            return result;
        }
    }
}

