/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.immutable;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Collection;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.Map;
import dyvil.collection.MutableMap;
import dyvil.collection.Set;
import dyvil.collection.SizedIterable;
import dyvil.collection.impl.AbstractArrayMap;
import dyvil.lang.LiteralConvertible;
import dyvil.tuple.Tuple;
import dyvil.util.ImmutableException;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

@Immutable
@LiteralConvertible.FromArray
public class ArrayMap<K, V>
extends AbstractArrayMap<K, V>
implements ImmutableMap<K, V> {
    private static final long serialVersionUID = 4583062458335627011L;

    public static <K, V> @NonNull ArrayMap<K, V> singleton(K key, V value) {
        ArrayMap<K, V> result = new ArrayMap<K, V>(1);
        result.putInternal(key, value);
        return result;
    }

    public static <K, V> @NonNull ArrayMap<K, V> apply() {
        return new ArrayMap<K, V>(0);
    }

    @SafeVarargs
    public static <K, V> @NonNull ArrayMap<K, V> apply(Entry<? extends K, ? extends V> ... entries) {
        return new ArrayMap<K, V>(entries);
    }

    public static <K, V> @NonNull ArrayMap<K, V> from(@NonNull Entry<? extends K, ? extends V> @NonNull [] array) {
        return new ArrayMap<K, V>(array);
    }

    public static <K, V> @NonNull ArrayMap<K, V> from(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        return new ArrayMap<K, V>(iterable);
    }

    public static <K, V> @NonNull ArrayMap<K, V> from(@NonNull SizedIterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        return new ArrayMap<K, V>(iterable);
    }

    public static <K, V> @NonNull ArrayMap<K, V> from(@NonNull Set<? extends @NonNull Entry<? extends K, ? extends V>> set) {
        return new ArrayMap<K, V>(set);
    }

    public static <K, V> @NonNull ArrayMap<K, V> from(@NonNull Map<? extends K, ? extends V> map) {
        return new ArrayMap<K, V>(map);
    }

    public static <K, V> @NonNull ArrayMap<K, V> from(@NonNull AbstractArrayMap<? extends K, ? extends V> arrayMap) {
        return new ArrayMap<K, V>(arrayMap);
    }

    public static <K, V> @NonNull Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> @NonNull Builder<K, V> builder(int capacity) {
        return new Builder(capacity);
    }

    protected ArrayMap() {
    }

    protected ArrayMap(int capacity) {
        super(capacity);
    }

    public ArrayMap(K @NonNull [] keys, V @NonNull [] values) {
        super(keys, values);
    }

    public ArrayMap(K @NonNull [] keys, V @NonNull [] values, int size) {
        super(keys, values, size);
    }

    public ArrayMap(K @NonNull [] keys, V @NonNull [] values, boolean trusted) {
        super(keys, values, trusted);
    }

    public ArrayMap(K @NonNull [] keys, V @NonNull [] values, int size, boolean trusted) {
        super(keys, values, size, trusted);
    }

    public ArrayMap(@NonNull Entry<? extends K, ? extends V> @NonNull [] entries) {
        super(entries);
    }

    public ArrayMap(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        super(iterable);
    }

    public ArrayMap(@NonNull SizedIterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        super(iterable);
    }

    public ArrayMap(@NonNull Set<? extends @NonNull Entry<? extends K, ? extends V>> set) {
        super(set);
    }

    public ArrayMap(@NonNull Map<? extends K, ? extends V> map) {
        super(map);
    }

    public ArrayMap(@NonNull AbstractArrayMap<? extends K, ? extends V> arrayMap) {
        super(arrayMap);
    }

    @Override
    protected void removeAt(int index) {
        throw new ImmutableException("Iterator.remove() on Immutable Map");
    }

    @Override
    public @Nullable Entry<K, V> getEntry(Object key) {
        int index = this.getIndex(key);
        if (index < 0) {
            return null;
        }
        return new Tuple.Of2<Object, Object>(key, this.values[index]);
    }

    @Override
    public @NonNull ImmutableMap<K, V> withEntry(K key, V value) {
        ArrayMap<K, V> copy = new ArrayMap<K, V>(this);
        copy.putInternal(key, value);
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> union(@NonNull Map<? extends K, ? extends V> map) {
        ArrayMap<K, V> copy = new ArrayMap<K, V>(this.size + map.size());
        System.arraycopy(this.keys, 0, copy.keys, 0, this.size);
        System.arraycopy(this.values, 0, copy.values, 0, this.size);
        for (Entry<K, V> entry : map) {
            copy.putInternal(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> keyRemoved(Object key) {
        Object[] keys = new Object[this.size];
        Object[] values = new Object[this.size];
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            Object k = this.keys[i];
            if (Objects.equals(key, k)) continue;
            keys[index] = k;
            values[index++] = this.values[i];
        }
        return new ArrayMap<Object, Object>(keys, values, index, true);
    }

    @Override
    public @NonNull ImmutableMap<K, V> removed(Object key, Object value) {
        Object[] keys = new Object[this.size];
        Object[] values = new Object[this.size];
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            Object v;
            Object k = this.keys[i];
            if (Objects.equals(key, k) || Objects.equals(value, v = this.values[i])) continue;
            keys[index] = k;
            values[index++] = v;
        }
        return new ArrayMap<Object, Object>(keys, values, index, true);
    }

    @Override
    public @NonNull ImmutableMap<K, V> valueRemoved(Object value) {
        Object[] keys = new Object[this.size];
        Object[] values = new Object[this.size];
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            Object v = this.values[i];
            if (Objects.equals(value, v)) continue;
            keys[index] = this.keys[i];
            values[index++] = v;
        }
        return new ArrayMap<Object, Object>(keys, values, index, true);
    }

    @Override
    public @NonNull ImmutableMap<K, V> difference(@NonNull Map<?, ?> map) {
        Object[] keys = new Object[this.size];
        Object[] values = new Object[this.size];
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            Object k = this.keys[i];
            Object v = this.values[i];
            if (map.contains(k, v)) continue;
            keys[index] = k;
            values[index++] = v;
        }
        return new ArrayMap<Object, Object>(keys, values, index, true);
    }

    @Override
    public @NonNull ImmutableMap<K, V> keyDifference(@NonNull Collection<?> collection) {
        Object[] keys = new Object[this.size];
        Object[] values = new Object[this.size];
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            Object k = this.keys[i];
            if (collection.contains(k)) continue;
            keys[index] = k;
            values[index++] = this.values[i];
        }
        return new ArrayMap<Object, Object>(keys, values, index, true);
    }

    @Override
    public <NK> @NonNull ImmutableMap<NK, V> keyMapped(@NonNull BiFunction<? super K, ? super V, ? extends NK> mapper) {
        ArrayMap<NK, Object> copy = new ArrayMap<NK, Object>(this.size);
        for (int i = 0; i < this.size; ++i) {
            Object value = this.values[i];
            copy.putInternal(mapper.apply(this.keys[i], value), value);
        }
        return copy;
    }

    @Override
    public <NV> @NonNull ImmutableMap<K, NV> valueMapped(@NonNull BiFunction<? super K, ? super V, ? extends NV> mapper) {
        Object[] keys = new Object[this.size];
        Object[] values = new Object[this.size];
        System.arraycopy(this.keys, 0, keys, 0, this.size);
        for (int i = 0; i < this.size; ++i) {
            values[i] = mapper.apply(this.keys[i], this.values[i]);
        }
        return new ArrayMap<Object, Object>(keys, values, this.size, true);
    }

    @Override
    public <NK, NV> @NonNull ImmutableMap<NK, NV> entryMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Entry<? extends NK, ? extends NV>> mapper) {
        ArrayMap<NK, NV> copy = new ArrayMap<NK, NV>(this.size);
        for (int i = 0; i < this.size; ++i) {
            Entry<NK, NV> entry = mapper.apply(this.keys[i], this.values[i]);
            if (entry == null) continue;
            copy.putInternal(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    @Override
    public <NK, NV> @NonNull ImmutableMap<NK, NV> flatMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Iterable<? extends @NonNull Entry<? extends NK, ? extends NV>>> mapper) {
        ArrayMap<NK, NV> copy = new ArrayMap<NK, NV>(this.size);
        for (int i = 0; i < this.size; ++i) {
            for (Entry<NK, NV> entry : mapper.apply(this.keys[i], this.values[i])) {
                copy.putInternal(entry.getKey(), entry.getValue());
            }
        }
        return copy;
    }

    @Override
    public @NonNull ImmutableMap<K, V> filtered(@NonNull BiPredicate<? super K, ? super V> predicate) {
        Object[] keys = new Object[this.size];
        Object[] values = new Object[this.size];
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            Object k = this.keys[i];
            Object v = this.values[i];
            if (!predicate.test(k, v)) continue;
            keys[index] = k;
            values[index] = v;
            ++index;
        }
        return new ArrayMap<Object, Object>(keys, values, index, true);
    }

    @Override
    public @NonNull ImmutableMap<V, K> inverted() {
        Object[] keys = new Object[this.size];
        Object[] values = new Object[this.size];
        System.arraycopy(this.keys, 0, values, 0, this.size);
        System.arraycopy(this.values, 0, keys, 0, this.size);
        return new ArrayMap<Object, Object>(keys, values, this.size, true);
    }

    @Override
    public @NonNull ImmutableMap<K, V> copy() {
        return this.immutableCopy();
    }

    @Override
    public @NonNull MutableMap<K, V> mutable() {
        return this.mutableCopy();
    }

    @Override
    public @NonNull java.util.Map<K, V> toJava() {
        return Collections.unmodifiableMap(super.toJava());
    }

    public static class Builder<K, V>
    implements ImmutableMap.Builder<K, V> {
        private ArrayMap<K, V> map;

        public Builder() {
            this.map = new ArrayMap();
        }

        public Builder(int capacity) {
            this.map = new ArrayMap(capacity);
        }

        @Override
        public void put(K key, V value) {
            if (this.map == null) {
                throw new IllegalStateException("Already built");
            }
            ((ArrayMap)this.map).putInternal(key, value);
        }

        @Override
        public ArrayMap<K, V> build() {
            ArrayMap<K, V> map = this.map;
            this.map = null;
            return map;
        }
    }
}

