/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.immutable;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Collection;
import dyvil.collection.ImmutableList;
import dyvil.collection.List;
import dyvil.collection.MutableList;
import dyvil.collection.Set;
import dyvil.collection.immutable.EmptyList;
import dyvil.collection.immutable.PrependList;
import dyvil.collection.iterator.AppendIterator;
import dyvil.collection.iterator.PrependIterator;
import dyvil.collection.mutable.LinkedList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

@Immutable
public class AppendList<E>
implements ImmutableList<E> {
    private static final long serialVersionUID = 2683270385507677394L;
    private transient ImmutableList<E> head;
    private transient E tail;
    private transient int size;

    @SafeVarargs
    public static <E> @NonNull ImmutableList<E> apply(E ... elements) {
        ImmutableList list = EmptyList.apply();
        for (E element : elements) {
            list = new AppendList(list, element);
        }
        return list;
    }

    public static <E> @NonNull ImmutableList<E> from(@NonNull Iterable<? extends E> iterable) {
        ImmutableList list = EmptyList.apply();
        for (E element : iterable) {
            list = new AppendList(list, element);
        }
        return list;
    }

    public static <E> @NonNull ImmutableList<E> from(Collection<? extends E> collection) {
        return AppendList.from(collection);
    }

    public static <E> @NonNull Builder<E> builder() {
        return new Builder();
    }

    public AppendList(E element) {
        this.head = EmptyList.instance;
        this.tail = element;
        this.size = 1;
    }

    public AppendList(@NonNull ImmutableList<E> head, E tail) {
        this.head = head;
        this.tail = tail;
        this.size = 1 + head.size();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public @NonNull Iterator<E> iterator() {
        return new AppendIterator<E>(this.head.iterator(), this.tail);
    }

    @Override
    public @NonNull Iterator<E> reverseIterator() {
        return new PrependIterator<E>(this.tail, this.head.reverseIterator());
    }

    @Override
    public @Nullable E subscript(int index) {
        if (index < this.size - 1) {
            return this.head.subscript(index);
        }
        return index == this.size - 1 ? (E)this.tail : null;
    }

    @Override
    public E get(int index) {
        if (index < this.size - 1) {
            return this.head.subscript(index);
        }
        if (index == this.size - 1) {
            return this.tail;
        }
        throw new IndexOutOfBoundsException(index + " >= " + this.size);
    }

    @Override
    public @NonNull ImmutableList<E> subList(int startIndex, int length) {
        if (startIndex + length == this.size - 1) {
            return new AppendList<E>(this.head.subList(startIndex, length - 1), this.tail);
        }
        return this.head.subList(startIndex, length - 1);
    }

    @Override
    public @NonNull ImmutableList<E> added(E element) {
        return new AppendList<E>(this, element);
    }

    @Override
    public @NonNull ImmutableList<E> union(@NonNull Collection<? extends E> collection) {
        AppendList<E> ll = this;
        for (E element : collection) {
            ll = new AppendList<E>(ll, element);
        }
        return ll;
    }

    @Override
    public @NonNull ImmutableList<E> removed(Object element) {
        if (Objects.equals(element, this.tail)) {
            return this.head.removed(element);
        }
        return new AppendList<E>(this.head.removed(element), this.tail);
    }

    @Override
    public @NonNull ImmutableList<E> difference(@NonNull Collection<?> collection) {
        if (collection.contains(this.tail)) {
            return this.head.difference((Collection)collection);
        }
        return new AppendList<E>(this.head.difference((Collection)collection), this.tail);
    }

    @Override
    public @NonNull ImmutableList<E> intersection(@NonNull Collection<? extends E> collection) {
        if (!collection.contains(this.tail)) {
            return this.head.intersection((Collection)collection);
        }
        return new AppendList<E>(this.head.intersection((Collection)collection), this.tail);
    }

    @Override
    public <R> @NonNull ImmutableList<R> mapped(@NonNull Function<? super E, ? extends R> mapper) {
        return new AppendList<R>(this.head.mapped((Function)mapper), mapper.apply(this.tail));
    }

    @Override
    public <R> @NonNull ImmutableList<R> flatMapped(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends R>> mapper) {
        AppendList<R> head = this.head.flatMapped((Function)mapper);
        for (R element : mapper.apply(this.tail)) {
            head = new AppendList<R>(head, element);
        }
        return head;
    }

    @Override
    public @NonNull ImmutableList<E> filtered(@NonNull Predicate<? super E> predicate) {
        if (!predicate.test(this.tail)) {
            return this.head.filtered((Predicate)predicate);
        }
        return new AppendList<E>(this.head.filtered((Predicate)predicate), this.tail);
    }

    @Override
    public @NonNull ImmutableList<E> reversed() {
        return new PrependList<E>(this.tail, this.head.reversed());
    }

    private static <E> @NonNull ImmutableList<E> fromArray(Object[] array, int length) {
        ImmutableList<Object> list = EmptyList.instance;
        for (int i = 0; i < length; ++i) {
            list = new AppendList<Object>(list, array[i]);
        }
        return list;
    }

    @Override
    public @NonNull ImmutableList<E> sorted() {
        Object[] array = this.toArray();
        Arrays.sort(array);
        return AppendList.fromArray(array, this.size);
    }

    @Override
    public @NonNull ImmutableList<E> sorted(@NonNull Comparator<? super E> comparator) {
        Object[] array = this.toArray();
        Arrays.sort(array, comparator);
        return AppendList.fromArray(array, this.size);
    }

    @Override
    public @NonNull ImmutableList<E> distinct() {
        Object[] array = this.toArray();
        int size = Set.distinct(array, this.size);
        return AppendList.fromArray(array, size);
    }

    @Override
    public @NonNull ImmutableList<E> distinct(@NonNull Comparator<? super E> comparator) {
        Object[] array = this.toArray();
        int size = Set.sortDistinct(array, this.size, comparator);
        return AppendList.fromArray(array, size);
    }

    @Override
    public int indexOf(Object element) {
        int i = this.head.indexOf(element);
        if (i < 0) {
            return Objects.equals(element, this.tail) ? this.size - 1 : -1;
        }
        return i;
    }

    @Override
    public int lastIndexOf(Object element) {
        if (Objects.equals(element, this.tail)) {
            return this.size - 1;
        }
        return this.head.lastIndexOf(element);
    }

    @Override
    public void toArray(int index, Object @NonNull [] store) {
        this.head.toArray(index, store);
        store[index + this.size - 1] = this.tail;
    }

    @Override
    public @NonNull ImmutableList<E> copy() {
        return new AppendList<E>(this.head.copy(), this.tail);
    }

    @Override
    public <RE> @NonNull MutableList<RE> emptyCopy() {
        return MutableList.apply();
    }

    @Override
    public <RE> @NonNull MutableList<RE> emptyCopy(int capacity) {
        return MutableList.withCapacity(capacity);
    }

    @Override
    public @NonNull MutableList<E> mutable() {
        LinkedList<E> list = new LinkedList<E>();
        list.addAll(this.head);
        list.addLast(this.tail);
        return list;
    }

    @Override
    public <RE> @NonNull ImmutableList.Builder<RE> immutableBuilder() {
        return AppendList.builder();
    }

    @Override
    public <RE> @NonNull ImmutableList.Builder<RE> immutableBuilder(int capacity) {
        return AppendList.builder();
    }

    @Override
    public @NonNull java.util.List<E> toJava() {
        java.util.LinkedList<E> list = new java.util.LinkedList<E>();
        for (E element : this.head) {
            list.addLast(element);
        }
        list.addLast(this.tail);
        return list;
    }

    @Override
    public @NonNull String toString() {
        return Collection.collectionToString(this);
    }

    @Override
    public boolean equals(Object obj) {
        return List.listEquals(this, obj);
    }

    @Override
    public int hashCode() {
        return List.listHashCode(this);
    }

    private void writeObject(@NonNull ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.head);
        out.writeObject(this.tail);
    }

    private void readObject(@NonNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.head = (ImmutableList)in.readObject();
        this.tail = in.readObject();
        this.size = this.head.size() + 1;
    }

    public static final class Builder<E>
    implements ImmutableList.Builder<E> {
        private ImmutableList<E> list = EmptyList.instance;

        @Override
        public void add(E element) {
            if (this.list == null) {
                throw new IllegalStateException("Already built");
            }
            this.list = new AppendList<E>(this.list, element);
        }

        @Override
        public ImmutableList<E> build() {
            ImmutableList<E> list = this.list;
            this.list = null;
            return list;
        }
    }
}

