/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.ReceiverType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;

@DyvilModifiers(value=262144L)
@DyvilName(value="extension_Ljava_util_TreeSet__")
public class TreeSets {
    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/TreeSet;")
    public static <E extends Comparable<E>> @NonNull TreeSet<E> empty() {
        return new TreeSet();
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/TreeSet;")
    public static <E extends Comparable<E>> @NonNull TreeSet<E> of(E element) {
        TreeSet<E> treeSet = new TreeSet<E>();
        treeSet.add(element);
        return treeSet;
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/TreeSet;")
    public static <E extends Comparable<E>> @NonNull TreeSet<E> of(E ... elements) {
        return new TreeSet<E>(Arrays.asList(elements));
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/TreeSet;")
    public static <E extends Comparable<E>> @NonNull TreeSet<E> copyOf(@DyvilModifiers(value=0x400000L) @NonNull Collection<? extends E> collection) {
        return new TreeSet<E>(collection);
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/TreeSet;")
    public static <E extends Comparable<E>> @NonNull TreeSet<E> copyOf(@DyvilModifiers(value=0x400000L) @NonNull SortedSet<? extends E> sortedSet) {
        return new TreeSet<E>(sortedSet);
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/TreeSet;")
    public static <E> @NonNull TreeSet<E> empty(@DyvilModifiers(value=0x400000L) @NonNull Comparator<? super E> c) {
        return new TreeSet<E>(c);
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/TreeSet;")
    public static <E> @NonNull TreeSet<E> of(E element, @DyvilModifiers(value=0x400000L) @NonNull Comparator<? super E> c) {
        TreeSet<E> treeSet = new TreeSet<E>(c);
        treeSet.add(element);
        return treeSet;
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/TreeSet;")
    public static <E> @NonNull TreeSet<E> of(@DyvilModifiers(value=262144L) E @NonNull [] elements, @DyvilModifiers(value=0x400000L) @NonNull Comparator<? super E> c) {
        TreeSet<? super E> treeSet = new TreeSet<E>(c);
        Collections.addAll(treeSet, elements);
        return treeSet;
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/TreeSet;")
    public static <E> @NonNull TreeSet<E> copyOf(@DyvilModifiers(value=0x400000L) @NonNull Collection<? extends E> col, @DyvilModifiers(value=0x400000L) @NonNull Comparator<? super E> comp) {
        TreeSet<? extends E> treeSet = new TreeSet<E>(comp);
        treeSet.addAll(col);
        return treeSet;
    }
}

