/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.Immutable;
import dyvil.annotation.Mutating;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.annotation.internal.ReceiverType;
import dyvil.function.Function;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

@DyvilModifiers(value=262144L)
@DyvilName(value="extension_Ljava_util_Set_$__TE____$___")
public class Sets {
    @Mutating
    @DyvilModifiers(value=393224L)
    @ReceiverType(value="Ljava/util/Set<TE;>;")
    public static <E> void $bar$eq(@NonNull Set<? super E> lhs, @NonNull Set<? extends E> rhs) {
        lhs.addAll(rhs);
    }

    @Mutating
    @DyvilModifiers(value=393224L)
    @ReceiverType(value="Ljava/util/Set<TE;>;")
    public static void $amp$eq(@NonNull Set<? extends @Primitive Object> lhs, @NonNull Set<? extends @Primitive Object> rhs) {
        lhs.retainAll(rhs);
    }

    @Mutating
    @DyvilModifiers(value=393224L)
    @ReceiverType(value="Ljava/util/Set<TE;>;")
    public static <E> void $up$eq(@NonNull Set<? super E> lhs, @NonNull Set<? extends E> rhs) {
        for (Object e : rhs) {
            if (lhs.contains(e)) {
                lhs.remove(e);
                continue;
            }
            lhs.add(e);
        }
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/Set<TE;>;")
    public static <E> @Immutable @NonNull Set<E> empty() {
        Set set = Collections.emptySet();
        set.getClass();
        return set;
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/Set<TE;>;")
    public static <E> @Immutable @NonNull Set<E> of(E element) {
        Set<E> set = Collections.singleton(element);
        set.getClass();
        return set;
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/Set<TE;>;")
    public static <E> @Immutable @NonNull Set<E> of(E ... elements) {
        return Sets.unmodifiableView(new LinkedHashSet<E>(Arrays.asList(elements)));
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/Set<TE;>;")
    public static <E> @Immutable @NonNull Set<E> copyOf(@DyvilModifiers(value=0x400000L) @NonNull Collection<? extends E> collection) {
        return Sets.unmodifiableView(new LinkedHashSet<E>(collection));
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/Set<TE;>;")
    public static <E> @Immutable @NonNull Set<E> build(@DyvilModifiers(value=131072L) @NonNull Function.Of1<@NonNull Set<E>, @Primitive Void> configure) {
        LinkedHashSet set = new LinkedHashSet();
        configure.apply(set);
        return Sets.unmodifiableView(set);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/Set<TE;>;")
    public static final <E> @NonNull Set<E> synchronizedView(Set<E> this_) {
        Set<E> set = Collections.synchronizedSet(this_);
        set.getClass();
        return set;
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/Set<TE;>;")
    public static final <E> @NonNull Set<E> unmodifiableView(Set<E> this_) {
        Set<E> set = Collections.unmodifiableSet(this_);
        set.getClass();
        return set;
    }
}

