/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.Deprecated;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.collection.Collection;
import dyvil.collection.ImmutableSet;
import dyvil.collection.MutableSet;
import dyvil.lang.LiteralConvertible;
import dyvil.lang.Objects;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;

@Deprecated(replacements={"java.util.Set"})
@LiteralConvertible.FromArray
public interface Set<E>
extends Collection<E> {
    public static <E> @NonNull ImmutableSet<E> empty() {
        return ImmutableSet.apply();
    }

    public static <E> @NonNull MutableSet<E> apply() {
        return MutableSet.apply();
    }

    public static <E> @NonNull ImmutableSet<E> apply(E element) {
        return ImmutableSet.apply(element);
    }

    @SafeVarargs
    public static <E> @NonNull ImmutableSet<E> apply(E ... elements) {
        ImmutableSet<E> immutableSet = ImmutableSet.apply(elements);
        immutableSet.getClass();
        return immutableSet;
    }

    @DyvilName(value="apply")
    public static <E> @NonNull ImmutableSet<E> from(@DyvilModifiers(value=0x400000L) E @NonNull [] array) {
        ImmutableSet<E> immutableSet = ImmutableSet.from(array);
        immutableSet.getClass();
        return immutableSet;
    }

    @DyvilName(value="apply")
    public static <E> @NonNull ImmutableSet<E> from(@DyvilModifiers(value=0x400000L) @NonNull Iterable<? extends E> iterable) {
        ImmutableSet<E> immutableSet = ImmutableSet.from(iterable);
        immutableSet.getClass();
        return immutableSet;
    }

    @DyvilName(value="apply")
    public static <E> @NonNull ImmutableSet<E> from(@DyvilModifiers(value=0x400000L) @NonNull Collection<? extends E> collection) {
        ImmutableSet<E> immutableSet = ImmutableSet.from(collection);
        immutableSet.getClass();
        return immutableSet;
    }

    @Override
    public int size();

    @Override
    default public boolean isDistinct() {
        return true;
    }

    @Override
    public @NonNull Iterator<E> iterator();

    @Override
    default public @NonNull Spliterator<E> spliterator() {
        Spliterator<E> spliterator = Spliterators.spliterator(this.iterator(), (long)this.size(), Spliterator.DISTINCT);
        spliterator.getClass();
        return spliterator;
    }

    @Override
    public @NonNull Set<E> added(E var1);

    @Override
    public @NonNull Set<E> removed(Object var1);

    @Override
    public @NonNull Set<E> union(@NonNull Collection<? extends E> var1);

    @Override
    public @NonNull Set<E> difference(@NonNull Collection<? extends @Primitive Object> var1);

    @Override
    public @NonNull Set<E> intersection(@NonNull Collection<? extends E> var1);

    public @NonNull Set<E> symmetricDifference(@NonNull Collection<? extends E> var1);

    @Override
    public <R> @NonNull Set<R> mapped(@NonNull Function<? super E, ? extends R> var1);

    @Override
    public <R> @NonNull Set<R> flatMapped(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends R>> var1);

    @Override
    public @NonNull Set<E> filtered(@NonNull Predicate<? super E> var1);

    @Override
    public void clear();

    @Override
    public boolean add(E var1);

    @Override
    public boolean remove(Object var1);

    default public boolean unionInplace(@NonNull Collection<? extends E> collection) {
        return this.addAll(collection);
    }

    default public boolean symmetricDifferenceInplace(@NonNull Collection<? extends E> collection) {
        Collection union = this.union((Collection)collection);
        return this.addAll(collection) | this.removeAll(union);
    }

    @Override
    public void map(@NonNull Function<? super E, ? extends E> var1);

    @Override
    public void flatMap(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends E>> var1);

    @Override
    public @NonNull Set<E> copy();

    @Override
    public <RE> @NonNull MutableSet<RE> emptyCopy();

    @Override
    public <RE> @NonNull MutableSet<RE> emptyCopy(int var1);

    @Override
    public @NonNull MutableSet<E> mutable();

    @Override
    public @NonNull MutableSet<E> mutableCopy();

    @Override
    public @NonNull ImmutableSet<E> immutable();

    @Override
    public @NonNull ImmutableSet<E> immutableCopy();

    @Override
    public <RE> @NonNull ImmutableSet.Builder<RE> immutableBuilder();

    @Override
    public <RE> @NonNull ImmutableSet.Builder<RE> immutableBuilder(int var1);

    @Override
    public @NonNull ImmutableSet<E> view();

    @Override
    public @NonNull java.util.Set<E> toJava();

    public static boolean setEquals(@NonNull Set<? extends @Primitive Object> set, @Primitive Object o) {
        return o instanceof Set && Set.setEquals(set, (Set)o);
    }

    public static boolean setEquals(@NonNull Set<? extends @Primitive Object> set1, @NonNull Set<? extends @Primitive Object> set2) {
        return Collection.unorderedEquals(set1, set2);
    }

    public static int setHashCode(@NonNull Set<? extends @Primitive Object> set) {
        return Collection.unorderedHashCode(set);
    }

    /*
     * WARNING - void declaration
     */
    public static int distinct(Object @NonNull [] array, int size) {
        void var1_1;
        if (size < 2) {
            return size;
        }
        for (int i = 0; i < size; ++i) {
            int j = i + 1;
            while (j < size) {
                if (Objects.equals(array[i], array[j])) {
                    array[j] = array[--size];
                    continue;
                }
                ++j;
            }
        }
        return (int)var1_1;
    }

    public static int sortDistinct(Object @NonNull [] array, int size) {
        if (size < 2) {
            return size;
        }
        Arrays.sort(array, 0, size);
        return Set.distinctSorted(array, size);
    }

    public static <T> int sortDistinct(T @NonNull [] array, int size, @NonNull Comparator<? super T> comparator) {
        if (size < 2) {
            return size;
        }
        Arrays.sort(array, 0, size, comparator);
        return Set.distinctSorted(array, size);
    }

    public static int distinctSorted(Object @NonNull [] array, int size) {
        if (size < 2) {
            return size;
        }
        int index = 0;
        int n = size;
        for (int i = 0; i < n; ++i) {
            if (!(!Objects.equals(array[i], array[index]))) continue;
            array[++index] = array[i];
        }
        return index + 1;
    }

    public static boolean isDistinct(Object @NonNull [] array, int size) {
        if (size < 2) {
            return true;
        }
        int n = size;
        for (int i = 0; i < n; ++i) {
            Object o = array[i];
            int n2 = i;
            for (int j = 0; j < n2; ++j) {
                if (!Objects.equals(o, array[j])) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isDistinctSorted(Object @NonNull [] array, int size) {
        if (size < 2) {
            return true;
        }
        int n = size;
        for (int i = 1; i < n; ++i) {
            if (!Objects.equals(array[i - 1], array[i])) continue;
            return false;
        }
        return true;
    }
}

