/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.Immutable;
import dyvil.annotation.Mutating;
import dyvil.annotation.internal.Covariant;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.collection.ImmutableList;
import dyvil.collection.Queryable;
import dyvil.collection.immutable.ArrayList;
import dyvil.collection.range.EmptyRange;
import dyvil.collection.range.Rangeable;
import dyvil.collection.range.halfopen.ObjectRange;
import dyvil.collection.range.specialized.DoubleRange;
import dyvil.collection.range.specialized.FloatRange;
import dyvil.collection.range.specialized.IntRange;
import dyvil.collection.range.specialized.LongRange;
import dyvil.function.Function;
import dyvil.lang.LiteralConvertible;
import dyvil.lang.Objects;
import dyvil.util.ImmutableException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;

@Immutable
@LiteralConvertible.FromTuple
public interface Range<@Covariant T>
extends Queryable<T>,
Serializable {
    @DyvilName(value="apply")
    public static <T> @NonNull Range<T> empty() {
        return EmptyRange.instance;
    }

    @DyvilName(value="apply")
    public static @NonNull IntRange closed(int from, int to) {
        return IntRange.closed(from, to);
    }

    @DyvilName(value="apply")
    public static @NonNull IntRange halfOpen(int from, @DyvilModifiers(value=0x400000L) int toExclusive) {
        return IntRange.halfOpen(from, toExclusive);
    }

    @DyvilName(value="apply")
    public static @NonNull LongRange closed(long from, long to) {
        return LongRange.closed(from, to);
    }

    @DyvilName(value="apply")
    public static @NonNull LongRange halfOpen(long from, @DyvilModifiers(value=0x400000L) long toExclusive) {
        return LongRange.halfOpen(from, toExclusive);
    }

    @DyvilName(value="apply")
    public static @NonNull FloatRange closed(float from, float to) {
        return FloatRange.closed(from, to);
    }

    @DyvilName(value="apply")
    public static @NonNull FloatRange halfOpen(float from, @DyvilModifiers(value=0x400000L) float toExclusive) {
        return FloatRange.halfOpen(from, toExclusive);
    }

    @DyvilName(value="apply")
    public static @NonNull DoubleRange closed(double from, double to) {
        return DoubleRange.closed(from, to);
    }

    @DyvilName(value="apply")
    public static @NonNull DoubleRange halfOpen(double from, @DyvilModifiers(value=0x400000L) double toExclusive) {
        return DoubleRange.halfOpen(from, toExclusive);
    }

    @DyvilName(value="apply")
    public static <T extends Rangeable<T>> @NonNull Range<T> closed(T from, T to) {
        return new dyvil.collection.range.closed.ObjectRange<T>(from, to);
    }

    @DyvilName(value="apply")
    public static <T extends Rangeable<T>> @NonNull Range<T> halfOpen(T from, @DyvilModifiers(value=0x400000L) T toExclusive) {
        return new ObjectRange<T>(from, toExclusive);
    }

    public T first();

    public T last();

    @Override
    public int size();

    public @NonNull Range<T> asHalfOpen();

    public @NonNull Range<T> asClosed();

    public boolean isHalfOpen();

    @Override
    public @NonNull Iterator<T> iterator();

    @Override
    default public @NonNull Spliterator<T> spliterator() {
        int size = this.size();
        int characteristics = Spliterator.ORDERED;
        if (size >= 0) {
            characteristics |= Spliterator.SIZED;
        }
        Spliterator<T> spliterator = Spliterators.spliterator(this.iterator(), (long)size, characteristics);
        spliterator.getClass();
        spliterator.getClass();
        return spliterator;
    }

    @Override
    public boolean contains(@Primitive Object var1);

    @Override
    public void forEach(@NonNull Function.Of1<T, @Primitive Void> var1);

    @Override
    @Mutating
    default public void map(@NonNull Function<? super T, ? extends T> mapper) {
        throw new ImmutableException("map() on Immutable Range");
    }

    @Override
    @Mutating
    default public void flatMap(@NonNull Function<? super T, ? extends @NonNull Iterable<? extends T>> mapper) {
        throw new ImmutableException("flatMap() on Immutable Range");
    }

    @Override
    @Mutating
    default public void filter(@NonNull Predicate<? super T> predicate) {
        throw new ImmutableException("filter() on Immutable Range");
    }

    @Override
    default public <R> @NonNull Queryable<R> mapped(@NonNull Function<? super T, ? extends R> mapper) {
        ArrayList.Builder<R> builder = new ArrayList.Builder<R>(this.size());
        for (Object value : this) {
            builder.add(mapper.apply(value));
        }
        ImmutableList immutableList = builder.build();
        immutableList.getClass();
        immutableList.getClass();
        return immutableList;
    }

    @Override
    default public <R> @NonNull Queryable<R> flatMapped(@NonNull Function<? super T, ? extends @NonNull Iterable<? extends R>> mapper) {
        ArrayList.Builder<R> builder = new ArrayList.Builder<R>(this.size());
        for (Object value : this) {
            for (R result : mapper.apply(value)) {
                builder.add(result);
            }
        }
        ImmutableList immutableList = builder.build();
        immutableList.getClass();
        immutableList.getClass();
        return immutableList;
    }

    @Override
    default public @NonNull Queryable<T> filtered(@NonNull Predicate<? super T> predicate) {
        ArrayList.Builder builder = new ArrayList.Builder(this.size());
        for (Object value : this) {
            if (!predicate.test(value)) continue;
            builder.add(value);
        }
        ImmutableList immutableList = builder.build();
        immutableList.getClass();
        immutableList.getClass();
        return immutableList;
    }

    default public @NonNull Object @NonNull [] toArray() {
        Object[] objectArray = new Object[this.size()];
        this.copy(objectArray, 0);
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    default public <T> T @NonNull [] toArray(@NonNull Class clazz) {
        void var2_2;
        Object[] array = (Object[])Array.newInstance(clazz, this.size());
        this.copy(array, 0);
        return var2_2;
    }

    public @NonNull Range<T> copy();

    default public void copy(Object @NonNull [] to) {
        this.copy(to, 0);
    }

    public void copy(Object @NonNull [] var1, int var2);

    public static boolean rangeEquals(@NonNull Range<? extends @Primitive Object> range, @Primitive Object obj) {
        return obj instanceof Range && Range.rangeEquals(range, (Range)obj);
    }

    public static boolean rangeEquals(@NonNull Range<? extends @Primitive Object> range, @NonNull Range<? extends @Primitive Object> other) {
        return Objects.equals(range.first(), other.first()) && Objects.equals(range.last(), other.last()) && range.size() == other.size();
    }

    public static int rangeHashCode(@NonNull Range<? extends @Primitive Object> range) {
        return (range.first().hashCode() * 31 + range.last().hashCode()) * 31 + range.size();
    }
}

