/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.ImmutableMatrix;
import dyvil.collection.List;
import dyvil.collection.Matrix;
import dyvil.collection.MutableList;
import dyvil.collection.mutable.FlatArrayMatrix;
import dyvil.collection.view.MatrixView;
import dyvil.lang.LiteralConvertible;
import dyvil.tuple.Tuple;
import java.util.function.Function;
import java.util.function.UnaryOperator;

@LiteralConvertible.FromArray
public interface MutableMatrix<E>
extends Matrix<E> {
    public static <E> @NonNull MutableMatrix<E> apply() {
        return new FlatArrayMatrix();
    }

    public static <E> @NonNull MutableMatrix<E> apply(int rows, int columns) {
        return new FlatArrayMatrix(rows, columns);
    }

    public static <E> @NonNull MutableMatrix<E> apply(E[] ... cells) {
        return new FlatArrayMatrix(cells);
    }

    @Override
    default public boolean isImmutable() {
        return false;
    }

    @Override
    public int rows();

    @Override
    public int columns();

    @Override
    public boolean contains(Object var1);

    @Override
    public @NonNull E subscript(int var1, int var2);

    @Override
    public @NonNull E get(int var1, int var2);

    @Override
    public @NonNull MutableMatrix<E> subMatrix(int var1, int var2, int var3, int var4);

    @Override
    public @NonNull MutableList<E> row(int var1);

    @Override
    public @NonNull MutableList<E> column(int var1);

    @Override
    public @NonNull MutableList<E> flatten();

    @Override
    public @NonNull MutableMatrix<E> transposed();

    @Override
    public <R> @NonNull MutableMatrix<R> mapped(@NonNull Function<? super E, ? extends R> var1);

    @Override
    public void resize(int var1, int var2);

    @Override
    public void addRow(List<E> var1);

    @Override
    public void addColumn(List<E> var1);

    @Override
    public void insertRow(int var1, @NonNull List<E> var2);

    @Override
    public void insertColumn(int var1, @NonNull List<E> var2);

    @Override
    public void subscript_$eq(int var1, int var2, E var3);

    @Override
    public @NonNull E set(int var1, int var2, E var3);

    @Override
    public void removeRow(int var1);

    @Override
    public void removeColumn(int var1);

    @Override
    public void clear();

    @Override
    public void transpose();

    @Override
    public void map(@NonNull UnaryOperator<E> var1);

    @Override
    public int rowOf(Object var1);

    @Override
    public int columnOf(Object var1);

    @Override
    public @Nullable Tuple.Of2<Integer, Integer> cellOf(Object var1);

    @Override
    public void rowArray(int var1, Object[] var2);

    @Override
    public void columnArray(int var1, Object[] var2);

    @Override
    public void toArray(Object[][] var1);

    @Override
    public void toCellArray(Object[] var1);

    @Override
    public @NonNull MutableMatrix<E> copy();

    @Override
    default public @NonNull MutableMatrix<E> mutable() {
        return this;
    }

    @Override
    default public @NonNull MutableMatrix<E> mutableCopy() {
        return this.copy();
    }

    @Override
    public @NonNull ImmutableMatrix<E> immutable();

    @Override
    default public @NonNull ImmutableMatrix<E> immutableCopy() {
        return this.immutable();
    }

    @Override
    default public @NonNull ImmutableMatrix<E> view() {
        return new MatrixView(this);
    }
}

