/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Collection;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.Map;
import dyvil.collection.mutable.ArrayMap;
import dyvil.collection.mutable.HashMap;
import dyvil.collection.mutable.TupleMap;
import dyvil.collection.view.MapView;
import dyvil.lang.LiteralConvertible;
import dyvil.util.Option;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;

@Deprecated
@dyvil.annotation.Deprecated(replacements={"java.util.Map"})
@LiteralConvertible.FromArray
@LiteralConvertible.FromMap
public interface MutableMap<K, V>
extends Map<K, V> {
    public static <K, V> @NonNull MutableMap<K, V> apply() {
        return new HashMap();
    }

    public static <K, V> @NonNull MutableMap<K, V> withCapacity(int capacity) {
        return new HashMap(capacity);
    }

    public static <K, V> @NonNull MutableMap<K, V> singleton(K key, V value) {
        return ArrayMap.singleton(key, value);
    }

    public static <K, V> @NonNull MutableMap<K, V> apply(@NonNull Entry<K, V> entry) {
        return TupleMap.apply(new Entry[]{entry});
    }

    @SafeVarargs
    public static <K, V> @NonNull MutableMap<K, V> apply(Entry<? extends K, ? extends V> ... entries) {
        return TupleMap.apply(entries);
    }

    public static <K, V> @NonNull MutableMap<K, V> apply(K @NonNull [] keys, V @NonNull [] values) {
        return new ArrayMap<K, V>(keys, values, true);
    }

    @Override
    default public boolean isImmutable() {
        return false;
    }

    @Override
    public int size();

    @Override
    public @NonNull Iterator<Entry<K, V>> iterator();

    @Override
    public @NonNull Iterator<K> keyIterator();

    @Override
    public @NonNull Iterator<V> valueIterator();

    @Override
    public @Nullable V get(Object var1);

    @Override
    public @Nullable Entry<K, V> getEntry(Object var1);

    @Override
    public @NonNull Option<V> getOption(Object var1);

    @Override
    default public @NonNull MutableMap<K, V> withEntry(K key, V value) {
        Map copy = this.copy();
        copy.subscript_$eq(key, value);
        return copy;
    }

    @Override
    default public @NonNull Map<K, V> withEntry(@NonNull Entry<? extends K, ? extends V> entry) {
        return this.withEntry((Object)entry.getKey(), (Object)entry.getValue());
    }

    @Override
    default public @NonNull MutableMap<K, V> union(@NonNull Map<? extends K, ? extends V> map) {
        Map copy = this.copy();
        copy.putAll(map);
        return copy;
    }

    @Override
    default public @NonNull MutableMap<K, V> keyRemoved(Object key) {
        Map copy = this.copy();
        copy.removeKey(key);
        return copy;
    }

    @Override
    default public @NonNull MutableMap<K, V> removed(Object key, Object value) {
        Map copy = this.copy();
        copy.remove(key, value);
        return copy;
    }

    @Override
    default public @NonNull Map<K, V> removed(@NonNull Entry<?, ?> entry) {
        return this.removed(entry.getKey(), entry.getValue());
    }

    @Override
    default public @NonNull MutableMap<K, V> valueRemoved(Object value) {
        Map copy = this.copy();
        copy.removeValue(value);
        return copy;
    }

    @Override
    default public @NonNull MutableMap<K, V> difference(@NonNull Map<?, ?> map) {
        Map copy = this.copy();
        copy.removeAll(map);
        return copy;
    }

    @Override
    default public @NonNull MutableMap<K, V> keyDifference(@NonNull Collection<?> keys) {
        Map copy = this.copy();
        copy.removeKeys(keys);
        return copy;
    }

    @Override
    default public <NK> MutableMap<NK, V> keyMapped(@NonNull Function<? super K, ? extends NK> mapper) {
        MutableMap copy = this.emptyCopy();
        for (Entry<K, V> entry : this) {
            copy.put(mapper.apply(entry.getKey()), entry.getValue());
        }
        return copy;
    }

    @Override
    default public <NK> MutableMap<NK, V> keyMapped(@NonNull BiFunction<? super K, ? super V, ? extends NK> mapper) {
        MutableMap copy = this.emptyCopy();
        for (Entry<K, V> entry : this) {
            V value = entry.getValue();
            copy.put(mapper.apply(entry.getKey(), value), value);
        }
        return copy;
    }

    @Override
    default public <NV> MutableMap<K, NV> valueMapped(@NonNull Function<? super V, ? extends NV> mapper) {
        MutableMap copy = this.emptyCopy();
        for (Entry<K, V> entry : this) {
            copy.put(entry.getKey(), mapper.apply(entry.getValue()));
        }
        return copy;
    }

    @Override
    default public <NV> MutableMap<K, NV> valueMapped(@NonNull BiFunction<? super K, ? super V, ? extends NV> mapper) {
        MutableMap copy = this.emptyCopy();
        for (Entry<K, V> entry : this) {
            K key = entry.getKey();
            copy.put(key, mapper.apply(key, entry.getValue()));
        }
        return copy;
    }

    @Override
    default public <NK, NV> MutableMap<NK, NV> entryMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Entry<? extends NK, ? extends NV>> mapper) {
        MutableMap<NK, NV> copy = this.emptyCopy();
        for (Entry<K, V> entry : this) {
            Entry<? extends NK, ? extends NV> newEntry = mapper.apply(entry.getKey(), entry.getValue());
            if (newEntry == null) continue;
            copy.put(newEntry);
        }
        return copy;
    }

    @Override
    default public <NK, NV> MutableMap<NK, NV> flatMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Iterable<? extends @NonNull Entry<? extends NK, ? extends NV>>> mapper) {
        MutableMap<NK, NV> copy = this.emptyCopy();
        for (Entry<K, V> entry : this) {
            for (Entry<NK, NV> entry2 : mapper.apply(entry.getKey(), entry.getValue())) {
                copy.put(entry2);
            }
        }
        return copy;
    }

    @Override
    default public @NonNull MutableMap<K, V> filtered(@NonNull BiPredicate<? super K, ? super V> predicate) {
        Map copy = this.copy();
        copy.filter(predicate);
        return copy;
    }

    @Override
    default public @NonNull MutableMap<K, V> filteredByKey(@NonNull Predicate<? super K> predicate) {
        Map copy = this.copy();
        copy.filterByKey(predicate);
        return copy;
    }

    @Override
    default public @NonNull MutableMap<K, V> filteredByValue(@NonNull Predicate<? super V> predicate) {
        Map copy = this.copy();
        copy.filterByValue(predicate);
        return copy;
    }

    @Override
    default public @NonNull MutableMap<V, K> inverted() {
        MutableMap map = this.emptyCopy();
        for (Entry<K, V> entry : this) {
            map.put(entry.getValue(), entry.getKey());
        }
        return map;
    }

    @Override
    public void clear();

    @Override
    default public void subscript_$eq(K key, V value) {
        this.put(key, value);
    }

    @Override
    public @Nullable V put(K var1, V var2);

    @Override
    default public @Nullable V put(@NonNull Entry<? extends K, ? extends V> entry) {
        return this.put(entry.getKey(), entry.getValue());
    }

    @Override
    default public void putAll(@NonNull Map<? extends K, ? extends V> map) {
        for (Entry<K, V> entry : map) {
            this.put(entry);
        }
    }

    @Override
    public @Nullable V putIfAbsent(K var1, V var2);

    @Override
    default public @Nullable V putIfAbsent(@NonNull Entry<? extends K, ? extends V> entry) {
        return this.putIfAbsent(entry.getKey(), entry.getValue());
    }

    @Override
    public boolean replace(K var1, V var2, V var3);

    @Override
    public @Nullable V replace(K var1, V var2);

    @Override
    default public @Nullable V replace(@NonNull Entry<? extends K, ? extends V> entry) {
        return this.replace(entry.getKey(), entry.getValue());
    }

    @Override
    default public @Nullable V remap(Object key, K newKey) {
        V value = this.removeKey(key);
        if (value != null) {
            this.put(newKey, value);
        }
        return value;
    }

    @Override
    public @Nullable V removeKey(Object var1);

    @Override
    public boolean removeValue(Object var1);

    @Override
    public boolean remove(Object var1, Object var2);

    @Override
    default public boolean remove(@NonNull Entry<?, ?> entry) {
        return this.remove(entry.getKey(), entry.getValue());
    }

    @Override
    default public boolean removeKeys(@NonNull Collection<?> keys) {
        boolean removed = false;
        for (Object key : keys) {
            if (this.removeKey(key) == null) continue;
            removed = true;
        }
        return removed;
    }

    @Override
    default public boolean removeAll(@NonNull Map<?, ?> map) {
        boolean removed = false;
        for (Entry<?, ?> entry : map) {
            if (!this.remove(entry)) continue;
            removed = true;
        }
        return removed;
    }

    @Override
    default public void mapKeys(@NonNull Function<? super K, ? extends K> mapper) {
        int size = this.size();
        Entry<K, V>[] entries = this.toArray();
        this.clear();
        for (int i = 0; i < size; ++i) {
            Entry entry = entries[i];
            this.put(mapper.apply(entry.getKey()), entry.getValue());
        }
    }

    @Override
    default public void mapKeys(@NonNull BiFunction<? super K, ? super V, ? extends K> mapper) {
        int size = this.size();
        Entry<K, V>[] entries = this.toArray();
        this.clear();
        for (int i = 0; i < size; ++i) {
            Entry entry = entries[i];
            Object value = entry.getValue();
            this.put(mapper.apply(entry.getKey(), value), value);
        }
    }

    @Override
    default public void mapValues(@NonNull Function<? super V, ? extends V> mapper) {
        int size = this.size();
        Entry<K, V>[] entries = this.toArray();
        this.clear();
        for (int i = 0; i < size; ++i) {
            Entry entry = entries[i];
            this.put(entry.getKey(), mapper.apply(entry.getValue()));
        }
    }

    @Override
    default public void mapValues(@NonNull BiFunction<? super K, ? super V, ? extends V> mapper) {
        int size = this.size();
        Entry<K, V>[] entries = this.toArray();
        this.clear();
        for (int i = 0; i < size; ++i) {
            Entry entry = entries[i];
            Object key = entry.getKey();
            this.put(key, mapper.apply(key, entry.getValue()));
        }
    }

    @Override
    default public void mapEntries(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Entry<? extends K, ? extends V>> mapper) {
        int size = this.size();
        Entry<K, V>[] entries = this.toArray();
        this.clear();
        for (int i = 0; i < size; ++i) {
            Entry entry = entries[i];
            Entry<? extends K, ? extends V> newEntry = mapper.apply(entry.getKey(), entry.getValue());
            if (newEntry == null) continue;
            this.put(newEntry);
        }
    }

    @Override
    default public void flatMap(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>>> mapper) {
        Entry<K, V>[] entries = this.toArray();
        this.clear();
        for (Entry entry : entries) {
            for (Entry<K, V> entry2 : mapper.apply(entry.getKey(), entry.getValue())) {
                this.put(entry2);
            }
        }
    }

    @Override
    public void filter(@NonNull BiPredicate<? super K, ? super V> var1);

    @Override
    default public void filterByKey(@NonNull Predicate<? super K> condition) {
        this.filter((k, v) -> condition.test((Object)k));
    }

    @Override
    default public void filterByValue(@NonNull Predicate<? super V> condition) {
        this.filter((k, v) -> condition.test((Object)v));
    }

    @Override
    public @NonNull MutableMap<K, V> copy();

    @Override
    default public @NonNull MutableMap<K, V> mutable() {
        return this;
    }

    @Override
    default public @NonNull MutableMap<K, V> mutableCopy() {
        return this.copy();
    }

    @Override
    public <NK, NV> @NonNull MutableMap<NK, NV> emptyCopy();

    @Override
    default public <RK, RV> @NonNull MutableMap<RK, RV> emptyCopy(int capacity) {
        return this.emptyCopy();
    }

    @Override
    public @NonNull ImmutableMap<K, V> immutable();

    @Override
    public <RK, RV> @NonNull ImmutableMap.Builder<RK, RV> immutableBuilder();

    @Override
    default public <RK, RV> @NonNull ImmutableMap.Builder<RK, RV> immutableBuilder(int capacity) {
        return this.immutableBuilder();
    }

    @Override
    default public @NonNull ImmutableMap<K, V> immutableCopy() {
        return this.immutable();
    }

    @Override
    default public @NonNull ImmutableMap<K, V> view() {
        return new MapView(this);
    }

    @Override
    public @NonNull java.util.Map<K, V> toJava();
}

