/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Collection;
import dyvil.collection.ImmutableList;
import dyvil.collection.List;
import dyvil.collection.MutableCollection;
import dyvil.collection.mutable.ArrayList;
import dyvil.collection.view.ListView;
import dyvil.lang.LiteralConvertible;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;

@Deprecated
@dyvil.annotation.Deprecated(replacements={"java.util.List"})
@LiteralConvertible.FromArray
public interface MutableList<E>
extends List<E>,
MutableCollection<E> {
    public static <E> @NonNull MutableList<E> apply() {
        return new ArrayList();
    }

    public static <E> @NonNull MutableList<E> withCapacity(int capacity) {
        return new ArrayList(capacity);
    }

    public static <E> @NonNull MutableList<E> apply(E element) {
        return ArrayList.apply(new Object[]{element});
    }

    public static <E> @NonNull MutableList<E> apply(E e1, E e2) {
        return ArrayList.apply(new Object[]{e1, e2});
    }

    public static <E> @NonNull MutableList<E> apply(E e1, E e2, E e3) {
        return ArrayList.apply(new Object[]{e1, e2, e3});
    }

    @SafeVarargs
    public static <E> @NonNull MutableList<E> apply(E ... elements) {
        return ArrayList.apply(elements);
    }

    public static <E> @NonNull MutableList<E> from(E @NonNull [] array) {
        return ArrayList.from(array);
    }

    public static <E> @NonNull MutableList<E> from(@NonNull Iterable<? extends E> iterable) {
        return ArrayList.from(iterable);
    }

    public static <E> @NonNull MutableList<E> from(@NonNull Collection<? extends E> collection) {
        return ArrayList.from(collection);
    }

    @Override
    public int size();

    @Override
    public @NonNull Iterator<E> iterator();

    @Override
    public @NonNull Iterator<E> reverseIterator();

    @Override
    public E get(int var1);

    @Override
    default public @NonNull MutableList<E> subList(int startIndex, int length) {
        MutableCollection result = this.emptyCopy(length);
        for (int i = 0; i < length; ++i) {
            result.add(this.get(startIndex + i));
        }
        return result;
    }

    @Override
    default public @NonNull MutableList<E> added(E element) {
        List copy = this.copy();
        copy.addElement(element);
        return copy;
    }

    @Override
    default public @NonNull MutableList<E> removed(@Nullable Object element) {
        MutableCollection copy = this.emptyCopy();
        if (element == null) {
            for (E e : this) {
                if (e == null) continue;
                copy.add(e);
            }
        } else {
            for (E e : this) {
                if (element.equals(e)) continue;
                copy.add(e);
            }
        }
        return copy;
    }

    @Override
    default public @NonNull MutableList<E> difference(@NonNull Collection<?> collection) {
        MutableCollection copy = this.emptyCopy();
        for (E e : this) {
            if (collection.contains(e)) continue;
            copy.add(e);
        }
        return copy;
    }

    @Override
    default public @NonNull MutableList<E> union(@NonNull Collection<? extends E> collection) {
        MutableList<E> copy = this.copy(this.size() + collection.size());
        copy.addAll(collection);
        return copy;
    }

    @Override
    default public @NonNull MutableList<E> intersection(@NonNull Collection<? extends E> collection) {
        MutableCollection copy = this.emptyCopy(Math.min(this.size(), collection.size()));
        for (E e : this) {
            if (!collection.contains(e)) continue;
            copy.add(e);
        }
        return copy;
    }

    @Override
    default public <R> @NonNull MutableList<R> mapped(@NonNull Function<? super E, ? extends R> mapper) {
        List copy = this.copy();
        copy.map(mapper);
        return copy;
    }

    @Override
    default public <R> @NonNull MutableList<R> flatMapped(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends R>> mapper) {
        MutableCollection copy = this.emptyCopy(this.size() << 2);
        for (E e : this) {
            for (R r : mapper.apply(e)) {
                copy.add(r);
            }
        }
        return copy;
    }

    @Override
    default public @NonNull MutableList<E> filtered(@NonNull Predicate<? super E> predicate) {
        MutableCollection copy = this.emptyCopy();
        for (E e : this) {
            if (!predicate.test(e)) continue;
            copy.add(e);
        }
        return copy;
    }

    @Override
    default public @NonNull List<E> reversed() {
        MutableCollection result = this.emptyCopy(this.size());
        Iterator<E> iterator = this.reverseIterator();
        while (iterator.hasNext()) {
            E element = iterator.next();
            result.add(element);
        }
        return result;
    }

    @Override
    default public @NonNull MutableList<E> sorted() {
        List copy = this.copy();
        copy.sort();
        return copy;
    }

    @Override
    default public @NonNull MutableList<E> sorted(@NonNull Comparator<? super E> comparator) {
        List copy = this.copy();
        copy.sort(comparator);
        return copy;
    }

    @Override
    default public @NonNull MutableList<E> distinct() {
        List copy = this.copy();
        copy.distinguish();
        return copy;
    }

    @Override
    default public @NonNull MutableList<E> distinct(@NonNull Comparator<? super E> comparator) {
        List copy = this.copy();
        copy.distinct((Comparator)comparator);
        return copy;
    }

    @Override
    public void addElement(E var1);

    @Override
    public @Nullable E set(int var1, E var2);

    @Override
    public @Nullable E setResizing(int var1, E var2);

    @Override
    public void insert(int var1, E var2);

    @Override
    default public boolean add(E element) {
        this.addElement(element);
        return true;
    }

    @Override
    public void removeAt(int var1);

    @Override
    public boolean remove(Object var1);

    @Override
    public void clear();

    @Override
    public void map(@NonNull Function<? super E, ? extends E> var1);

    @Override
    public void flatMap(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends E>> var1);

    @Override
    public void reverse();

    @Override
    public void sort();

    @Override
    public void sort(@NonNull Comparator<? super E> var1);

    @Override
    public void distinguish();

    @Override
    public void distinguish(@NonNull Comparator<? super E> var1);

    @Override
    public int indexOf(Object var1);

    @Override
    public int lastIndexOf(Object var1);

    @Override
    public @NonNull MutableList<E> copy();

    default public @NonNull MutableList<E> copy(int capacity) {
        return this.copy();
    }

    @Override
    default public @NonNull MutableList<E> mutable() {
        return this;
    }

    @Override
    default public @NonNull MutableList<E> mutableCopy() {
        return this.copy();
    }

    @Override
    public <R> @NonNull MutableList<R> emptyCopy();

    @Override
    default public <R> @NonNull MutableList<R> emptyCopy(int newCapacity) {
        return this.emptyCopy();
    }

    @Override
    public @NonNull ImmutableList<E> immutable();

    @Override
    default public @NonNull ImmutableList<E> immutableCopy() {
        return this.immutable();
    }

    @Override
    public <RE> ImmutableList.Builder<RE> immutableBuilder();

    @Override
    public <RE> ImmutableList.Builder<RE> immutableBuilder(int var1);

    @Override
    default public @NonNull ImmutableList<E> view() {
        return new ListView(this);
    }
}

