/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.annotation.internal.Primitive;
import dyvil.collection.ImmutableMatrix;
import dyvil.collection.List;
import dyvil.collection.MutableMatrix;
import dyvil.lang.LiteralConvertible;
import dyvil.tuple.Tuple;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@LiteralConvertible.FromArray
public interface Matrix<E>
extends Iterable<E>,
Serializable {
    public static <E> @NonNull MutableMatrix<E> apply() {
        return MutableMatrix.apply();
    }

    public static <E> @NonNull MutableMatrix<E> apply(int rows, int columns) {
        return MutableMatrix.apply(rows, columns);
    }

    public static <E> @NonNull ImmutableMatrix<E> apply(E[] ... elements) {
        return ImmutableMatrix.apply(elements);
    }

    public boolean isImmutable();

    public int rows();

    public int columns();

    default public int cells() {
        return this.rows() * this.columns();
    }

    default public boolean isEmpty() {
        return this.rows() == 0 || this.columns() == 0;
    }

    @Override
    public @NonNull Iterator<E> iterator();

    @Override
    default public @NonNull Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.cells(), 64);
    }

    default public @NonNull Stream<E> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public @NonNull Stream<E> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    public boolean contains(Object var1);

    public E subscript(int var1, int var2);

    public E get(int var1, int var2);

    public @NonNull Matrix<E> subMatrix(int var1, int var2, int var3, int var4);

    public @NonNull List<E> row(int var1);

    public @NonNull List<E> column(int var1);

    public @NonNull List<E> flatten();

    public @NonNull Matrix<E> transposed();

    public <R> @NonNull Matrix<R> mapped(@NonNull Function<? super E, ? extends R> var1);

    public void resize(int var1, int var2);

    public void addRow(List<E> var1);

    public void addColumn(List<E> var1);

    public void insertRow(int var1, @NonNull List<E> var2);

    public void insertColumn(int var1, @NonNull List<E> var2);

    public void subscript_$eq(int var1, int var2, E var3);

    public E set(int var1, int var2, E var3);

    public void removeRow(int var1);

    public void removeColumn(int var1);

    public void clear();

    public void transpose();

    public void map(@NonNull UnaryOperator<E> var1);

    public int rowOf(Object var1);

    public int columnOf(Object var1);

    public @Nullable Tuple.Of2<@Primitive Integer, @Primitive Integer> cellOf(Object var1);

    default public Object @NonNull [] rowArray(int row) {
        Object[] array = new Object[this.columns()];
        this.rowArray(row, array);
        return array;
    }

    default public E @NonNull [] rowArray(int row, @NonNull Class<E> type) {
        Object[] array = (Object[])Array.newInstance(type, this.columns());
        this.rowArray(row, array);
        return array;
    }

    public void rowArray(int var1, Object[] var2);

    default public Object @NonNull [] columnArray(int column) {
        Object[] array = new Object[this.rows()];
        this.columnArray(column, array);
        return array;
    }

    default public E @NonNull [] columnArray(int column, @NonNull Class<E> type) {
        Object[] array = (Object[])Array.newInstance(type, this.rows());
        return array;
    }

    public void columnArray(int var1, Object @NonNull [] var2);

    default public @NonNull Object @NonNull [] @NonNull [] toArray() {
        Object[][] array = new Object[this.rows()][this.columns()];
        this.toArray(array);
        return array;
    }

    default public @NonNull E @NonNull [] @NonNull [] toArray(@NonNull Class<E> type) {
        Object[][] array = (Object[][])Array.newInstance(type, this.rows(), this.columns());
        this.toArray(array);
        return array;
    }

    public void toArray(Object @NonNull [] @NonNull [] var1);

    default public Object @NonNull [] toFlatArray() {
        Object[] array = new Object[this.cells()];
        this.toCellArray(array);
        return array;
    }

    default public E @NonNull [] toCellArray(@NonNull Class<E> type) {
        Object[] array = (Object[])Array.newInstance(type, this.cells());
        this.toCellArray(array);
        return array;
    }

    public void toCellArray(Object @NonNull [] var1);

    public @NonNull Matrix<E> copy();

    public @NonNull MutableMatrix<E> mutable();

    public @NonNull MutableMatrix<E> mutableCopy();

    public @NonNull ImmutableMatrix<E> immutable();

    public @NonNull ImmutableMatrix<E> immutableCopy();

    public @NonNull ImmutableMatrix<E> view();

    public @NonNull String toString();

    public boolean equals(Object var1);

    public int hashCode();

    public static <E> String matrixToString(@NonNull Matrix<E> matrix) {
        if (matrix.isEmpty()) {
            return "[[]]";
        }
        int columns = matrix.columns();
        int column = 0;
        StringBuilder builder = new StringBuilder("[[");
        Iterator<E> iterator = matrix.iterator();
        while (true) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) break;
            if (++column >= columns) {
                builder.append("], [");
                column = 0;
                continue;
            }
            builder.append(", ");
        }
        return builder.append("]]").toString();
    }

    public static <E> boolean matrixEquals(@NonNull Matrix<E> matrix, Object o) {
        if (!(o instanceof Matrix)) {
            return false;
        }
        return Matrix.matrixEquals(matrix, (Matrix)o);
    }

    public static <E> boolean matrixEquals(@NonNull Matrix<E> m1, @NonNull Matrix<E> m2) {
        int rows = m1.rows();
        if (rows != m2.rows()) {
            return false;
        }
        int columns = m1.columns();
        if (columns != m2.columns()) {
            return false;
        }
        Iterator<E> iterator1 = m1.iterator();
        Iterator<E> iterator2 = m2.iterator();
        while (iterator1.hasNext()) {
            E e2;
            E e1 = iterator1.next();
            if (Objects.equals(e1, e2 = iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static <E> int matrixHashCode(@NonNull Matrix<E> matrix) {
        int result = matrix.rows() * 31 + matrix.columns();
        for (E o : matrix) {
            result = result * 31 + (o == null ? 0 : o.hashCode());
        }
        return result;
    }
}

