/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection;

import dyvil.annotation.Immutable;
import dyvil.annotation.Mutating;
import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.annotation.internal.ReceiverType;
import dyvil.function.Function;
import dyvil.ref.ObjectRef;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@DyvilModifiers(value=262144L)
@DyvilName(value="extension_Ljava_util_Map_$__TK__TV____$___")
public class Maps {
    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/Map<TK;TV;>;")
    public static <K, V> @Immutable @NonNull Map<K, V> empty() {
        Map map = Collections.emptyMap();
        map.getClass();
        return map;
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/Map<TK;TV;>;")
    public static <K, V> @Immutable @NonNull Map<K, V> copyOf(@DyvilModifiers(value=0x400000L) @NonNull Map<? extends K, ? extends V> map) {
        return Maps.unmodifiableView(new LinkedHashMap<K, V>(map));
    }

    @DyvilModifiers(value=262152L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/util/Map<TK;TV;>;")
    public static <K, V> @Immutable @NonNull Map<K, V> build(@DyvilModifiers(value=131072L) @NonNull Function.Of1<@NonNull Map<K, V>, @Primitive Void> configure) {
        LinkedHashMap map = new LinkedHashMap();
        configure.apply(map);
        return Maps.unmodifiableView(map);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/Map<TK;TV;>;")
    public static final <K, V> V subscript(Map<K, V> this_, K key) {
        return this_.get(key);
    }

    @Mutating
    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/Map<TK;TV;>;")
    public static final <K, V> void subscript_$eq(Map<K, V> this_, K key, V newValue) {
        this_.put(key, newValue);
    }

    @Mutating
    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/Map<TK;TV;>;")
    public static final <K, V> @NonNull ObjectRef<V> subscript_$amp(Map<K, V> this_, K key) {
        return new MapRef<K, V>(this_, key);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/Map<TK;TV;>;")
    public static final <K, V> @NonNull Map<K, V> synchronizedView(Map<K, V> this_) {
        Map<K, V> map = Collections.synchronizedMap(this_);
        map.getClass();
        return map;
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/util/Map<TK;TV;>;")
    public static final <K, V> @NonNull Map<K, V> unmodifiableView(Map<K, V> this_) {
        Map<K, V> map = Collections.unmodifiableMap(this_);
        map.getClass();
        return map;
    }

    @ClassParameters(names={"map", "key"})
    private static class MapRef<K, V>
    implements ObjectRef<V> {
        protected final @NonNull Map<K, V> map;
        protected final K key;

        public MapRef(@NonNull Map<K, V> map, K key) {
            this.map = map;
            this.key = key;
        }

        @Override
        public V get() {
            return this.map.get(this.key);
        }

        @Override
        public void set(V value) {
            this.map.put(this.key, value);
        }
    }
}

